/*
 * Decompiled with CFR 0.152.
 */
package top.kmar.game.map;

import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.kmar.game.ConsolePrinter;
import top.kmar.game.EventListener;
import top.kmar.game.map.GEntity;
import top.kmar.game.map.MapLayout;
import top.kmar.game.map.SafeGraphics;
import top.kmar.game.map.SafeGraphicsKt;
import top.kmar.game.utils.GTimer;
import top.kmar.game.utils.Point2D;
import top.kmar.game.utils.Rect2D;
import top.kmar.game.utils.TaskManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 =2\u00020\u0001:\u0003;<=B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010*\u001a\u00020\bJ\b\u0010+\u001a\u00020\rH\u0016J\u0006\u0010,\u001a\u00020\rJ\u0016\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u0003J\u0016\u00100\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'J\u0006\u00101\u001a\u00020\rJ&\u00102\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u000204R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001b\u00a8\u0006>"}, d2={"Ltop/kmar/game/map/GMap;", "Ljava/io/Closeable;", "width", "", "height", "(II)V", "allEntity", "Ljava/util/stream/Stream;", "Ltop/kmar/game/map/GEntity;", "getAllEntity", "()Ljava/util/stream/Stream;", "clear", "Lkotlin/Function0;", "", "getClear", "()Lkotlin/jvm/functions/Function0;", "setClear", "(Lkotlin/jvm/functions/Function0;)V", "closed", "", "collisibleEntity", "getCollisibleEntity", "entities", "Ltop/kmar/game/map/MapLayout;", "<set-?>", "fps", "getFps", "()I", "getHeight", "reusableTaskManager", "Ltop/kmar/game/utils/TaskManager;", "stopped", "taskManager", "visibleEntity", "getVisibleEntity", "getWidth", "appendReusableTask", "flag", "task", "Ljava/lang/Runnable;", "appendTask", "checkCollision", "from", "close", "interrupt", "putEntity", "entity", "layout", "removeReusableTask", "render", "start", "eventInterval", "", "logicInterval", "renderInterval", "logicCondition", "Ljava/util/function/BooleanSupplier;", "update", "time", "Builder", "BuilderJava", "Companion", "cg-engine"})
@SourceDebugExtension(value={"SMAP\nGMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMap.kt\ntop/kmar/game/map/GMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,374:1\n1#2:375\n*E\n"})
public final class GMap
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final MapLayout entities;
    @NotNull
    private final TaskManager taskManager;
    @NotNull
    private final TaskManager reusableTaskManager;
    private volatile boolean closed;
    private volatile boolean stopped;
    @NotNull
    private Function0<Unit> clear;
    private volatile int fps;
    public static final int BEFORE_UPDATE = 0;
    public static final int AFTER_UPDATE = 1;
    public static final int BEFORE_RENDER = 2;
    public static final int AFTER_RENDER = 3;
    public static final int AFTER_LOGIC = 4;

    private GMap(int width, int height) {
        this.width = width;
        this.height = height;
        this.entities = new MapLayout(this);
        this.taskManager = new TaskManager(5);
        this.reusableTaskManager = new TaskManager(5);
        this.clear = GMap::clear$lambda$0;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Function0<Unit> getClear() {
        return this.clear;
    }

    public final void setClear(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.clear = function0;
    }

    public final int getFps() {
        return this.fps;
    }

    @NotNull
    public final Stream<GEntity> getAllEntity() {
        return this.entities.getAllEntities();
    }

    @NotNull
    public final Stream<GEntity> getVisibleEntity() {
        return this.entities.getVisibleEntities();
    }

    @NotNull
    public final Stream<GEntity> getCollisibleEntity() {
        return this.entities.getCollisibleEntities();
    }

    @NotNull
    public final Stream<GEntity> checkCollision(@NotNull GEntity from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (!from.getCollisible()) {
            Stream<GEntity> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty()");
            return stream;
        }
        Rect2D bound = from.getBound();
        Set collision = from.getCollision(0, 0, from.getWidth(), from.getHeight()).map(arg_0 -> GMap.checkCollision$lambda$2(arg_0 -> GMap.checkCollision$lambda$1(from, arg_0), arg_0)).collect(Collectors.toSet());
        Stream<Object> stream = this.getCollisibleEntity().filter(arg_0 -> GMap.checkCollision$lambda$4(arg_0 -> GMap.checkCollision$lambda$3(from, arg_0), arg_0)).filter(arg_0 -> GMap.checkCollision$lambda$10(arg_0 -> GMap.checkCollision$lambda$9(bound, collision, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"collisibleEntity\n       \u2026collision }\n            }");
        return stream;
    }

    public final void putEntity(@NotNull GEntity entity, int layout) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entities.add(entity, layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render() {
        if (!(!this.closed)) {
            boolean $i$a$-require-GMap$render$22 = false;
            String $i$a$-require-GMap$render$22 = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException($i$a$-require-GMap$render$22.toString());
        }
        this.clear.invoke();
        this.taskManager.runTaskList(2);
        this.reusableTaskManager.runTaskListNoRemove(2);
        Lock lock = this.entities.getLock();
        lock.lock();
        try {
            boolean bl = false;
            this.getVisibleEntity().forEach(arg_0 -> GMap.render$lambda$14$lambda$13(arg_0 -> GMap.render$lambda$14$lambda$12(this, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.taskManager.runTaskList(3);
        this.reusableTaskManager.runTaskListNoRemove(3);
        ConsolePrinter.flush$default(0, 1, null);
    }

    public final void appendTask(int flag, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.taskManager.add(flag, task);
    }

    public final void appendReusableTask(int flag, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.reusableTaskManager.add(flag, task);
    }

    public final void removeReusableTask(int flag, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.reusableTaskManager.removeTask(flag, task);
    }

    public final void start(long eventInterval, long logicInterval, long renderInterval, @NotNull BooleanSupplier logicCondition) {
        Intrinsics.checkNotNullParameter((Object)logicCondition, (String)"logicCondition");
        if (!(eventInterval > 0L && logicInterval > 0L && renderInterval > 0L)) {
            boolean $i$a$-require-GMap$start$32 = false;
            String $i$a$-require-GMap$start$32 = "eventInterval[" + eventInterval + "]\u3001logicInterval[" + logicInterval + "] \u548c renderInterval[" + renderInterval + "] \u5747\u5e94\u5927\u4e8e 0";
            throw new IllegalArgumentException($i$a$-require-GMap$start$32.toString());
        }
        if (!(!this.closed)) {
            boolean $i$a$-require-GMap$start$42 = false;
            String $i$a$-require-GMap$start$42 = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException($i$a$-require-GMap$start$42.toString());
        }
        GTimer eventTimer = new GTimer();
        eventTimer.startNonFixed("Event Thread", eventInterval, true, GMap::start$lambda$17);
        GTimer logicTimer = new GTimer();
        logicTimer.start("Logic Thread", logicInterval, false, arg_0 -> GMap.start$lambda$18(this, logicCondition, logicTimer, arg_0));
        GTimer renderTimer = new GTimer();
        renderTimer.start("Render Thread", renderInterval, false, arg_0 -> GMap.start$lambda$19(this, arg_0));
        do {
            Thread.sleep(1000L);
        } while (logicTimer.getAlive() && renderTimer.getAlive());
        logicTimer.cancel();
        renderTimer.cancel();
        eventTimer.cancel();
    }

    public final void interrupt() {
        this.stopped = true;
    }

    public final void update(long time) {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException(string.toString());
        }
        this.taskManager.runTaskList(0);
        this.reusableTaskManager.runTaskListNoRemove(0);
        this.getAllEntity().forEach(arg_0 -> GMap.update$lambda$22(arg_0 -> GMap.update$lambda$21(this, time, arg_0), arg_0));
        this.taskManager.runTaskList(1);
        this.reusableTaskManager.runTaskListNoRemove(1);
    }

    @Override
    public void close() {
        this.stopped = true;
        this.closed = true;
        Iterator iterator = Builder.getList$cg_engine().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"list.iterator()");
        Iterator itor = iterator;
        while (itor.hasNext()) {
            GMap item = (GMap)((WeakReference)itor.next()).get();
            if (item == null) {
                itor.remove();
                continue;
            }
            if (!Intrinsics.areEqual((Object)item, (Object)this)) continue;
            itor.remove();
            break;
        }
    }

    private static final Unit clear$lambda$0() {
        ConsolePrinter.quickClear$default('\u0000', 0, 0, 7, null);
        return Unit.INSTANCE;
    }

    private static final Point2D checkCollision$lambda$1(GEntity $from, Point2D it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        return new Point2D(it.getX() + $from.getX(), it.getY() + $from.getY());
    }

    private static final Point2D checkCollision$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Point2D)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$3(GEntity $from, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        return !Intrinsics.areEqual((Object)it, (Object)$from);
    }

    private static final boolean checkCollision$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Point2D checkCollision$lambda$9$lambda$5(GEntity $entity, Point2D it) {
        return new Point2D(it.getX() + $entity.getX(), it.getY() + $entity.getY());
    }

    private static final Point2D checkCollision$lambda$9$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Point2D)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$9$lambda$7(Set $collision, Point2D it) {
        return $collision.contains(it);
    }

    private static final boolean checkCollision$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$9(Rect2D $bound, Set $collision, GEntity entity) {
        Intrinsics.checkNotNullParameter((Object)$bound, (String)"$bound");
        Rect2D itBound = entity.getBound();
        if (!$bound.hasIntersection(itBound)) {
            return false;
        }
        Rect2D rect2D = $bound.intersect(entity.getBound());
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
        Rect2D rect = rect2D.mapToEntity(entity);
        return entity.getCollision(rect).map(arg_0 -> GMap.checkCollision$lambda$9$lambda$6(arg_0 -> GMap.checkCollision$lambda$9$lambda$5(entity, arg_0), arg_0)).anyMatch(arg_0 -> GMap.checkCollision$lambda$9$lambda$8(arg_0 -> GMap.checkCollision$lambda$9$lambda$7($collision, arg_0), arg_0));
    }

    private static final boolean checkCollision$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit render$lambda$14$lambda$12(GMap this$0, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SafeGraphics graphics = SafeGraphicsKt._ do not use(this$0, it.getX(), it.getY(), it.getWidth(), it.getHeight(), ConsolePrinter.getIndex());
        it.render(graphics);
        return Unit.INSTANCE;
    }

    private static final void render$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void start$lambda$17() {
        EventListener.pushButtonEvent();
        EventListener.pushMouseLocationEvent();
    }

    private static final void start$lambda$18(GMap this$0, BooleanSupplier $logicCondition, GTimer $logicTimer, long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$logicCondition, (String)"$logicCondition");
        Intrinsics.checkNotNullParameter((Object)$logicTimer, (String)"$logicTimer");
        this$0.update(it);
        this$0.entities.sync();
        if (this$0.stopped || !$logicCondition.getAsBoolean()) {
            $logicTimer.cancel();
        } else {
            this$0.taskManager.runTaskList(4);
            this$0.reusableTaskManager.runTaskListNoRemove(4);
        }
    }

    private static final void start$lambda$19(GMap this$0, long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.render();
        this$0.fps = it == 0L ? Integer.MAX_VALUE : (int)((long)1000 / it);
    }

    private static final Unit update$lambda$21(GMap this$0, long $time, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.update(this$0, $time);
        return Unit.INSTANCE;
    }

    private static final void update$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public /* synthetic */ GMap(int width, int height, DefaultConstructorMarker $constructor_marker) {
        this(width, height);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010/\u001a\u00020'H\u0007J\b\u00100\u001a\u00020\u0013H\u0007R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR0\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R,\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR,\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR2\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010#\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010*R,\u0010+\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b,\u0010\u0002\u001a\u0004\b-\u0010\b\"\u0004\b.\u0010\n\u00a8\u00061"}, d2={"Ltop/kmar/game/map/GMap$Builder;", "", "()V", "value", "", "cache", "getCache$annotations", "getCache", "()I", "setCache", "(I)V", "Ljava/io/File;", "file", "getFile$annotations", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "flag", "", "getFlag$annotations", "fontWidth", "getFontWidth$annotations", "getFontWidth", "setFontWidth", "height", "getHeight$annotations", "getHeight", "setHeight", "ignoreClose", "getIgnoreClose$annotations", "getIgnoreClose", "()Ljava/lang/Boolean;", "setIgnoreClose", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "list", "Ljava/util/LinkedList;", "Ljava/lang/ref/WeakReference;", "Ltop/kmar/game/map/GMap;", "getList$cg_engine$annotations", "getList$cg_engine", "()Ljava/util/LinkedList;", "width", "getWidth$annotations", "getWidth", "setWidth", "build", "dispose", "cg-engine"})
    @SourceDebugExtension(value={"SMAP\nGMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMap.kt\ntop/kmar/game/map/GMap$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,374:1\n1#2:375\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Builder INSTANCE = new Builder();
        private static int width = -1;
        private static int height = -1;
        private static int fontWidth = -1;
        private static int cache = -1;
        @Nullable
        private static Boolean ignoreClose;
        @Nullable
        private static File file;
        private static boolean flag;
        @NotNull
        private static final LinkedList<WeakReference<GMap>> list;

        private Builder() {
        }

        public static final int getWidth() {
            return width;
        }

        public static final void setWidth(int value) {
            if (!(width == -1)) {
                boolean $i$a$-require-GMap$Builder$width$32 = false;
                String $i$a$-require-GMap$Builder$width$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$width$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u5bbd\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            width = value;
        }

        @JvmStatic
        public static /* synthetic */ void getWidth$annotations() {
        }

        public static final int getHeight() {
            return height;
        }

        public static final void setHeight(int value) {
            if (!(height == -1)) {
                boolean $i$a$-require-GMap$Builder$height$32 = false;
                String $i$a$-require-GMap$Builder$height$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$height$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u9ad8\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            height = value;
        }

        @JvmStatic
        public static /* synthetic */ void getHeight$annotations() {
        }

        public static final int getFontWidth() {
            return fontWidth;
        }

        public static final void setFontWidth(int value) {
            if (!(fontWidth == -1)) {
                boolean $i$a$-require-GMap$Builder$fontWidth$32 = false;
                String $i$a$-require-GMap$Builder$fontWidth$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$fontWidth$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u5bbd\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            fontWidth = value;
        }

        @JvmStatic
        public static /* synthetic */ void getFontWidth$annotations() {
        }

        public static final int getCache() {
            return cache;
        }

        public static final void setCache(int value) {
            if (!(cache == -1)) {
                boolean $i$a$-require-GMap$Builder$cache$32 = false;
                String $i$a$-require-GMap$Builder$cache$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$cache$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u7f13\u5b58\u6570\u91cf\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            cache = value;
        }

        @JvmStatic
        public static /* synthetic */ void getCache$annotations() {
        }

        @Nullable
        public static final Boolean getIgnoreClose() {
            return ignoreClose;
        }

        public static final void setIgnoreClose(@Nullable Boolean value) {
            if (!(ignoreClose == null)) {
                boolean $i$a$-require-GMap$Builder$ignoreClose$32 = false;
                String $i$a$-require-GMap$Builder$ignoreClose$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$ignoreClose$32.toString());
            }
            if (!(value != null)) {
                boolean bl = false;
                String string = "\u503c\u4e0d\u5e94\u5f53\u4e3a NULL";
                throw new IllegalArgumentException(string.toString());
            }
            ignoreClose = value;
        }

        @JvmStatic
        public static /* synthetic */ void getIgnoreClose$annotations() {
        }

        @Nullable
        public static final File getFile() {
            return file;
        }

        public static final void setFile(@Nullable File value) {
            if (!(file == null)) {
                boolean $i$a$-require-GMap$Builder$file$32 = false;
                String $i$a$-require-GMap$Builder$file$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$file$32.toString());
            }
            if (!(value != null)) {
                boolean bl = false;
                String string = "\u503c\u4e0d\u5e94\u5f53\u4e3a NULL";
                throw new IllegalArgumentException(string.toString());
            }
            file = value;
        }

        @JvmStatic
        public static /* synthetic */ void getFile$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getFlag$annotations() {
        }

        @NotNull
        public static final LinkedList<WeakReference<GMap>> getList$cg_engine() {
            return list;
        }

        @JvmStatic
        public static /* synthetic */ void getList$cg_engine$annotations() {
        }

        @JvmStatic
        @NotNull
        public static final GMap build() {
            if (!(width != -1)) {
                boolean $i$a$-require-GMap$Builder$build$32 = false;
                String $i$a$-require-GMap$Builder$build$32 = "\u5bbd\u5ea6\u5c5e\u6027\u672a\u521d\u59cb\u5316";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$build$32.toString());
            }
            if (!(height != -1)) {
                boolean bl = false;
                String string = "\u9ad8\u5ea6\u5c5e\u6027\u672a\u521d\u59cb\u5316";
                throw new IllegalArgumentException(string.toString());
            }
            if (fontWidth == -1) {
                Builder.setFontWidth(10);
            }
            if (cache == -10) {
                Builder.setCache(2);
            }
            if (ignoreClose == null) {
                Builder.setIgnoreClose(false);
            }
            if (file == null) {
                Builder.setFile(new File("utils.dll"));
            }
            if (flag) {
                flag = false;
                Boolean bl = ignoreClose;
                Intrinsics.checkNotNull((Object)bl);
                boolean bl2 = bl;
                File file = Builder.file;
                Intrinsics.checkNotNull((Object)file);
                ConsolePrinter.init(width, height, fontWidth, cache, bl2, file);
            }
            list.removeIf(arg_0 -> Builder.build$lambda$15(Builder::build$lambda$14, arg_0));
            GMap map = new GMap(width, height, null);
            list.add(new WeakReference<GMap>(map));
            return map;
        }

        @JvmStatic
        public static final boolean dispose() {
            boolean bl;
            list.removeIf(arg_0 -> Builder.dispose$lambda$17(Builder::dispose$lambda$16, arg_0));
            if (list.isEmpty()) {
                ConsolePrinter.dispose();
                flag = true;
                bl = true;
            } else {
                System.gc();
                list.removeIf(arg_0 -> Builder.dispose$lambda$19(Builder::dispose$lambda$18, arg_0));
                if (list.isEmpty()) {
                    ConsolePrinter.dispose();
                    flag = true;
                    bl = true;
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean build$lambda$14(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean build$lambda$15(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean dispose$lambda$16(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean dispose$lambda$17(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean dispose$lambda$18(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean dispose$lambda$19(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            flag = true;
            list = new LinkedList();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Ltop/kmar/game/map/GMap$BuilderJava;", "", "()V", "build", "Ltop/kmar/game/map/GMap;", "dispose", "", "setCache", "value", "", "setFile", "file", "Ljava/io/File;", "setFontWidth", "setHeight", "setIgnoreClose", "setWidth", "cg-engine"})
    public static final class BuilderJava {
        @NotNull
        public static final BuilderJava INSTANCE = new BuilderJava();

        private BuilderJava() {
        }

        @NotNull
        public final BuilderJava setWidth(int value) {
            Builder.setWidth(value);
            return this;
        }

        @NotNull
        public final BuilderJava setHeight(int value) {
            Builder.setHeight(value);
            return this;
        }

        @NotNull
        public final BuilderJava setCache(int value) {
            Builder.setCache(value);
            return this;
        }

        @NotNull
        public final BuilderJava setFontWidth(int value) {
            Builder.setFontWidth(value);
            return this;
        }

        @NotNull
        public final BuilderJava setIgnoreClose(boolean value) {
            Builder.setIgnoreClose(value);
            return this;
        }

        @NotNull
        public final BuilderJava setFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder.setFile(file);
            return this;
        }

        @NotNull
        public final GMap build() {
            return Builder.build();
        }

        @JvmStatic
        public static final boolean dispose() {
            return Builder.dispose();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltop/kmar/game/map/GMap$Companion;", "", "()V", "AFTER_LOGIC", "", "AFTER_RENDER", "AFTER_UPDATE", "BEFORE_RENDER", "BEFORE_UPDATE", "cg-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

