/*
 * Decompiled with CFR 0.152.
 */
package top.kmar.game.map;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.kmar.game.map.GEntity;
import top.kmar.game.map.GMap;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0019R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\f\u00a8\u0006\u001f"}, d2={"Ltop/kmar/game/map/MapLayout;", "", "source", "Ltop/kmar/game/map/GMap;", "(Ltop/kmar/game/map/GMap;)V", "addList", "Ljava/util/LinkedList;", "Ltop/kmar/game/map/MapLayout$AddedItem;", "allEntities", "Ljava/util/stream/Stream;", "Ltop/kmar/game/map/GEntity;", "getAllEntities", "()Ljava/util/stream/Stream;", "collisibleEntities", "getCollisibleEntities", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "", "visibleEntities", "getVisibleEntities", "add", "", "entity", "layer", "", "sync", "AddedItem", "cg-engine"})
@SourceDebugExtension(value={"SMAP\nMapLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapLayout.kt\ntop/kmar/game/map/MapLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,57:1\n1855#2,2:58\n1855#2:60\n1856#2:68\n361#3,7:61\n*S KotlinDebug\n*F\n+ 1 MapLayout.kt\ntop/kmar/game/map/MapLayout\n*L\n28#1:58,2\n38#1:60\n38#1:68\n39#1:61,7\n*E\n"})
public final class MapLayout {
    @NotNull
    private final GMap source;
    @NotNull
    private final Int2ObjectRBTreeMap<Collection<GEntity>> map;
    @NotNull
    private final LinkedList<AddedItem> addList;
    @NotNull
    private final ReentrantLock lock;

    public MapLayout(@NotNull GMap source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.map = new Int2ObjectRBTreeMap();
        this.addList = new LinkedList();
        this.lock = new ReentrantLock();
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @NotNull
    public final Stream<GEntity> getAllEntities() {
        Stream<Object> stream = ((ObjectCollection)this.map.values()).stream().flatMap(arg_0 -> MapLayout._get_allEntities_$lambda$1(MapLayout::_get_allEntities_$lambda$0, arg_0)).filter(arg_0 -> MapLayout._get_allEntities_$lambda$3(MapLayout::_get_allEntities_$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map.values.stream().flat\u2026m() }.filter { !it.died }");
        return stream;
    }

    @NotNull
    public final Stream<GEntity> getVisibleEntities() {
        Stream<Object> stream = this.getAllEntities().filter(arg_0 -> MapLayout._get_visibleEntities_$lambda$5(MapLayout::_get_visibleEntities_$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"allEntities.filter { it.visible }");
        return stream;
    }

    @NotNull
    public final Stream<GEntity> getCollisibleEntities() {
        Stream<Object> stream = this.getAllEntities().filter(arg_0 -> MapLayout._get_collisibleEntities_$lambda$7(MapLayout::_get_collisibleEntities_$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"allEntities.filter { it.collisible }");
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void sync() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object itor;
            boolean bl = false;
            Collection collection = this.map.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"map.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection list = (Collection)element$iv;
                boolean bl2 = false;
                itor = list.iterator();
                while (itor.hasNext()) {
                    GEntity it = (GEntity)itor.next();
                    if (!it.getDied()) continue;
                    itor.remove();
                    this.source.appendTask(0, () -> MapLayout.sync$lambda$13$lambda$9$lambda$8(it, this));
                }
            }
            $this$forEach$iv = this.addList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                void $this$getOrPut$iv;
                AddedItem it = (AddedItem)element$iv;
                boolean bl3 = false;
                itor = (Map)this.map;
                Integer key$iv = it.getLayer();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    Collection answer$iv = new LinkedList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Collection list = (Collection)object;
                list.add(it.getValue());
                this.source.appendTask(0, () -> MapLayout.sync$lambda$13$lambda$12$lambda$11(it, this));
            }
            this.addList.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void add(@NotNull GEntity entity, int layer) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.addList.add(new AddedItem(entity, layer));
    }

    private static final Stream _get_allEntities_$lambda$0(Collection it) {
        return it.stream();
    }

    private static final Stream _get_allEntities_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean _get_allEntities_$lambda$2(GEntity it) {
        return !it.getDied();
    }

    private static final boolean _get_allEntities_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _get_visibleEntities_$lambda$4(GEntity it) {
        return it.getVisible();
    }

    private static final boolean _get_visibleEntities_$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _get_collisibleEntities_$lambda$6(GEntity it) {
        return it.getCollisible();
    }

    private static final boolean _get_collisibleEntities_$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void sync$lambda$13$lambda$9$lambda$8(GEntity $it, MapLayout this$0) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $it.onRemove(this$0.source);
    }

    private static final void sync$lambda$13$lambda$12$lambda$11(AddedItem $it, MapLayout this$0) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $it.getValue().onGenerate(this$0.source);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ltop/kmar/game/map/MapLayout$AddedItem;", "", "value", "Ltop/kmar/game/map/GEntity;", "layer", "", "(Ltop/kmar/game/map/GEntity;I)V", "getLayer", "()I", "getValue", "()Ltop/kmar/game/map/GEntity;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "cg-engine"})
    private static final class AddedItem {
        @NotNull
        private final GEntity value;
        private final int layer;

        public AddedItem(@NotNull GEntity value, int layer) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.layer = layer;
        }

        @NotNull
        public final GEntity getValue() {
            return this.value;
        }

        public final int getLayer() {
            return this.layer;
        }

        @NotNull
        public final GEntity component1() {
            return this.value;
        }

        public final int component2() {
            return this.layer;
        }

        @NotNull
        public final AddedItem copy(@NotNull GEntity value, int layer) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new AddedItem(value, layer);
        }

        public static /* synthetic */ AddedItem copy$default(AddedItem addedItem, GEntity gEntity, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                gEntity = addedItem.value;
            }
            if ((n2 & 2) != 0) {
                n = addedItem.layer;
            }
            return addedItem.copy(gEntity, n);
        }

        @NotNull
        public String toString() {
            return "AddedItem(value=" + this.value + ", layer=" + this.layer + ')';
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + Integer.hashCode(this.layer);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddedItem)) {
                return false;
            }
            AddedItem addedItem = (AddedItem)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)addedItem.value)) {
                return false;
            }
            return this.layer == addedItem.layer;
        }
    }
}

