/*
 * Decompiled with CFR 0.152.
 */
package top.kmar.game.utils;

import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltop/kmar/game/utils/GTimer;", "", "()V", "alive", "", "getAlive", "()Z", "thread", "Ljava/lang/Thread;", "cancel", "", "join", "start", "name", "", "interval", "", "isDaemon", "task", "Ljava/util/function/LongConsumer;", "startNoWait", "Ljava/lang/Runnable;", "startNonFixed", "cg-engine"})
public final class GTimer {
    private Thread thread;

    public final boolean getAlive() {
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        return thread.isAlive();
    }

    public final void start(@NotNull String name, long interval, boolean isDaemon, @NotNull LongConsumer task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (interval == 0L) {
            Ref.LongRef prev = new Ref.LongRef();
            prev.element = System.currentTimeMillis();
            this.startNoWait(name, isDaemon, () -> GTimer.start$lambda$0(task, prev));
            return;
        }
        this.thread = new Thread(() -> GTimer.start$lambda$1(interval, this, task));
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.setName(name);
        Thread thread2 = this.thread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread2 = null;
        }
        thread2.setDaemon(isDaemon);
        Thread thread3 = this.thread;
        if (thread3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread3 = null;
        }
        thread3.start();
    }

    public final void startNonFixed(@NotNull String name, long interval, boolean isDaemon, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (interval == 0L) {
            this.startNoWait(name, isDaemon, task);
            return;
        }
        this.thread = new Thread(() -> GTimer.startNonFixed$lambda$2(this, interval, task));
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.setName(name);
        Thread thread2 = this.thread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread2 = null;
        }
        thread2.setDaemon(isDaemon);
        Thread thread3 = this.thread;
        if (thread3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread3 = null;
        }
        thread3.start();
    }

    public final void startNoWait(@NotNull String name, boolean isDaemon, @NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.thread = new Thread(() -> GTimer.startNoWait$lambda$3(this, task));
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.setName(name);
        Thread thread2 = this.thread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread2 = null;
        }
        thread2.setDaemon(isDaemon);
        Thread thread3 = this.thread;
        if (thread3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread3 = null;
        }
        thread3.start();
    }

    public final void cancel() {
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.interrupt();
    }

    public final void join() {
        Thread thread = this.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.join();
    }

    private static final void start$lambda$0(LongConsumer $task, Ref.LongRef $prev) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$prev, (String)"$prev");
        long now = System.currentTimeMillis();
        $task.accept(now - $prev.element);
        $prev.element = now;
    }

    private static final void start$lambda$1(long $interval, GTimer this$0, LongConsumer $task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        long sleepBound = $interval - (long)2;
        long prev = System.currentTimeMillis();
        long offset = 0L;
        while (true) {
            Thread thread;
            if ((thread = this$0.thread) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
                thread = null;
            }
            if (thread.isInterrupted()) break;
            long now = System.currentTimeMillis();
            long time = now - prev;
            if (time + offset < sleepBound) {
                try {
                    Thread.sleep(sleepBound - time);
                }
                catch (InterruptedException e) {
                    break;
                }
                now = System.currentTimeMillis();
                time = now - prev;
            }
            while (time + offset < $interval) {
                now = System.currentTimeMillis();
                time = now - prev;
            }
            offset += time - $interval;
            prev = now;
            $task.accept(time);
        }
    }

    private static final void startNonFixed$lambda$2(GTimer this$0, long $interval, Runnable $task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        while (true) {
            Thread thread;
            if ((thread = this$0.thread) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
                thread = null;
            }
            if (thread.isInterrupted()) break;
            try {
                Thread.sleep($interval);
            }
            catch (InterruptedException e) {
                break;
            }
            $task.run();
        }
    }

    private static final void startNoWait$lambda$3(GTimer this$0, Runnable $task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        while (true) {
            Thread thread;
            if ((thread = this$0.thread) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
                thread = null;
            }
            if (thread.isInterrupted()) break;
            $task.run();
        }
    }
}

