/*
 * Decompiled with CFR 0.152.
 */
package top.kmar.game.utils;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.kmar.game.map.GEntity;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0000J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006)"}, d2={"Ltop/kmar/game/utils/Rect2D;", "", "x", "", "y", "width", "height", "(IIII)V", "bottom", "getBottom", "()I", "getHeight", "isEmpty", "", "()Z", "right", "getRight", "getWidth", "getX", "getY", "compareTo", "other", "component1", "component2", "component3", "component4", "containsX", "containsY", "copy", "equals", "", "hasIntersection", "that", "hashCode", "intersect", "mapToEntity", "entity", "Ltop/kmar/game/map/GEntity;", "toString", "", "Companion", "cg-engine"})
public final class Rect2D
implements Comparable<Rect2D> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    @NotNull
    private static final Rect2D empty = new Rect2D(0, 0, 0, 0);

    public Rect2D(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    public final boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public final boolean containsY(int y) {
        return y >= this.y && y < this.y + this.height;
    }

    public final boolean containsX(int x) {
        return x >= this.x && x < this.x + this.width;
    }

    @NotNull
    public final Rect2D intersect(@NotNull Rect2D that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        int left = Math.max(this.x, that.x);
        int top = Math.max(this.y, that.y);
        int right = Math.min(this.getRight(), that.getRight());
        int bottom = Math.min(this.getBottom(), that.getBottom());
        return new Rect2D(left, top, right - left, bottom - top);
    }

    public final boolean hasIntersection(@NotNull Rect2D that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.x < that.getRight() && this.y < that.getBottom() && this.getRight() > that.x && this.getBottom() > that.y;
    }

    @NotNull
    public final Rect2D mapToEntity(@NotNull GEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return new Rect2D(this.x - entity.getX(), this.y - entity.getY(), this.width, this.height);
    }

    @Override
    public int compareTo(@NotNull Rect2D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.x != other.x) {
            return this.x - other.x;
        }
        if (this.y != other.y) {
            return this.y - other.y;
        }
        if (this.width != other.width) {
            return this.width - other.width;
        }
        return this.height - other.height;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final Rect2D copy(int x, int y, int width, int height) {
        return new Rect2D(x, y, width, height);
    }

    public static /* synthetic */ Rect2D copy$default(Rect2D rect2D, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = rect2D.x;
        }
        if ((n5 & 2) != 0) {
            n2 = rect2D.y;
        }
        if ((n5 & 4) != 0) {
            n3 = rect2D.width;
        }
        if ((n5 & 8) != 0) {
            n4 = rect2D.height;
        }
        return rect2D.copy(n, n2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "Rect2D(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Integer.hashCode(this.width);
        result = result * 31 + Integer.hashCode(this.height);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rect2D)) {
            return false;
        }
        Rect2D rect2D = (Rect2D)other;
        if (this.x != rect2D.x) {
            return false;
        }
        if (this.y != rect2D.y) {
            return false;
        }
        if (this.width != rect2D.width) {
            return false;
        }
        return this.height == rect2D.height;
    }

    @JvmName(name="empty")
    @NotNull
    public static final Rect2D empty() {
        return Companion.empty();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ltop/kmar/game/utils/Rect2D$Companion;", "", "()V", "empty", "Ltop/kmar/game/utils/Rect2D;", "empty$annotations", "()Ltop/kmar/game/utils/Rect2D;", "cg-engine"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="empty")
        @NotNull
        public final Rect2D empty() {
            return empty;
        }

        @JvmStatic
        public static /* synthetic */ void empty$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

