/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import top.lieder.Config;

public class OSSClient {
    static String endpoint;
    static String urlHead;
    String accessKeyId;
    String accessKeySecret;
    static String bucketName;
    OSS ossClient;

    public OSSClient() {
        endpoint = Config.getConfig("OSS.endpoint");
        urlHead = Config.getConfig("OSS.urlHead");
        this.accessKeyId = Config.getConfig("OSS.accessKeyId");
        this.accessKeySecret = Config.getConfig("OSS.accessKeySecret");
        bucketName = Config.getConfig("OSS.bucketName");
        this.ossClient = new OSSClientBuilder().build(endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public boolean contain(String url) {
        return this.ossClient.doesObjectExist(bucketName, this.getFileName(url));
    }

    public void delete(String url) {
        this.ossClient.deleteObject(bucketName, this.getFileName(url));
    }

    String getFileName(String url) {
        if (url.contains(urlHead)) {
            return url.split(urlHead + "/")[1];
        }
        return url.contains(endpoint) ? url.split(endpoint + "/")[1] : url;
    }

    public static String getFullUrl(String purePath) {
        String base64 = URLEncoder.encode(purePath, StandardCharsets.UTF_8).replaceAll("%2F", "/");
        return "http://" + (bucketName + "." + endpoint + "/" + base64).replace("//", "/");
    }

    public String upload(String purePath, String content) {
        return this.upload(purePath, content, null);
    }

    public String upload(String purePath, String content, Callback callback) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, purePath, (InputStream)new ByteArrayInputStream(content.getBytes()));
        if (callback != null) {
            putObjectRequest.setCallback(callback);
        }
        this.ossClient.putObject(putObjectRequest);
        return OSSClient.getFullUrl(purePath);
    }

    public String upload(String purePath, InputStream inputStream) {
        return this.upload(purePath, inputStream, null);
    }

    public String upload(String purePath, InputStream inputStream, Callback callback) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, purePath, inputStream);
        if (callback != null) {
            putObjectRequest.setCallback(callback);
        }
        this.ossClient.putObject(putObjectRequest);
        return OSSClient.getFullUrl(purePath);
    }

    public String upload(String purePath, File file) {
        return this.upload(purePath, file, null);
    }

    public String upload(String purePath, File file, Callback callback) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, purePath, file);
        if (callback != null) {
            putObjectRequest.setCallback(callback);
        }
        this.ossClient.putObject(putObjectRequest);
        return OSSClient.getFullUrl(purePath);
    }

    public InputStream downloadStream(String url) {
        String key = this.getFileName(url);
        OSSObject ossObject = this.ossClient.getObject(bucketName, key);
        return ossObject.getObjectContent();
    }

    public void downloadFile(String url, String localPath) {
        this.ossClient.getObject(new GetObjectRequest(bucketName, this.getFileName(url)), new File(localPath));
    }
}

