/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import top.lieder.ClientPool;
import top.lieder.CommonFunction;
import top.lieder.Environment;
import top.lieder.OSSClient;
import top.lieder.ResResult;

public class FileManager {
    private static final Logger log = LogManager.getLogger(FileManager.class);
    static boolean k8sMode = Environment.getK8sMode();

    public static String getPathInEnvironment(String path) {
        return k8sMode ? path.replace("./", "") : path;
    }

    public static void uploadFile(ResResult resResult, MultipartFile file, String ossSubPath, String name) {
        try {
            String url = FileManager.uploadFile(file, ossSubPath, name);
            Map<String, String> result = Collections.singletonMap("url", url);
            resResult.setSuccess(result);
        }
        catch (Exception e) {
            resResult.setFail(ResResult.ResultCode.OPERATE_FAIL);
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    public static String uploadFile(MultipartFile file, String ossSubPath, String name) throws Exception {
        String ossPartPath = (String)(ossSubPath.endsWith("/") ? ossSubPath : ossSubPath + "/") + (name != null && name.length() > 0 ? name : file.getOriginalFilename());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(file.getBytes());
        String url = ClientPool.ossClient.upload(ossPartPath, byteArrayInputStream);
        return url;
    }

    public static String uploadFile(InputStream inputStream, String ossSubPath, String name) {
        long timestamp = CommonFunction.getTimestamp();
        String ossPartPath = (String)(ossSubPath.endsWith("/") ? ossSubPath : ossSubPath + "/") + (Serializable)(name != null && name.length() > 0 ? name : Long.valueOf(timestamp));
        return ClientPool.ossClient.upload(ossPartPath, inputStream);
    }

    public static void updateFile(ResResult resResult, String oldUrl, MultipartFile newFile, String newOssPath, String newName) {
        try {
            String url = FileManager.updateFile(oldUrl, newFile, newOssPath, newName);
            Map<String, String> result = Collections.singletonMap("newUrl", url);
            resResult.setSuccess(result);
        }
        catch (Exception e) {
            resResult.setFail(ResResult.ResultCode.OPERATE_FAIL);
            e.printStackTrace();
            log.error((Object)e);
        }
    }

    public static String updateFile(String oldUrl, MultipartFile newFile, String newOssPath, String newName) throws Exception {
        String result = FileManager.uploadFile(newFile, newOssPath, newName);
        if (!ClientPool.ossClient.contain(newOssPath)) {
            throw new Exception("File '" + newOssPath + "' uploaded fail.");
        }
        if (oldUrl.contains(OSSClient.endpoint)) {
            if (result.contains(OSSClient.endpoint) && !Objects.equals(result, oldUrl) && ClientPool.ossClient.contain(oldUrl)) {
                ClientPool.ossClient.delete(oldUrl);
            }
        }
        return result;
    }

    public static InputStream getOSSFile(String url) {
        return ClientPool.ossClient.downloadStream(url);
    }

    public static String getOSSFileString(String url) throws Exception {
        String data;
        InputStreamReader read = new InputStreamReader(FileManager.getOSSFile(url));
        BufferedReader br = new BufferedReader(read);
        StringBuilder result = new StringBuilder();
        while ((data = br.readLine()) != null) {
            result.append(data);
        }
        return result.toString();
    }

    public static String getUrlFileString(String urlString) throws Exception {
        String data;
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = conn.getInputStream();
        InputStreamReader read = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(read);
        StringBuilder result = new StringBuilder();
        while ((data = br.readLine()) != null) {
            result.append(data);
        }
        return result.toString();
    }
}

