/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import top.lieder.FileManager;

public class RestAPI {
    private static final Logger log = LogManager.getLogger(RestAPI.class);
    static Gson gson = new Gson();
    static ObjectMapper json = new ObjectMapper();

    public static Map<String, Object> get(String urlStr, Map<String, Object> params) {
        return RestAPI.get(urlStr, params, false);
    }

    public static Map<String, Object> get(String urlStr, Map<String, Object> params, boolean withParseJson) {
        return RestAPI.get(urlStr, params, withParseJson, null);
    }

    public static String getGETUrlFromBody(String url, Map<String, ?> body) {
        StringBuilder s = new StringBuilder(url + "?");
        TreeMap newMap = new TreeMap(body);
        for (Map.Entry data : newMap.entrySet()) {
            if (data.getValue() == null) continue;
            s.append((String)data.getKey()).append("=").append(URLEncoder.encode(data.getValue().toString(), StandardCharsets.UTF_8)).append("&");
        }
        return s.substring(0, s.length() - 1);
    }

    public static Map<String, Object> get(String urlStr, Map<String, Object> params, boolean withParseJson, HttpHeaders headers) {
        if (params != null && !params.isEmpty()) {
            urlStr = RestAPI.getGETUrlFromBody(urlStr, params);
        }
        RestTemplate restTemplate = new RestTemplate();
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        org.springframework.http.HttpEntity request = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        try {
            restTemplate.getMessageConverters().add(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            ResponseEntity response = restTemplate.exchange(urlStr, HttpMethod.GET, request, String.class, new Object[]{1});
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", response.getStatusCode());
            if (withParseJson) {
                Object data;
                try {
                    data = json.readValue((String)response.getBody(), (TypeReference)new TypeReference<Object>(){});
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    data = gson.fromJson((String)response.getBody(), new TypeToken<Object>(){}.getType());
                }
                result.put("data", data);
            } else {
                result.put("data", response.getBody());
            }
            return result;
        }
        catch (HttpClientErrorException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object data = gson.fromJson(e.getResponseBodyAsString(), new TypeToken<Object>(){}.getType());
            result.put("code", e.getStatusCode());
            result.put("data", data);
            return result;
        }
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body) {
        return RestAPI.post(urlStr, request_body, -1);
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body, int timeout) {
        return RestAPI.post(urlStr, request_body, false, false, timeout);
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body, boolean allowNullMap, boolean withParseJson, int timeout) {
        return RestAPI.post(urlStr, request_body, allowNullMap, withParseJson, timeout, null);
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body, boolean withParseJson, HttpHeaders headers) {
        return RestAPI.post(urlStr, request_body, false, withParseJson, -1, headers);
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body, boolean withParseJson, int timeout, HttpHeaders headers) {
        return RestAPI.post(urlStr, request_body, false, withParseJson, timeout, headers);
    }

    public static Map<String, Object> post(String urlStr, Map<String, Object> request_body, boolean allowNullMap, boolean withParseJson, int timeout, HttpHeaders headers) {
        if ((request_body == null || request_body.isEmpty()) && !allowNullMap) {
            request_body = new HashMap<String, Object>();
            request_body.put("", "");
        }
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        if (timeout > -1) {
            requestFactory.setConnectTimeout(timeout);
            requestFactory.setReadTimeout(timeout);
        }
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.parseMediaType((String)"application/json; charset=UTF-8"));
        org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity(request_body, (MultiValueMap)headers);
        try {
            restTemplate.getMessageConverters().add(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            ResponseEntity response = restTemplate.postForEntity(urlStr, (Object)formEntity, String.class, new Object[0]);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", response.getStatusCode());
            if (withParseJson) {
                Object data;
                try {
                    data = json.readValue((String)response.getBody(), (TypeReference)new TypeReference<Object>(){});
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    data = gson.fromJson((String)response.getBody(), new TypeToken<Object>(){}.getType());
                }
                result.put("data", data);
            } else {
                result.put("data", response.getBody());
            }
            return result;
        }
        catch (HttpClientErrorException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object data = gson.fromJson(e.getResponseBodyAsString(), new TypeToken<Object>(){}.getType());
            result.put("code", e.getStatusCode());
            result.put("data", data);
            return result;
        }
    }

    public static String postStream(String url, String json, String fileName) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/json; charset=UTF-8");
        httpPost.setHeader("Accept", "application/json");
        StringEntity s = new StringEntity(json, StandardCharsets.UTF_8);
        s.setContentType("UTF-8");
        httpPost.setEntity((HttpEntity)s);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            return FileManager.uploadFile(inputStream, "postStream", fileName);
        }
        throw new Exception(response.getEntity().getContent().toString());
    }

    public static Map<String, Object> postForm(String urlStr, Map<String, Object> request_body, boolean ifNeedParseJson, HttpHeaders headers) {
        if (request_body == null || request_body.isEmpty()) {
            request_body = new HashMap<String, Object>();
            request_body.put("", "");
        }
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        for (Map.Entry<String, Object> data : request_body.entrySet()) {
            body.add((Object)data.getKey(), data.getValue());
        }
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(new MediaType(MediaType.MULTIPART_FORM_DATA, StandardCharsets.UTF_8));
        org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((Object)body, (MultiValueMap)headers);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        try {
            ResponseEntity response = restTemplate.postForEntity(urlStr, (Object)formEntity, String.class, new Object[0]);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", response.getStatusCode());
            if (ifNeedParseJson) {
                Object data = gson.fromJson((String)response.getBody(), new TypeToken<Object>(){}.getType());
                result.put("data", data);
            } else {
                result.put("data", response.getBody());
            }
            return result;
        }
        catch (HttpClientErrorException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object data = gson.fromJson(e.getResponseBodyAsString(), new TypeToken<Object>(){}.getType());
            result.put("code", e.getStatusCode());
            result.put("data", data);
            return result;
        }
    }
}

