/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.order.ConsumeOrderContext;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderAction;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.Config;

public class RocketMqGetter {
    private static final Logger log = LogManager.getLogger(RocketMqGetter.class);
    Properties properties = new Properties();
    Consumer consumer;

    public RocketMqGetter() {
        Config.fillConfig("rocketMq.properties", this.properties);
        this.consumer = ONSFactory.createConsumer((Properties)this.properties);
    }

    public RocketMqGetter(String groupId) {
        Config.fillConfig("rocketMq.properties", this.properties);
        if (groupId != null) {
            this.properties.setProperty("GROUP_ID", groupId);
        }
        this.consumer = ONSFactory.createConsumer((Properties)this.properties);
    }

    public void BookMessage(String topic, MessageListener messageListener) {
        this.consumer.subscribe(topic, "*", messageListener);
        this.consumer.start();
        log.info("Consumer Started");
    }

    public void BookMessageOrder(String topic, String tags) {
        MessageOrderListener messageListener = new MessageOrderListener(){

            public OrderAction consume(Message message, ConsumeOrderContext context) {
                log.info((Object)message);
                return OrderAction.Success;
            }
        };
        this.BookMessageOrder(topic, tags, messageListener);
    }

    public void BookMessageOrder(String topic, String tags, MessageOrderListener messageListener) {
        OrderConsumer consumer = ONSFactory.createOrderedConsumer((Properties)this.properties);
        consumer.subscribe(topic, tags, messageListener);
        consumer.start();
    }
}

