/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import top.lieder.Config;
import top.lieder.Environment;
import top.lieder.JSON;
import top.lieder.MongoDB;

public class PhoneMessage {
    private static final Logger log = LogManager.getLogger(PhoneMessage.class);
    static String RegionId = Config.getConfig("message.RegionId");
    static String SignName = "\u5f00\u5fc3\u9ebb\u82b1";
    static String TemplateCode = Config.getConfig("message.TemplateCode");
    static String accessKeyId = Config.getConfig("message.accessKeyId");
    static String accessSecret = Config.getConfig("message.accessSecret");
    static String endpoint = "dysmsapi.aliyuncs.com";
    static JSON json = new JSON();
    static boolean testMode = Environment.getTestMode();
    static MongoDB recordMongoBD = new MongoDB("operateRecord", testMode ? "message_error_test" : "message_error_formal");

    public PhoneMessage() {
        RegionId = Config.getConfig("message.RegionId");
        SignName = Config.getConfig("message.SignName");
        TemplateCode = Config.getConfig("message.TemplateCode");
        accessKeyId = Config.getConfig("message.accessKeyId");
        accessSecret = Config.getConfig("message.accessSecret");
    }

    public static void sendMessage(String PhoneNumbers, Map<String, Object> messageMap) throws Exception {
        PhoneMessage.sendMessage(PhoneNumbers, messageMap, TemplateCode);
    }

    public static CommonResponse sendMessage(String phoneNumbers, Map<String, Object> messageMap, String templateCode) throws Exception {
        DefaultProfile profile = DefaultProfile.getProfile((String)RegionId, (String)accessKeyId, (String)accessSecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", RegionId);
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        request.putQueryParameter("SignName", SignName);
        request.putQueryParameter("TemplateCode", templateCode);
        if (messageMap != null) {
            request.putQueryParameter("TemplateParam", json.toJson(messageMap));
        }
        CommonResponse response = client.getCommonResponse(request);
        log.info(response.getData());
        return response;
    }

    public static CommonResponse sendMessageCheckResponse(String PhoneNumbers, Map<String, Object> messageMap, String templateCode) throws Exception {
        CommonResponse response = PhoneMessage.sendMessage(PhoneNumbers, messageMap, templateCode);
        String data = response.getData();
        Map map = (Map)json.fromJson(data);
        if (Objects.equals(map.get("Code"), "OK")) {
            return response;
        }
        throw new Exception(data);
    }

    public static CommonResponse sendMessageWithErrorRecord(String PhoneNumbers, Map<String, Object> messageMap, String templateCode, String service, String path, String comment) throws Exception {
        CommonResponse response = PhoneMessage.sendMessage(PhoneNumbers, messageMap, templateCode);
        String data = response.getData();
        Map map = (Map)json.fromJson(data);
        if (Objects.equals(map.get("Code"), "OK")) {
            return response;
        }
        Document record = new Document();
        record.put("phone", (Object)PhoneNumbers);
        record.put("messageMap", (Object)(messageMap == null ? "" : json.toJson(messageMap)));
        record.put("templateCode", (Object)templateCode);
        record.put("response", (Object)response);
        record.put("service", (Object)service);
        record.put("path", (Object)path);
        record.put("comment", (Object)comment);
        recordMongoBD.setValue(record);
        throw new Exception(data);
    }
}

