/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redis.clients.jedis.Jedis;
import top.lieder.CommonFunction;
import top.lieder.Config;
import top.lieder.Environment;
import top.lieder.JSON;

public class Redis {
    private static final Logger log = LogManager.getLogger(Redis.class);
    static JSON json = new JSON();
    static boolean testMode = Environment.getTestMode();
    static boolean innerMode = Environment.getInnerMode();
    boolean shortConnect = true;
    AtomicLong lastCloseTime = new AtomicLong(CommonFunction.getTimestamp());
    Jedis redis;
    static String innerPath = Config.getConfig(testMode ? "spring.redis.host.test.inner" : "spring.redis.host.formal.inner");
    static String outerPath = Config.getConfig("spring.redis.host.outer");
    static String userName = Config.getConfig("spring.redis.client-name");
    static String password = Config.getConfig("spring.redis.password");
    static int innerPort = Integer.parseInt(Objects.requireNonNull(Config.getConfig("spring.redis.port.inner")));
    static int outerPort = Integer.parseInt(Objects.requireNonNull(Config.getConfig(testMode ? "spring.redis.port.outer.test" : "spring.redis.port.outer.formal")));
    int dbIndex = 0;
    boolean randomTime;

    public Redis() {
        this.init(0, true, true);
    }

    public Redis(boolean shortConnect) {
        this.init(0, true, shortConnect);
    }

    public Redis(int dbIndex, boolean shortConnect) {
        this.init(dbIndex, true, shortConnect);
    }

    public Redis(int dbIndex, boolean randomTime, boolean shortConnect) {
        this.init(dbIndex, randomTime, shortConnect);
    }

    void init(int dbIndex, boolean randomTime, boolean shortConnect) {
        this.dbIndex = dbIndex;
        this.randomTime = randomTime;
        this.shortConnect = shortConnect;
    }

    int randomTime(int time) {
        if (!this.randomTime) {
            return time;
        }
        Random random = new Random();
        return (int)((double)time * (random.nextDouble() + 0.5));
    }

    long randomTime(long time) {
        if (!this.randomTime) {
            return time;
        }
        Random random = new Random();
        return (long)((double)time * (random.nextDouble() + 0.5));
    }

    void connect() {
        if (innerMode) {
            try {
                this.redis = new Jedis(innerPath, innerPort);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.redis = new Jedis(outerPath, outerPort);
            }
        } else {
            this.redis = new Jedis(outerPath, outerPort);
        }
        if (password != null && !Objects.equals(password, "")) {
            this.redis.auth(userName, password);
        }
        this.redis.select(this.dbIndex);
    }

    public void reconnect() {
        this.close();
        this.connect();
    }

    public void close() {
        try {
            if (this.redis != null) {
                this.redis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setHard(String key, Object value) {
        this.reconnect();
        this.redis.set(key, json.toJson(value));
        try {
            this.redis.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.redis.exists(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public boolean setHard(String key, Object value, long time) {
        this.reconnect();
        time = this.randomTime(time);
        this.redis.setex(key, time, json.toJson(value));
        try {
            this.redis.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.redis.exists(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public boolean set(String key, String value) {
        this.reconnect();
        if (!this.redis.exists(key)) {
            this.redis.set(key, value);
        }
        try {
            this.redis.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.redis.exists(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public boolean set(String key, String value, long time) {
        this.reconnect();
        time = this.randomTime(time);
        this.redis.setex(key, time, value);
        try {
            this.redis.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = this.redis.exists(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public boolean containKey(String key) {
        this.reconnect();
        log.info(key);
        boolean result = this.redis.exists(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public String setBg(String key, String value) {
        this.reconnect();
        String result = this.redis.set(key, value);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public String setBg(String key, String value, long time) {
        this.reconnect();
        time = this.randomTime(time);
        String result = this.redis.setex(key, time, value);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public boolean setAsync(String key, Object value, int time) {
        boolean result = this.set(key, json.toJson(value), time);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public String get(String key) {
        this.reconnect();
        if (!this.redis.exists(key)) {
            return null;
        }
        String result = this.redis.get(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public long remove(String key) {
        this.reconnect();
        long result = this.redis.unlink(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public long delete(String key) {
        this.reconnect();
        long result = this.redis.del(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public Long setTime(String key, long time) {
        this.reconnect();
        time = this.randomTime(time);
        Long result = this.redis.expire(key, time);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public Long setTimeAt(String key, long time) {
        this.reconnect();
        time = this.randomTime(time);
        Long result = this.redis.expireAt(key, time);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public Long getTime(String key) {
        this.reconnect();
        Long result = this.redis.ttl(key);
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public Set<String> getAllKeys() {
        this.reconnect();
        Set result = this.redis.keys("*");
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public String cleanAllData() {
        this.reconnect();
        String result = this.redis.flushDB();
        if (this.shortConnect) {
            this.close();
        }
        return result;
    }

    public static class DatabaseType {
        public static final int WECHAT_LOGIN = 0;
        public static final int WECHAT_SQL = 1;
        public static final int LOGIN = 2;
        public static final int SQL = 3;
        public static final int BASE_SEAT_MAP = 5;
        public static final int ACTIVITY_SEAT_MAP = 6;
        public static final int MONGO_DB = 7;
        public static final int BILL_LOCK = 9;
        public static final int VERIFIED_CODE = 10;
        public static final int DEFAULT = 11;
        public static final int COUNT_MAP = 12;
        public static final int SHIT_MZ_CACHE = 13;
        public static final int COMMON_PARAM = 14;
    }
}

