/*
 * Decompiled with CFR 0.152.
 */
package top.lieder.modelBase;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.CommonFunction;
import top.lieder.CommonGet;
import top.lieder.JSON;
import top.lieder.PgSQL;
import top.lieder.modelBase.SqlAnnotation;
import top.lieder.modelBase.SqlOperateClass;

public class ModelBase {
    private static final Logger log = LogManager.getLogger(ModelBase.class);
    @SqlAnnotation.Ignore
    private static final JSON json = new JSON();
    @SqlAnnotation.Ignore
    private String sqlTableName = "";

    public ModelBase(String tableName) {
        this.sqlTableName = tableName;
    }

    <T> T transType(Object input) {
        return json.trans(input);
    }

    <T> T transType(Object input, Class<T> clazz) {
        return json.trans(input, clazz);
    }

    <T> List<T> transTypeList(List<Map<String, Object>> input) {
        input = this.dealWithJsonb(input);
        return (List)json.trans(input);
    }

    <T> T getObjectFromJsonb(Object input) {
        if (input == null) {
            return null;
        }
        String jsonbString = CommonFunction.getJsonBFromInput(input);
        return json.fromJson(jsonbString);
    }

    List<Map<String, Object>> dealWithJsonb(List<Map<String, Object>> input) {
        if (input == null || input.size() < 1) {
            return input;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        HashSet<String> jsonbKeys = new HashSet<String>();
        boolean deal = false;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SqlAnnotation.JsonbType.class)) continue;
            deal = true;
            jsonbKeys.add(field.getName());
        }
        if (!deal) {
            return input;
        }
        for (Map map : input) {
            for (String key : jsonbKeys) {
                map.put(key, this.getObjectFromJsonb(map.get(key)));
            }
        }
        return input;
    }

    String getIdKey(Field[] fields) throws Exception {
        List<String> keyNameList = Arrays.stream(fields).filter(s -> s.isAnnotationPresent(SqlAnnotation.IdKey.class) && s.getAnnotation(SqlAnnotation.IdKey.class).ifIdentity()).map(Field::getName).distinct().toList();
        if (keyNameList.size() > 1) {
            throw new Exception("\u591a\u4e8e\u4e00\u4e2a\u81ea\u589eid\u6ce8\u89e3");
        }
        return keyNameList.size() > 0 ? keyNameList.get(0) : null;
    }

    String whereCommendCreator_search(Map<String, Field> fieldMap, List<Object> valueList, Map<CommonGet.SearchType, Map<String, Object>> searchMap, String owner) throws Exception {
        if (searchMap == null || searchMap.size() == 0) {
            return "";
        }
        if (valueList == null) {
            throw new Exception("valueList\u4e0d\u53ef\u4e3anull");
        }
        Set<String> columnNames = fieldMap.keySet();
        ArrayList<Object> whereSql = new ArrayList<Object>();
        if (owner != null) {
            whereSql.add("owner = ?");
            valueList.add(owner);
        }
        block5: for (Map.Entry<CommonGet.SearchType, Map<String, Object>> search : searchMap.entrySet()) {
            Map<String, Object> searchElement = search.getValue();
            switch (search.getKey()) {
                case Accurate: {
                    String jsonbName;
                    String colName;
                    String[] nameList;
                    for (String key : searchElement.keySet()) {
                        nameList = key.split("\\|");
                        colName = nameList[0];
                        if (!columnNames.contains(colName)) {
                            throw new Exception("\u4e0d\u5305\u542bcolumnName:" + colName);
                        }
                        if (fieldMap.get(colName).isAnnotationPresent(SqlAnnotation.JsonbType.class)) {
                            if (fieldMap.get(colName).getType() == List.class) {
                                throw new Exception("Accurate\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u5185\u7c7b\u578b\u4e3aList\u7684Jsonb\u683c\u5f0f\u6570\u636e:" + key);
                            }
                            if (nameList.length < 2) {
                                throw new Exception("Accurate\u7c7b\u578bJsonb\u683c\u5f0fkey:" + key + "\u9700\u8981\u7528\uff5c\u4f5c\u4e3a\u5206\u9694\u7b26");
                            }
                            jsonbName = nameList[1];
                            whereSql.add(colName + "->> ? = ?");
                            valueList.add(jsonbName);
                        } else {
                            whereSql.add(colName + " = ?");
                        }
                        valueList.add(searchElement.get(key));
                    }
                    continue block5;
                }
                case Vague: {
                    String jsonbName;
                    String colName;
                    String[] nameList;
                    for (String key : searchElement.keySet()) {
                        nameList = key.split("\\|");
                        colName = nameList[0];
                        if (!columnNames.contains(colName)) {
                            throw new Exception("\u4e0d\u5305\u542bcolumnName:" + colName);
                        }
                        if (fieldMap.get(colName).isAnnotationPresent(SqlAnnotation.JsonbType.class)) {
                            if (fieldMap.get(colName).getType() == List.class) {
                                throw new Exception("Vague\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u5185\u7c7b\u578b\u4e3aList\u7684Jsonb\u683c\u5f0f\u6570\u636e:" + key);
                            }
                            if (nameList.length < 2) {
                                throw new Exception("Vague\u7c7b\u578bJsonb\u683c\u5f0fkey:" + key + "\u9700\u8981\u7528\uff5c\u4f5c\u4e3a\u5206\u9694\u7b26");
                            }
                            jsonbName = nameList[1];
                            whereSql.add(colName + "->> ? ilike ?");
                            valueList.add(jsonbName);
                        } else {
                            if (fieldMap.get(colName).getType() != String.class) {
                                throw new Exception("key:" + colName + " \u5728Vague\u7c7b\u578b\u4e2d\u4e0d\u4e3aString\u683c\u5f0f");
                            }
                            whereSql.add(colName + " ilike ?");
                        }
                        valueList.add("%" + searchElement.get(key).toString() + "%");
                    }
                    continue block5;
                }
                case Range: {
                    String colName;
                    String[] nameList;
                    for (String key : searchElement.keySet()) {
                        nameList = key.split("\\|");
                        colName = nameList[0];
                        if (!columnNames.contains(colName)) {
                            throw new Exception("\u4e0d\u5305\u542bcolumnName:" + colName);
                        }
                        if (fieldMap.get(key).getType() != Number.class) {
                            throw new Exception("key:" + key + " \u5728Range\u7c7b\u578b\u4e2d\u4e0d\u4e3aNumber\u683c\u5f0f");
                        }
                        Map rangeMap = (Map)this.transType(searchElement.get(key));
                        if (fieldMap.get(key).isAnnotationPresent(SqlAnnotation.JsonbType.class)) {
                            if (fieldMap.get(colName).getType() == List.class) {
                                throw new Exception("Range\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u5185\u7c7b\u578b\u4e3aList\u7684Jsonb\u683c\u5f0f\u6570\u636e:" + key);
                            }
                            if (nameList.length < 2) {
                                throw new Exception("Range\u7c7b\u578bJsonb\u683c\u5f0fkey:" + key + "\u9700\u8981\u7528\uff5c\u4f5c\u4e3a\u5206\u9694\u7b26");
                            }
                            String jsonbName = nameList[1];
                            if (rangeMap.containsKey("start")) {
                                whereSql.add(colName + "->> ? >= ?");
                                valueList.add(jsonbName);
                                valueList.add(rangeMap.get("start"));
                            }
                            if (!rangeMap.containsKey("end")) continue;
                            whereSql.add(colName + "->> ? <= ?");
                            valueList.add(jsonbName);
                            valueList.add(rangeMap.get("end"));
                            continue;
                        }
                        if (rangeMap.containsKey("start")) {
                            whereSql.add(colName + " >= ?");
                            valueList.add(rangeMap.get("start"));
                        }
                        if (!rangeMap.containsKey("end")) continue;
                        whereSql.add(colName + " <= ?");
                        valueList.add(rangeMap.get("end"));
                    }
                    continue block5;
                }
            }
        }
        return String.join((CharSequence)" and ", whereSql);
    }

    String orderCommendCreator_search(Map<String, Field> fieldMap, List<SqlOperateClass.OrderCell> orderNameList) throws Exception {
        if (orderNameList == null || orderNameList.size() < 1) {
            return "";
        }
        ArrayList<CallSite> resultList = new ArrayList<CallSite>();
        for (SqlOperateClass.OrderCell orderCell : orderNameList) {
            String name = orderCell.columnName;
            if (!fieldMap.containsKey(name)) {
                throw new Exception("\u4e0d\u5305\u542b\u8be5key: " + name);
            }
            resultList.add((CallSite)((Object)(name + (orderCell.desc ? " desc" : ""))));
        }
        return " order by " + String.join((CharSequence)", ", resultList);
    }

    public <T> SqlOperateClass.SearchResult<T> searchFromSQL(String[] valueKeyLimit, Map<CommonGet.SearchType, Map<String, Object>> searchMap, String owner, Integer page_offset, Integer page_count, List<SqlOperateClass.OrderCell> orderList) throws Exception {
        PgSQL sql = new PgSQL();
        Field[] fields = this.getClass().getDeclaredFields();
        Map<String, Field> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getName, s -> s));
        ArrayList<Object> whereValueList = new ArrayList<Object>();
        String whereString = this.whereCommendCreator_search(fieldMap, whereValueList, searchMap, owner);
        String countSqlString = "select count(*) as count from " + this.sqlTableName + whereString + ";";
        int count = CommonFunction.getIntFromObject(((Map)sql.select(countSqlString, whereValueList.toArray(), false).get(0)).get("count"));
        String valueSql = valueKeyLimit == null || valueKeyLimit.length < 1 ? "*" : String.join((CharSequence)", ", valueKeyLimit);
        String dataSqlString = "select " + valueSql + " from " + this.sqlTableName + whereString + CommonFunction.getLimitSkipSubSql(whereValueList, page_offset, page_count) + this.orderCommendCreator_search(fieldMap, orderList) + ";";
        List<Map<String, Object>> data = sql.select(dataSqlString, whereValueList.toArray(), true);
        return new SqlOperateClass.SearchResult<T>(count, this.transTypeList(data));
    }

    public <T> SqlOperateClass.SearchResult<T> searchFromSQL_all(Map<CommonGet.SearchType, Map<String, Object>> searchMap, String owner, Integer page_offset, Integer page_count, List<SqlOperateClass.OrderCell> orderList) throws Exception {
        return this.searchFromSQL(null, searchMap, owner, page_offset, page_count, orderList);
    }

    String whereCommendCreator_select(List<Object> valueList, List<SqlOperateClass.ConditionCell> conditionList) throws Exception {
        if (conditionList == null || conditionList.size() < 1) {
            return "";
        }
        if (valueList == null) {
            throw new Exception("valueList\u4e3anull");
        }
        Field[] fields = this.getClass().getDeclaredFields();
        Set jsonbNameSet = Arrays.stream(fields).filter(s -> s.isAnnotationPresent(SqlAnnotation.JsonbType.class)).map(Field::getName).collect(Collectors.toSet());
        ArrayList<CallSite> wherePair = new ArrayList<CallSite>();
        String whereSql = " where ";
        for (SqlOperateClass.ConditionCell condition : conditionList) {
            String name = condition.keyName;
            Object value = condition.value;
            if (value == null) {
                throw new Exception("where\u8bed\u53e5value\u4e3anull: " + name);
            }
            if (jsonbNameSet.contains(name)) {
                throw new Exception("sql\u81ea\u64cd\u4f5c\u6682\u65f6\u65e0\u6cd5\u652f\u6301where\u8bed\u53e5\u4e2d\u7684jsonb\u7c7b\u578b: " + name);
            }
            wherePair.add((CallSite)((Object)(name + " " + condition.getEqualTypeString() + " ?")));
            valueList.add(value);
        }
        return whereSql + String.join((CharSequence)" and ", wherePair);
    }

    public <T> List<T> selectFromSQL(String[] valueKeyLimit, List<SqlOperateClass.ConditionCell> conditionList, boolean orderById) throws Exception {
        PgSQL sql = new PgSQL();
        String idKey = orderById ? this.getIdKey(this.getClass().getDeclaredFields()) : null;
        String valueSql = valueKeyLimit == null || valueKeyLimit.length < 1 ? "*" : String.join((CharSequence)", ", valueKeyLimit);
        ArrayList<Object> whereValueList = new ArrayList<Object>();
        String sqlString = "select " + valueSql + " from " + this.sqlTableName + this.whereCommendCreator_select(whereValueList, conditionList) + (String)(idKey == null ? "" : " order by " + idKey + " desc") + ";";
        List<Map<String, Object>> result = sql.select(sqlString, whereValueList.toArray(), true);
        return this.transTypeList(result);
    }

    public <T> List<T> selectAll() throws Exception {
        return this.selectFromSQL(null, null, true);
    }

    public <T> T selectOne_viaId(int id) throws Exception {
        List<T> list = this.selectAll_viaId(id);
        if (list.size() < 1) {
            throw new Exception("no such id:" + id);
        }
        return list.get(0);
    }

    public <T> List<T> selectAll_viaId(int id) throws Exception {
        String idKey = this.getIdKey(this.getClass().getDeclaredFields());
        if (idKey == null) {
            throw new Exception("\u672a\u6ce8\u89e3id,\u65e0\u6cd5\u81ea\u751f\u6210select");
        }
        return this.selectFromSQL(null, Collections.singletonList(new SqlOperateClass.ConditionCell(idKey, id)), true);
    }

    public <T> List<T> selectAll_viaOwner(String owner) throws Exception {
        return this.selectFromSQL(null, Collections.singletonList(new SqlOperateClass.ConditionCell("owner", owner)), true);
    }

    public <T> List<T> selectAll_viaIdOwner(int id, String owner) throws Exception {
        String idKey = this.getIdKey(this.getClass().getDeclaredFields());
        if (idKey == null) {
            throw new Exception("\u672a\u6ce8\u89e3id,\u65e0\u6cd5\u81ea\u751f\u6210select");
        }
        ArrayList<SqlOperateClass.ConditionCell> conditionCells = new ArrayList<SqlOperateClass.ConditionCell>();
        conditionCells.add(new SqlOperateClass.ConditionCell(idKey, id));
        conditionCells.add(new SqlOperateClass.ConditionCell("owner", owner));
        return this.selectFromSQL(null, conditionCells, true);
    }

    public void insertToSQL() throws Exception {
        Object[] params;
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> placeholderList = new ArrayList<String>();
        ArrayList<String> paramList = new ArrayList<String>();
        Field[] fields = this.getClass().getDeclaredFields();
        Map valueMap = (Map)this.transType(this);
        for (Field field : fields) {
            String name;
            String value;
            if (field.isAnnotationPresent(SqlAnnotation.Ignore.class) && field.getAnnotation(SqlAnnotation.Ignore.class).ignoreForInsert() || field.isAnnotationPresent(SqlAnnotation.IdKey.class) && field.getAnnotation(SqlAnnotation.IdKey.class).ifIdentity() || (value = valueMap.getOrDefault(name = field.getName(), null)) == null) continue;
            boolean jsonb = field.isAnnotationPresent(SqlAnnotation.JsonbType.class);
            nameList.add(name);
            placeholderList.add(jsonb ? "?::jsonb" : "?");
            paramList.add(jsonb ? CommonFunction.getJsonBFromInput(value) : value);
        }
        if (nameList.size() < 1) {
            throw new Exception("\u7a7asql");
        }
        String sqlString = "insert into " + this.sqlTableName + " (" + String.join((CharSequence)", ", nameList) + ") values (" + String.join((CharSequence)", ", placeholderList) + ");";
        if (new PgSQL().update(sqlString, params = paramList.toArray(new Object[0]), this.sqlTableName + " ", false) < 1) {
            throw new Exception(this.sqlTableName + " sql\u6570\u636e\u63d2\u5165\u5931\u8d25");
        }
        log.warn("");
    }

    public void updateViaId() throws Exception {
        this.update(SqlOperateClass.UpdateRangeType.Only_Id, null, null);
    }

    public void updateViaIdOwner(String owner) throws Exception {
        this.update(SqlOperateClass.UpdateRangeType.Only_IdOwner, null, null);
    }

    public Map<String, SqlOperateClass.EqualType> sortConditionKeys(String keyName, SqlOperateClass.UpdateRangeType updateRangeType, Map<String, SqlOperateClass.EqualType> anotherRangeKeys) throws Exception {
        switch (updateRangeType) {
            case Only_Id: {
                if (anotherRangeKeys != null && !anotherRangeKeys.isEmpty()) {
                    throw new Exception("Only_Id\u60c5\u51b5\u4e0banotherRangeKeys\u4e0d\u4e3a\u7a7a");
                }
                if (keyName == null) {
                    throw new Exception("update key\u672a\u88ab\u6ce8\u89e3\u6807\u8bc6");
                }
                anotherRangeKeys = new HashMap<String, SqlOperateClass.EqualType>();
                anotherRangeKeys.put(keyName, SqlOperateClass.EqualType.Equal);
                break;
            }
            case Only_IdOwner: {
                if (anotherRangeKeys != null && !anotherRangeKeys.isEmpty()) {
                    throw new Exception("Only_IdOwner\u60c5\u51b5\u4e0banotherRangeKeys\u4e0d\u4e3a\u7a7a");
                }
                if (keyName == null) {
                    throw new Exception("update key\u672a\u88ab\u6ce8\u89e3\u6807\u8bc6");
                }
                anotherRangeKeys = new HashMap<String, SqlOperateClass.EqualType>();
                anotherRangeKeys.put(keyName, SqlOperateClass.EqualType.Equal);
                anotherRangeKeys.put("owner", SqlOperateClass.EqualType.Equal);
                break;
            }
            case Include_id: {
                if (keyName == null) {
                    throw new Exception("update key\u672a\u88ab\u6ce8\u89e3\u6807\u8bc6");
                }
                if (anotherRangeKeys == null) {
                    anotherRangeKeys = new HashMap<String, SqlOperateClass.EqualType>();
                }
                anotherRangeKeys.put(keyName, SqlOperateClass.EqualType.Equal);
                break;
            }
            case Include_IdOwner: {
                if (keyName == null) {
                    throw new Exception("update key\u672a\u88ab\u6ce8\u89e3\u6807\u8bc6");
                }
                if (anotherRangeKeys == null) {
                    anotherRangeKeys = new HashMap<String, SqlOperateClass.EqualType>();
                }
                anotherRangeKeys.put(keyName, SqlOperateClass.EqualType.Equal);
                anotherRangeKeys.put("owner", SqlOperateClass.EqualType.Equal);
                break;
            }
            case Another: {
                return anotherRangeKeys;
            }
        }
        return anotherRangeKeys;
    }

    public void update(SqlOperateClass.UpdateRangeType updateRangeType, Map<String, SqlOperateClass.EqualType> conditionKeys, Set<String> valueKeyLimit) throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        Field[] fields = this.getClass().getDeclaredFields();
        String keyName = this.getIdKey(fields);
        conditionKeys = this.sortConditionKeys(keyName, updateRangeType, conditionKeys);
        Set nameSet = Arrays.stream(fields).map(Field::getName).collect(Collectors.toSet());
        Set<String> conditionNameSet = conditionKeys.keySet();
        HashSet valueNameSet = new HashSet(nameSet);
        valueNameSet.removeAll(conditionNameSet);
        if (valueKeyLimit != null) {
            valueNameSet.retainAll(valueKeyLimit);
        }
        Map valueMap = (Map)this.transType(this);
        ArrayList<CallSite> sqlList = new ArrayList<CallSite>();
        ArrayList<SqlOperateClass.ConditionCell> conditionList = new ArrayList<SqlOperateClass.ConditionCell>();
        for (Field field : fields) {
            String key = field.getName();
            String value = valueMap.getOrDefault(key, null);
            if (conditionNameSet.contains(key)) {
                if (field.isAnnotationPresent(SqlAnnotation.JsonbType.class)) {
                    throw new Exception("\u76ee\u524d\u81ea\u52a8\u65b9\u6cd5\u6682\u4e0d\u652f\u6301jsonb\u683c\u5f0fcondition\u9879: " + key);
                }
                conditionList.add(new SqlOperateClass.ConditionCell(key, conditionKeys.get(key), valueMap.get(key)));
            }
            if (field.isAnnotationPresent(SqlAnnotation.Ignore.class) && field.getAnnotation(SqlAnnotation.Ignore.class).ignoreForUpdate() || field.isAnnotationPresent(SqlAnnotation.IdKey.class) || field.getName().equals("owner") || field.getName().equals("owner_set") || value == null || !valueNameSet.contains(key)) continue;
            boolean jsonb = field.isAnnotationPresent(SqlAnnotation.JsonbType.class);
            sqlList.add((CallSite)((Object)(key + " = " + (jsonb ? "?::jsonb" : "?"))));
            objectList.add(jsonb ? CommonFunction.getJsonBFromInput(value) : value);
        }
        StringBuilder sqlString = new StringBuilder("update " + this.sqlTableName + " set " + String.join((CharSequence)", ", sqlList));
        if (!conditionKeys.isEmpty()) {
            sqlString.append(" where ");
            ArrayList<CallSite> conditionSqlList = new ArrayList<CallSite>();
            for (SqlOperateClass.ConditionCell condition : conditionList) {
                conditionSqlList.add((CallSite)((Object)(condition.keyName + " " + condition.getEqualTypeString() + " ?")));
                objectList.add((String)valueMap.get(condition.keyName));
            }
            sqlString.append(String.join((CharSequence)" and ", conditionSqlList));
        }
        sqlString.append(";");
        int result = new PgSQL().update(sqlString.toString(), objectList.toArray(), this.sqlTableName, false);
        if (result < 1) {
            throw new Exception(this.sqlTableName + " sql\u6570\u636e\u66f4\u65b0\u5931\u8d25");
        }
    }
}

