/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

public class ResResult {
    private Integer code;
    private String message;
    private Object data;
    private String comment;

    public ResResult(Integer code, String message, Object data, String comment) {
        this.code = code;
        this.message = message;
        this.data = data == null ? "" : data;
        this.comment = comment;
    }

    public ResResult(ResultCode resultCode) {
        this.code = resultCode.code;
        this.message = resultCode.message;
    }

    public void setSuccess(Object data) {
        this.setSuccess(data, "");
    }

    public void setSuccess(Object data, String comment) {
        this.code = ResultCode.SUCCESS.code;
        this.message = ResultCode.SUCCESS.message;
        this.data = data;
        this.comment = comment;
    }

    public void setFail(ResultCode resultCode) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = "";
        this.comment = "";
    }

    public void setFail(ResultCode resultCode, String reason) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = "";
        this.comment = reason;
    }

    public void setFail(Object result, ResultCode resultCode) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = result;
        this.comment = "";
    }

    public void flush(ResResult resResult) {
        this.code = resResult.code;
        this.message = resResult.message;
        this.data = resResult.data;
        this.comment = resResult.comment;
    }

    public static ResResult success() {
        return ResResult.success(null);
    }

    public static ResResult success(Object data) {
        return ResResult.success(data, "");
    }

    public static ResResult success(Object data, String comment) {
        return new ResResult(ResultCode.SUCCESS.code, ResultCode.SUCCESS.message, data, comment);
    }

    public static ResResult fail(ResultCode resultCode) {
        return ResResult.fail(resultCode, "");
    }

    public static ResResult fail(ResultCode resultCode, String comment) {
        return ResResult.fail(resultCode, comment, "");
    }

    public static ResResult fail(ResultCode resultCode, Object data) {
        return ResResult.fail(resultCode, "", data);
    }

    public static ResResult fail(ResultCode resultCode, String comment, Object data) {
        return new ResResult(resultCode.code, resultCode.message, data, comment);
    }

    private static Integer $default$code() {
        return 0;
    }

    private static String $default$message() {
        return "\u6210\u529f";
    }

    private static Object $default$data() {
        return "";
    }

    private static String $default$comment() {
        return "";
    }

    public static ResResultBuilder builder() {
        return new ResResultBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResResult)) {
            return false;
        }
        ResResult other = (ResResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "ResResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", comment=" + this.getComment() + ")";
    }

    public ResResult() {
        this.code = ResResult.$default$code();
        this.message = ResResult.$default$message();
        this.data = ResResult.$default$data();
        this.comment = ResResult.$default$comment();
    }

    public static enum ResultCode {
        SUCCESS(0, "\u6210\u529f"),
        PARAM_INVALID(1001, "\u53c2\u6570\u65e0\u6548"),
        PARAM_TYPE_ERROR(1003, "\u53c2\u6570\u7c7b\u578b\u9519\u8bef"),
        PARAM_UNCOMPLETED(1004, "\u53c2\u6570\u7f3a\u5931"),
        USER_NOT_EXISTED(2001, "\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef"),
        USER_NOT_LOGIN(2002, "\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u672a\u767b\u5f55"),
        USER_NOT_AUTH(2003, "\u8d26\u53f7\u65e0\u6743\u9650"),
        USER_FORBIDDEN(2004, "\u8d26\u53f7\u7981\u7528"),
        USER_OFFSITE(2005, "\u5f02\u5730\u767b\u9646"),
        OVER_FREQ(2006, "\u8d85\u9891"),
        OWNER_NOT_MATCH(2007, "\u4e0d\u5177\u6709\u8be5\u6240\u6709\u6743\u64cd\u4f5c\u6743\u9650"),
        LOGIN_OFFSITE(2008, "\u767b\u9646ip\u53d8\u66f4\uff0c\u6216\u5b58\u5728\u5f02\u5730\u767b\u9646\u3001\u591a\u8d26\u53f7\u767b\u5f55\u6216IP\u52a8\u6001\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"),
        MANAGER_OWNER_FORBIDDEN(2009, "\u8be5\u8d26\u53f7\u4e0d\u5177\u6709\u8be5\u533a\u57df\u64cd\u4f5c\u6743"),
        OWNER_FORBIDDEN(2010, "\u4e0d\u5177\u6709\u8be5\u6570\u636e\u64cd\u4f5c\u6743\u9650"),
        USER_CROSS(2011, "\u8d26\u53f7\u4ea4\u53c9"),
        TOKEN_NOT_EXISTED(3001, "token\u4e0d\u5b58\u5728"),
        OPERATE_FAIL(4001, "\u64cd\u4f5c\u5931\u8d25"),
        THIRD_FAIL(5001, "\u7b2c\u4e09\u65b9\u62a5\u9519"),
        INNER_FAIL(6001, "\u670d\u52a1\u62a5\u9519"),
        UNDEFINED(10001, "\u672a\u5b9a\u4e49");

        private final int code;
        private final String message;

        private ResultCode(Integer code, String message) {
            this.code = code;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ResResultBuilder {
        private boolean code$set;
        private Integer code$value;
        private boolean message$set;
        private String message$value;
        private boolean data$set;
        private Object data$value;
        private boolean comment$set;
        private String comment$value;

        ResResultBuilder() {
        }

        public ResResultBuilder code(Integer code) {
            this.code$value = code;
            this.code$set = true;
            return this;
        }

        public ResResultBuilder message(String message) {
            this.message$value = message;
            this.message$set = true;
            return this;
        }

        public ResResultBuilder data(Object data) {
            this.data$value = data;
            this.data$set = true;
            return this;
        }

        public ResResultBuilder comment(String comment) {
            this.comment$value = comment;
            this.comment$set = true;
            return this;
        }

        public ResResult build() {
            Integer code$value = this.code$value;
            if (!this.code$set) {
                code$value = ResResult.$default$code();
            }
            String message$value = this.message$value;
            if (!this.message$set) {
                message$value = ResResult.$default$message();
            }
            Object data$value = this.data$value;
            if (!this.data$set) {
                data$value = ResResult.$default$data();
            }
            String comment$value = this.comment$value;
            if (!this.comment$set) {
                comment$value = ResResult.$default$comment();
            }
            return new ResResult(code$value, message$value, data$value, comment$value);
        }

        public String toString() {
            return "ResResult.ResResultBuilder(code$value=" + this.code$value + ", message$value=" + this.message$value + ", data$value=" + this.data$value + ", comment$value=" + this.comment$value + ")";
        }
    }
}

