/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class Config {
    private static final Logger log = LogManager.getLogger(Config.class);
    private static final String APPLICATION_PROPERTIES = "application.properties";

    public static void fillConfig(String propertiesName, Properties properties) {
        try {
            ClassPathResource resource = new ClassPathResource(propertiesName);
            PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
        }
        catch (IOException e) {
            log.error("config reader fillConfig", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void fillConfig(Properties properties) {
        Config.fillConfig(APPLICATION_PROPERTIES, properties);
    }

    public static String getConfig(String key, String defaultValue) {
        try {
            ClassPathResource resource = new ClassPathResource(APPLICATION_PROPERTIES);
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            return properties.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            log.error("config reader getConfig", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static String getConfig(String key) {
        try {
            ClassPathResource resource = new ClassPathResource(APPLICATION_PROPERTIES);
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            return properties.getProperty(key);
        }
        catch (Exception e) {
            log.error("config reader getConfig", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }
}

