/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import top.lieder.CommonFunction;
import top.lieder.Config;
import top.lieder.Environment;
import top.lieder.JSON;
import top.lieder.PgSQL;
import top.lieder.Redis;

public class MongoDB {
    private static final Logger log = LogManager.getLogger(MongoDB.class);
    static JSON json = new JSON();
    static boolean innerMode = Environment.getInnerMode();
    static String outerPath = Config.getConfig("mongoDB.ServerAddress.outer");
    static String innerPath1 = Config.getConfig("mongoDB.ServerAddress.Primary.inner");
    static String innerPath2 = Config.getConfig("mongoDB.ServerAddress.Secondary.inner");
    static int outerPort1 = Integer.parseInt(Objects.requireNonNull(Config.getConfig("mongoDB.port.Primary.outer")));
    static int outerPort2 = Integer.parseInt(Objects.requireNonNull(Config.getConfig("mongoDB.port.Secondary.outer")));
    static int innerPort = Integer.parseInt(Objects.requireNonNull(Config.getConfig("mongoDB.port.inner")));
    static int port;
    public ServerAddress seed1;
    public ServerAddress seed2;
    public String username;
    public String password;
    public String ReplSetName;
    public String DEFAULT_DB;
    public MongoClient mongoClient;
    public MongoDatabase mongoDatabase;
    public MongoCollection<Document> mongoCollection;
    String databaseName = "test";
    String collectionName = "test";
    int cacheDataBaseIndex;
    int cacheTime_s = 3600;
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    LinkedList<Document> queue = new LinkedList();
    AtomicBoolean working = new AtomicBoolean(false);

    public MongoDB() {
        this.init(this.databaseName, this.collectionName);
    }

    public MongoDB(String collectionName) {
        this.init(this.databaseName, collectionName);
    }

    public MongoDB(String databaseName, String collectionName) {
        this.init(databaseName, collectionName);
    }

    void init(String databaseName, String collectionName) {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        if (innerMode) {
            try {
                this.seed1 = new ServerAddress(innerPath1, innerPort);
                this.seed2 = new ServerAddress(innerPath2, innerPort);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.seed1 = new ServerAddress(outerPath, outerPort1);
                this.seed2 = new ServerAddress(outerPath, outerPort2);
            }
        } else {
            this.seed1 = new ServerAddress(outerPath, outerPort1);
            this.seed2 = new ServerAddress(outerPath, outerPort2);
        }
        this.username = Config.getConfig("mongoDB.username");
        this.password = Config.getConfig("mongoDB.password");
        this.ReplSetName = Config.getConfig("mongoDB.ReplSetName");
        this.DEFAULT_DB = Config.getConfig("mongoDB.DEFAULT_DB", "test");
        ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>();
        seedList.add(this.seed1);
        seedList.add(this.seed2);
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        assert (this.DEFAULT_DB != null);
        credentials.add(MongoCredential.createScramSha1Credential((String)this.username, (String)this.DEFAULT_DB, (char[])this.password.toCharArray()));
        MongoClientOptions options = MongoClientOptions.builder().requiredReplicaSetName(this.ReplSetName).threadsAllowedToBlockForConnectionMultiplier(5000).socketTimeout(30000).maxConnectionIdleTime(6000).socketKeepAlive(true).connectionsPerHost(50).build();
        this.mongoClient = new MongoClient(seedList, credentials, options);
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.mongoDatabase = this.mongoClient.getDatabase(databaseName);
        this.mongoCollection = this.mongoDatabase.getCollection(collectionName);
        this.cacheDataBaseIndex = 7;
    }

    public void setValue(Document dataMap) {
        if (dataMap == null || dataMap.size() < 1) {
            return;
        }
        long timestamp = dataMap.containsKey((Object)"create_time") ? CommonFunction.getLongFromObject(dataMap.get((Object)"create_time")) : CommonFunction.getTimestamp();
        if (!dataMap.containsKey((Object)"_id")) {
            dataMap.put("_id", (Object)new ObjectId().toString());
        }
        dataMap.put("create_date", (Object)this.dateFormat.format(new Date(timestamp)));
        dataMap.put("create_clock", (Object)this.timeFormat.format(new Date(timestamp)));
        dataMap.put("create_time", (Object)CommonFunction.getTimestamp());
        this.mongoCollection.insertOne((Object)dataMap);
        this.updateCache();
    }

    public void setValueList(List<Document> dataMap) {
        if (dataMap == null || dataMap.size() < 1) {
            return;
        }
        long timestamp = CommonFunction.getTimestamp();
        for (Document data : dataMap) {
            long time = data.containsKey((Object)"create_time") ? CommonFunction.getLongFromObject(data.get((Object)"create_time")) : timestamp;
            String _id = data.containsKey((Object)"_id") ? data.get((Object)"_id").toString() : new ObjectId().toString();
            data.put("_id", (Object)_id);
            data.put("create_date", (Object)this.dateFormat.format(new Date(time)));
            data.put("create_clock", (Object)this.timeFormat.format(new Date(time)));
            data.put("create_time", (Object)time);
        }
        this.mongoCollection.insertMany(dataMap);
        this.updateCache();
    }

    public void setValue(List<Map<String, Object>> dataMap) {
        if (dataMap == null || dataMap.size() < 1) {
            return;
        }
        long timestamp = CommonFunction.getTimestamp();
        ArrayList<Document> documentList = new ArrayList<Document>();
        for (Map<String, Object> data : dataMap) {
            long time = data.containsKey("create_time") ? CommonFunction.getLongFromObject(data.get("create_time")) : timestamp;
            String _id = data.containsKey("_id") ? data.get("_id").toString() : new ObjectId().toString();
            Document document = new Document(data);
            document.put("_id", (Object)_id);
            document.put("create_date", (Object)this.dateFormat.format(new Date(time)));
            document.put("create_clock", (Object)this.timeFormat.format(new Date(time)));
            document.put("create_time", (Object)time);
            documentList.add(document);
        }
        this.mongoCollection.insertMany(documentList);
        this.updateCache();
    }

    boolean flush() {
        if (this.working.get()) {
            return false;
        }
        try {
            Document document;
            if (this.queue.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            this.working.set(true);
            LinkedList<Document> documentList = new LinkedList<Document>();
            while ((document = this.queue.poll()) != null) {
                documentList.add(document);
            }
            this.setValueList(documentList);
            log.info("mongo\u5f55\u5165 " + documentList.size());
            Thread.sleep(200L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.working.set(false);
        }
        return true;
    }

    public void setValueAsync_highFreq(Document document) {
        this.queue.offer(document);
        if (!this.flush()) {
            Runnable runnable = () -> {
                if (this.queue.size() < 1) {
                    return;
                }
                log.info("mongo\u5c3e\u5237\u5f00\u59cb " + this.queue.size());
                log.info(this.queue);
                this.flush();
            };
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            service.schedule(runnable, 500L, TimeUnit.MILLISECONDS);
        }
    }

    static BasicDBObject getFilter(Set<FilterCell> searchList) {
        BasicDBObject result = new BasicDBObject();
        if (searchList != null) {
            for (FilterCell filterCell : searchList) {
                result.append(filterCell.key, filterCell.accurate ? filterCell.value : new BasicDBObject("$regex", filterCell.value));
            }
        }
        return result;
    }

    static BasicDBObject getSorter(List<SorterCell> sorterList) {
        BasicDBObject result = new BasicDBObject();
        if (sorterList != null) {
            for (SorterCell sorter : sorterList) {
                result.append(sorter.key, (Object)(sorter.ascending ? 1 : -1));
            }
        }
        return result;
    }

    public List<Map<String, Object>> getValue(String key, Object value, boolean accurate, boolean withCache) {
        return this.getValue(key, value, accurate, null, withCache);
    }

    public List<Map<String, Object>> getValue(String key, Object value, boolean accurate, List<SorterCell> sorterList, boolean withCache) {
        return this.getValue(Collections.singleton(FilterCell.builder().key(key).value(value).accurate(accurate).build()), sorterList, withCache);
    }

    public List<Map<String, Object>> getValue(FilterCell filterCell, boolean withCache) {
        return this.getValue(filterCell, null, withCache);
    }

    public List<Map<String, Object>> getValue(FilterCell filterCell, List<SorterCell> sorterList, boolean withCache) {
        return this.getValue(Collections.singleton(filterCell), sorterList, withCache);
    }

    public List<Map<String, Object>> getValue(Set<FilterCell> filterSet, boolean withCache) {
        return this.getValue(filterSet, null, withCache);
    }

    public List<Map<String, Object>> getValue(boolean withCache) {
        return this.getValue(new HashSet<FilterCell>(), null, withCache);
    }

    public List<Map<String, Object>> getValue(Set<FilterCell> filterSet, List<SorterCell> sorterList, boolean withCache) {
        Redis redis = new Redis(this.cacheDataBaseIndex, true);
        String key = this.getCacheHead() + "_|_filter_" + json.toJson(filterSet) + "_|_sorter_" + json.toJson(sorterList);
        try {
            if (withCache && redis.containKey(key)) {
                return (List)json.fromJson(redis.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FindIterable findIterable = this.mongoCollection.find((Bson)MongoDB.getFilter(filterSet));
        if (sorterList != null) {
            findIterable = findIterable.sort((Bson)MongoDB.getSorter(sorterList));
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        findIterable.forEach(result::add);
        if (withCache) {
            Thread thread = new Thread(() -> {
                try {
                    redis.setAsync(key, result, this.cacheTime_s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    redis.close();
                }
            });
            thread.start();
        }
        return result;
    }

    public void deleteValue(String key, Object value, boolean accurate) {
        this.deleteValue(FilterCell.builder().key(key).value(value).accurate(accurate).build());
    }

    public void deleteValue(FilterCell filterCell) {
        this.deleteValue(Collections.singleton(filterCell));
    }

    public void deleteValue(Set<FilterCell> filterSet) {
        this.mongoCollection.deleteMany((Bson)MongoDB.getFilter(filterSet));
        this.updateCache();
    }

    public boolean deleteAllValue(Set<FilterCell> filterSet) {
        DeleteResult result = this.mongoCollection.deleteMany((Bson)MongoDB.getFilter(filterSet));
        this.updateCache();
        return result.getDeletedCount() > 0L;
    }

    public boolean updateValue(String key, Object value, boolean accurate, Map<String, Object> newData) {
        return this.updateValue(Collections.singleton(FilterCell.builder().key(key).value(value).accurate(accurate).build()), newData);
    }

    public boolean updateValue(FilterCell filterCell, Map<String, Object> newData) {
        return this.updateValue(Collections.singleton(filterCell), newData);
    }

    public boolean updateValue(Set<FilterCell> filterSet, Map<String, Object> newData) {
        UpdateResult result = this.mongoCollection.updateMany((Bson)MongoDB.getFilter(filterSet), (Bson)this.getUpdateDocument(newData));
        this.updateCache();
        return result.getModifiedCount() > 0L;
    }

    public Document getUpdateDocument(Map<String, Object> dataMap) {
        return new Document("$set", (Object)new Document(dataMap));
    }

    public void updateManyValues(List<UpdateCell> updateList) throws Exception {
        for (UpdateCell updateCell : updateList) {
            if (this.mongoCollection.updateMany((Bson)MongoDB.getFilter(updateCell.filterSet), (Bson)this.getUpdateDocument(updateCell.newData)).getModifiedCount() >= 1L) continue;
            throw new Exception(json.toJson(updateCell.filterSet) + "\u66f4\u65b0\u9519\u8bef");
        }
        this.updateCache();
    }

    public boolean updateAllValue(Map<String, Object> newData) {
        UpdateResult result = this.mongoCollection.updateMany((Bson)MongoDB.getFilter(null), (Bson)this.getUpdateDocument(newData));
        this.updateCache();
        return result.getModifiedCount() > 0L;
    }

    public String getCacheHead() {
        return this.databaseName + "_|_" + this.collectionName;
    }

    void updateCache() {
        PgSQL.updateCache(this.getCacheHead(), false, this.cacheDataBaseIndex);
    }

    public static class FilterCell {
        public String key;
        public Object value;
        public boolean accurate;

        private static boolean $default$accurate() {
            return true;
        }

        public static FilterCellBuilder builder() {
            return new FilterCellBuilder();
        }

        public FilterCell() {
            this.accurate = FilterCell.$default$accurate();
        }

        public FilterCell(String key, Object value, boolean accurate) {
            this.key = key;
            this.value = value;
            this.accurate = accurate;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isAccurate() {
            return this.accurate;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setAccurate(boolean accurate) {
            this.accurate = accurate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterCell)) {
                return false;
            }
            FilterCell other = (FilterCell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAccurate() != other.isAccurate()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilterCell;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAccurate() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "MongoDB.FilterCell(key=" + this.getKey() + ", value=" + this.getValue() + ", accurate=" + this.isAccurate() + ")";
        }

        public static class FilterCellBuilder {
            private String key;
            private Object value;
            private boolean accurate$set;
            private boolean accurate$value;

            FilterCellBuilder() {
            }

            public FilterCellBuilder key(String key) {
                this.key = key;
                return this;
            }

            public FilterCellBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public FilterCellBuilder accurate(boolean accurate) {
                this.accurate$value = accurate;
                this.accurate$set = true;
                return this;
            }

            public FilterCell build() {
                boolean accurate$value = this.accurate$value;
                if (!this.accurate$set) {
                    accurate$value = FilterCell.$default$accurate();
                }
                return new FilterCell(this.key, this.value, accurate$value);
            }

            public String toString() {
                return "MongoDB.FilterCell.FilterCellBuilder(key=" + this.key + ", value=" + this.value + ", accurate$value=" + this.accurate$value + ")";
            }
        }
    }

    public static class SorterCell {
        public String key;
        public boolean ascending;

        private static boolean $default$ascending() {
            return true;
        }

        public static SorterCellBuilder builder() {
            return new SorterCellBuilder();
        }

        public SorterCell() {
            this.ascending = SorterCell.$default$ascending();
        }

        public SorterCell(String key, boolean ascending) {
            this.key = key;
            this.ascending = ascending;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SorterCell)) {
                return false;
            }
            SorterCell other = (SorterCell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAscending() != other.isAscending()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SorterCell;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAscending() ? 79 : 97);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        public String toString() {
            return "MongoDB.SorterCell(key=" + this.getKey() + ", ascending=" + this.isAscending() + ")";
        }

        public static class SorterCellBuilder {
            private String key;
            private boolean ascending$set;
            private boolean ascending$value;

            SorterCellBuilder() {
            }

            public SorterCellBuilder key(String key) {
                this.key = key;
                return this;
            }

            public SorterCellBuilder ascending(boolean ascending) {
                this.ascending$value = ascending;
                this.ascending$set = true;
                return this;
            }

            public SorterCell build() {
                boolean ascending$value = this.ascending$value;
                if (!this.ascending$set) {
                    ascending$value = SorterCell.$default$ascending();
                }
                return new SorterCell(this.key, ascending$value);
            }

            public String toString() {
                return "MongoDB.SorterCell.SorterCellBuilder(key=" + this.key + ", ascending$value=" + this.ascending$value + ")";
            }
        }
    }

    public static class UpdateCell {
        public Set<FilterCell> filterSet;
        public Map<String, Object> newData;

        public static UpdateCellBuilder builder() {
            return new UpdateCellBuilder();
        }

        public UpdateCell(Set<FilterCell> filterSet, Map<String, Object> newData) {
            this.filterSet = filterSet;
            this.newData = newData;
        }

        public static class UpdateCellBuilder {
            private Set<FilterCell> filterSet;
            private Map<String, Object> newData;

            UpdateCellBuilder() {
            }

            public UpdateCellBuilder filterSet(Set<FilterCell> filterSet) {
                this.filterSet = filterSet;
                return this;
            }

            public UpdateCellBuilder newData(Map<String, Object> newData) {
                this.newData = newData;
                return this;
            }

            public UpdateCell build() {
                return new UpdateCell(this.filterSet, this.newData);
            }

            public String toString() {
                return "MongoDB.UpdateCell.UpdateCellBuilder(filterSet=" + this.filterSet + ", newData=" + this.newData + ")";
            }
        }
    }
}

