/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.json.XML;
import org.postgresql.util.PGobject;
import top.lieder.Crypto;
import top.lieder.PgSQL;

public class CommonFunction {
    private static final PgSQL sql = new PgSQL();
    static Gson gson = new Gson();
    static ObjectMapper json = new ObjectMapper();

    public static <T> T transType(Object input, Class<T> t) {
        json.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        json.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        return (T)json.convertValue(input, t);
    }

    public static String getJsonBFromInput(Object input) {
        try {
            Map map;
            if (input == null) {
                return null;
            }
            if (String.class.equals(input.getClass())) {
                map = (Map)gson.fromJson(input.toString(), new TypeToken<Object>(){}.getType());
            } else {
                if (PGobject.class.equals(input.getClass())) {
                    return ((PGobject)input).getValue();
                }
                map = (Map)input;
            }
            if (map.containsKey("type") && Objects.equals(map.get("type").toString(), "jsonb") && map.containsKey("value")) {
                Object value = map.get("value");
                if (String.class.equals(value.getClass())) {
                    return value.toString();
                }
                return gson.toJson(value);
            }
            return gson.toJson((Object)map);
        }
        catch (Exception e) {
            return gson.toJson(input);
        }
    }

    public static String getStringFromObject(Object data) {
        return CommonFunction.getStringFromObject(data, "");
    }

    public static String getStringFromObject(Object data, String defaultValue) {
        return data == null ? defaultValue : data.toString();
    }

    public static double getDoubleFromObject(Object number, double defaultValue) {
        try {
            return (Double)number;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getIntFromObject(Object number) {
        try {
            return ((Number)number).intValue();
        }
        catch (Exception e) {
            return Integer.parseInt(number.toString());
        }
    }

    public static int getIntFromObject(Object number, int defaultValue) {
        try {
            return number == null ? defaultValue : CommonFunction.getIntFromObject(number);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object parseLongFromDouble(Object number) {
        if (number.getClass() == Double.class) {
            return ((Double)number).longValue();
        }
        return number;
    }

    public static Object parseLongStringFormDouble(Object number) {
        if (number.getClass() == Double.class) {
            return String.valueOf(((Double)number).longValue());
        }
        return number;
    }

    public static long getLongFromObject(Object number) {
        try {
            return ((Number)number).longValue();
        }
        catch (Exception e) {
            return Long.parseLong(number.toString());
        }
    }

    public static long getLongFromObject(Object number, long defaultValue) {
        try {
            return number == null ? defaultValue : CommonFunction.getLongFromObject(number);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolFromObject(Object data) {
        return Boolean.parseBoolean(data.toString());
    }

    public static boolean getBoolFromObject(Object data, boolean defaultValue) {
        try {
            return data == null ? defaultValue : CommonFunction.getBoolFromObject(data);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getPayBatchId(BillType billType, int client_id, long timestamp, String checkSql) throws Exception {
        int maxCount;
        Object payBatchId = (billType.name().charAt(0) + Crypto.MD5(String.valueOf(client_id)).substring(16) + "_" + String.valueOf(timestamp).substring(4) + "_" + CommonFunction.getRandomString(4)).substring(0, 32);
        for (maxCount = 10; sql.select(checkSql, new Object[]{payBatchId}, false).size() > 0 && maxCount > 0; --maxCount) {
            payBatchId = billType.name().charAt(0) + Crypto.MD5(String.valueOf(client_id)).substring(15) + "_" + String.valueOf(CommonFunction.getTimestamp()).substring(4) + "_" + CommonFunction.getRandomString(4);
        }
        if (maxCount <= 0) {
            throw new Exception("payBatchId\u751f\u6210\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5");
        }
        return payBatchId;
    }

    public static Map<String, Object> getResultWithLimitSkip(String sqlString, List<Object> paramList, Integer page_offset, Integer page_count, boolean withCache) {
        if (paramList == null) {
            paramList = new ArrayList<Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if ((sqlString = sqlString.trim()).endsWith(";")) {
            sqlString = sqlString.substring(0, sqlString.length() - 1);
        }
        String countSql = "select count(*) as count from (" + sqlString + ") result;";
        result.put("count", ((Map)sql.select(countSql, paramList.toArray(), true).get(0)).get("count"));
        String dataSql = "select * from (" + sqlString + ") result " + CommonFunction.getLimitSkipSubSql(paramList, page_offset, page_count) + ";";
        result.put("data", sql.select(dataSql, paramList.toArray(), withCache));
        return result;
    }

    public static String getLimitSkipSubSql(List<Object> paramList, Integer page_offset, Integer page_count) {
        Object result = "";
        int count = 1;
        if (page_count != null && page_count > -1) {
            paramList.add(page_count);
            count = page_count;
            result = (String)result + " limit ?";
        }
        if (page_offset != null && page_offset > -1) {
            Integer skip = count * page_offset;
            paramList.add(skip);
            result = (String)result + " offset ?";
        }
        return result;
    }

    public static String json2Xml(String json, String tagName) {
        JSONObject jsonObject = new JSONObject(json);
        return XML.toString((Object)jsonObject, (String)tagName);
    }

    public static String json2Xml(String json) {
        JSONObject jsonObject = new JSONObject(json);
        return XML.toString((Object)jsonObject, null);
    }

    public static String xml2Json(String xml) {
        return XML.toJSONObject((String)xml).toString();
    }

    public static Map<String, String> transToMap(String s) {
        Map map;
        try {
            map = (Map)gson.fromJson(s, new TypeToken<Object>(){}.getType());
        }
        catch (Exception e) {
            map = CommonFunction.transToMap_core(s);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String || value instanceof Number) {
                result.put(key, value.toString());
                continue;
            }
            result.put(key, gson.toJson((Object)value.toString()));
        }
        return result;
    }

    public static String linkToString(String[] array) {
        return CommonFunction.linkToString(Arrays.asList(array));
    }

    public static String linkToString(List<String> list) {
        list = list.stream().peek(s -> {
            s = s.replaceAll("_", "\\_");
        }).collect(Collectors.toList());
        return String.join((CharSequence)"_", list);
    }

    public static Map<String, Object> transToMap_core(String s) {
        try {
            String[] p = s.split("&");
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String w : p) {
                try {
                    String[] r = w.split("=");
                    map.put(r[0], URLDecoder.decode(r[1], StandardCharsets.UTF_8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return map;
        }
        catch (Exception exception) {
            return new HashMap<String, Object>();
        }
    }

    public static long getTimestamp() {
        Date date = new Date();
        return date.getTime();
    }

    public static String getRandomString(int length, long seed) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random(seed);
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            stringBuffer.append(str.charAt(number));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            stringBuffer.append(str.charAt(number));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String getRandomNumberString(int length) {
        Random random = new Random();
        StringBuilder stringBuffer = new StringBuilder();
        if (length < 1) {
            return "0";
        }
        stringBuffer.append(random.nextInt(9) + 1);
        for (int i = 1; i < length; ++i) {
            stringBuffer.append(random.nextInt(10));
        }
        return stringBuffer.toString();
    }

    public static Integer getNumberFromString(String number) {
        String numberString = Pattern.compile("[^(0-9)]").matcher(number).replaceAll("").trim();
        return Integer.parseInt(numberString);
    }

    public static Integer getNumberFromString(String number, int defaultValue) {
        try {
            return CommonFunction.getNumberFromString(number);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getTimestampFromString(String time, String pattern) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        Date data = format.parse(time);
        return data.getTime();
    }

    public static boolean available(String keyWord, Map<String, Object> map) {
        return map.containsKey(keyWord) && map.get(keyWord) != null && map.get(keyWord).toString().length() > 0;
    }

    public static enum BillType {
        Ticket,
        Product;


        public static BillType getTypeFromPayBatchId(String pay_batch_id) {
            return pay_batch_id.charAt(0) == 'P' ? Product : Ticket;
        }

        public static String getTableNameFromPayBatchId(String pay_batch_id) {
            return switch (BillType.getTypeFromPayBatchId(pay_batch_id)) {
                default -> throw new IncompatibleClassChangeError();
                case Product -> "mall.product_bill ";
                case Ticket -> "bill.session_bill ";
            };
        }
    }
}

