/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.codec.binary.Base64;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Base64Utils;

public class Crypto {
    private static final Logger log = LogManager.getLogger(Crypto.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";
    public static final String AES_DATA_SECURITY_KEY = "4%YkW!@g5LGcf9Ut";
    private static final String AES_PKCS5P = "AES/ECB/PKCS7Padding";
    private static final String AES_PERSON_KEY_SECURITY_KEY = "pisnyMyZYXuCNcRd";

    public static String MD5(String input) {
        return DigestUtils.md5Hex((byte[])input.getBytes());
    }

    public static String MD5_withSalt(String input, String salt) {
        return Crypto.MD5(input + "_" + salt);
    }

    public static String encrypt(String str, String key) throws Exception {
        if (str == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        key = Crypto.MD5(key).substring(0, 16);
        byte[] raw = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(str.getBytes(StandardCharsets.UTF_8));
        return Crypto.printHexString(encrypted);
    }

    public static String decrypt(String str, String key) throws Exception {
        if (str == null) {
            return null;
        }
        if (key == null) {
            throw new RuntimeException("key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] raw = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
        cipher.init(2, (Key)skeySpec, iv);
        byte[] encrypted = new Base64().decode(str);
        byte[] original = cipher.doFinal(encrypted);
        return new String(original, StandardCharsets.UTF_8);
    }

    public static String printHexString(byte[] b) {
        StringBuilder res = new StringBuilder();
        for (byte value : b) {
            Object hex = Integer.toHexString(value & 0xFF);
            if (((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            res.append((String)hex);
        }
        return res.toString();
    }

    public static String encryptAES(String text, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = text.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
            cipher.init(1, (Key)Crypto.getSecretKey(key), iv);
            byte[] result = cipher.doFinal(byteContent);
            return new String(Base64Utils.encode((byte[])result));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
    }

    public static String decryptAES(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
            cipher.init(2, (Key)Crypto.getSecretKey(key), iv);
            byte[] result = cipher.doFinal(Base64Utils.decode((byte[])content.getBytes()));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String key) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            kg.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static String encodeBase64(byte[] data, boolean urlSafe) {
        byte[] encodedByte = Base64.encodeBase64((byte[])data);
        String result = new String(encodedByte, StandardCharsets.UTF_8);
        if (urlSafe) {
            result = result.replaceAll("\\+", "-").replaceAll("/", "_").replaceAll("=", "");
        }
        return result;
    }

    public static String encodeBase64(String data, boolean urlSafe) {
        byte[] encodedByte = Base64.encodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8));
        String result = new String(encodedByte, StandardCharsets.UTF_8);
        if (urlSafe) {
            result = result.replaceAll("\\+", "-").replaceAll("/", "_").replaceAll("=", "");
        }
        return result;
    }

    public static String encodeBigBase64(String data) {
        byte[] encodedByte = Base64.encodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8), (boolean)true);
        return new String(encodedByte, StandardCharsets.UTF_8);
    }

    public static String decodeBase64(String data) {
        byte[] decodedByte = Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8));
        return new String(decodedByte, StandardCharsets.UTF_8);
    }

    public static byte[] encryptSM3(String key, String srcData) {
        KeyParameter keyParameter = new KeyParameter(key.getBytes());
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData.getBytes(), 0, srcData.length());
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static String sha1(String input) {
        return DigestUtils.sha1Hex((String)input);
    }

    public static byte[] SM3(byte[] srcData) {
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    public static String byteToHexString(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        return new String(ob);
    }

    public static String getSortedStrings(Map<String, String> paramMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(paramMap);
        return Crypto.getSortedString(map);
    }

    public static String getSortedString(Map<String, Object> paramMap) {
        TreeMap<String, Object> newMap = new TreeMap<String, Object>(paramMap);
        StringBuilder result = new StringBuilder();
        for (Map.Entry param : newMap.entrySet()) {
            result.append((String)param.getKey()).append("=").append(param.getValue().toString()).append("&");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public static String encryptMS4(String text, String key) throws Exception {
        byte[] result = Crypto.encrypt_Ecb_Padding(Base64.decodeBase64((byte[])key.getBytes()), text.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64((byte[])result), StandardCharsets.UTF_8);
    }

    public static String decryptMS4(String text, String key) throws Exception {
        byte[] result = Crypto.decrypt_Ecb_Padding(Base64.decodeBase64((byte[])key.getBytes()), Base64.decodeBase64((byte[])text.getBytes()));
        return new String(result, StandardCharsets.UTF_8);
    }

    static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Crypto.generateEcbCipher(1, key);
        return cipher.doFinal(data);
    }

    static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Crypto.generateEcbCipher(2, key);
        return cipher.doFinal(cipherText);
    }

    private static Cipher generateEcbCipher(int mode, byte[] key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("SM4/ECB/PKCS7Padding", "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, "SM4");
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static byte[] generateKey_MS4() throws NoSuchAlgorithmException, NoSuchProviderException {
        return Crypto.generateKey_MS4(128);
    }

    public static byte[] generateKey_MS4(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = KeyGenerator.getInstance("SM4", "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

