/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.google.gson.reflect.TypeToken;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.Nullable;
import top.lieder.Config;
import top.lieder.Environment;
import top.lieder.JSON;
import top.lieder.Redis;

public class PgSQL {
    private static final Logger log = LogManager.getLogger(PgSQL.class);
    static JSON json = new JSON();
    static Connection conn;
    static boolean testMode;
    static String className;
    static String urlOuter;
    static String urlInner;
    static String user;
    static String password;
    static int cacheTime_s;

    public PgSQL() {
        cacheTime_s = Integer.parseInt(Objects.requireNonNull(Config.getConfig("pgSQL.cacheTime_s")));
        this.connect();
    }

    void connect() {
        try {
            Class.forName(className);
            if (Environment.getInnerMode()) {
                try {
                    conn = DriverManager.getConnection(urlInner, user, password);
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            conn = DriverManager.getConnection(urlOuter, user, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void reconnect() {
        try {
            if (!conn.isClosed()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.connect();
    }

    void insertParamSafety(PreparedStatement preparedStatement, @Nullable Object[] list) {
        if (list == null) {
            return;
        }
        try {
            for (int i = 0; i < list.length; ++i) {
                Object param = list[i];
                int index = i + 1;
                if (param == null) {
                    preparedStatement.setNull(index, 0);
                    continue;
                }
                String paramString = param.toString();
                if (String.class.equals(param.getClass())) {
                    preparedStatement.setString(index, paramString);
                    continue;
                }
                if (Integer.class.equals(param.getClass())) {
                    preparedStatement.setInt(index, Integer.parseInt(paramString));
                    continue;
                }
                if (Long.class.equals(param.getClass())) {
                    preparedStatement.setLong(index, Long.parseLong(paramString));
                    continue;
                }
                if (Double.class.equals(param.getClass())) {
                    preparedStatement.setDouble(index, Double.parseDouble(paramString));
                    continue;
                }
                if (Boolean.class.equals(param.getClass())) {
                    preparedStatement.setBoolean(index, Boolean.parseBoolean(paramString));
                    continue;
                }
                if (param instanceof Enum) {
                    preparedStatement.setString(index, ((Enum)param).name());
                    continue;
                }
                preparedStatement.setObject(index, param);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void insertParamSafetyBatch(PreparedStatement preparedStatement, @Nullable List<Object[]> list) {
        if (list == null) {
            return;
        }
        try {
            for (Object[] paramArray : list) {
                this.insertParamSafety(preparedStatement, paramArray);
                preparedStatement.addBatch();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    <T extends Map<String, Object>> void transDatasetToList(List<T> result, ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                rowData.put(metaData.getColumnName(i), resultSet.getObject(i));
            }
            result.add(rowData);
        }
    }

    public <T extends Map<String, Object>> List<T> select(String sql, Object[] paramList, boolean withCache) {
        return this.select(sql, paramList, withCache, 1, sql + json.toJson(paramList));
    }

    public <T extends Map<String, Object>> List<T> selectActivitySeat(String sql, Object[] paramList, boolean withCache, String keyWord) {
        return this.select(sql, paramList, withCache, 6, keyWord);
    }

    public <T extends Map<String, Object>> List<T> select(String sql, Object[] paramList, boolean withCache, int type, String keyWord) {
        List result;
        Redis sqlRedis = new Redis(type, true);
        try {
            if (withCache && sqlRedis.containKey(keyWord) && (result = (List)json.fromJson(sqlRedis.get(keyWord), new TypeToken<Object>(){}.getType())) != null) {
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = new ArrayList();
        this.reconnect();
        try (PreparedStatement stat = conn.prepareStatement(sql);){
            this.insertParamSafety(stat, paramList);
            ResultSet rs = stat.executeQuery();
            this.transDatasetToList(result, rs);
            if (withCache) {
                new Thread(() -> {
                    sqlRedis.setAsync(keyWord, result, cacheTime_s);
                    sqlRedis.close();
                }).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public <T extends Map<String, Object>> List<T> selectUnsafe(String sql, boolean withCache) {
        Redis redis = new Redis(1, true);
        try {
            if (withCache && redis.containKey(sql)) {
                return (List)json.fromJson(redis.get(sql), new TypeToken<Object>(){}.getType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList result = new ArrayList();
        this.reconnect();
        try (Statement stat = conn.createStatement();){
            ResultSet rs = stat.executeQuery(sql);
            this.transDatasetToList(result, rs);
            if (withCache) {
                redis.setAsync(sql, result, cacheTime_s);
            }
        }
        catch (Exception e) {
            log.error("sql selectUnsafe", (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public static void updateCache(String tableName, boolean hardAsyncCache, int type) {
        PgSQL.updateCache(tableName, hardAsyncCache, new Redis(type, true));
    }

    public static void updateCache(String tableName, boolean hardAsyncCache, Redis redis) {
        if (hardAsyncCache) {
            redis.cleanAllData();
            return;
        }
        new Thread(() -> {
            Set<String> keys = redis.getAllKeys();
            for (String key : keys) {
                if (!key.contains(tableName)) continue;
                redis.remove(key);
            }
        }).start();
    }

    public int update(String sql, Object[] paramList, String tableName, boolean refreshAllCache) {
        return this.update(sql, paramList, tableName, refreshAllCache, 1);
    }

    public int update(String sql, Object[] paramList, String tableName) {
        return this.update(sql, paramList, tableName, false, 1);
    }

    public int updateActivitySeat(String sql, Object[] paramList, String tableName, boolean refreshAllCache) {
        return this.update(sql, paramList, tableName, refreshAllCache, 6);
    }

    public int update(String sql, Object[] paramList, String tableName, boolean refreshAllCache, int type) {
        int result = -1;
        this.reconnect();
        String paramString = json.toJson(paramList);
        log.info(sql + (String)(paramString.length() > 1000 ? paramString.substring(0, 1000) + "..." : paramString));
        try (PreparedStatement pStmt = conn.prepareStatement(sql);){
            this.insertParamSafety(pStmt, paramList);
            result = pStmt.executeUpdate();
            PgSQL.updateCache(tableName, refreshAllCache, type);
        }
        catch (Exception e) {
            log.warn((Object)e);
            e.printStackTrace();
        }
        return result;
    }

    public int[] updateBatch(String sql, List<Object[]> paramList, String tableName, boolean hardAsyncCache) {
        return this.updateBatch(sql, paramList, tableName, hardAsyncCache, 1);
    }

    public int[] updateBatch(String sql, List<Object[]> paramList, String tableName, boolean hardAsyncCache, int type) {
        int[] result = null;
        this.reconnect();
        log.info(sql);
        try (PreparedStatement pStmt = conn.prepareStatement(sql);){
            this.insertParamSafetyBatch(pStmt, paramList);
            result = pStmt.executeBatch();
            PgSQL.updateCache(tableName, hardAsyncCache, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public <T extends Map<String, Object>> List<T> updateGet(String sql, Object[] paramList, String tableName, boolean hardAsyncCache) {
        return this.updateGet(sql, paramList, tableName, hardAsyncCache, 1);
    }

    public <T extends Map<String, Object>> List<T> updateGet(String sql, Object[] paramList, String tableName, boolean hardAsyncCache, int type) {
        ArrayList result = new ArrayList();
        this.reconnect();
        try (PreparedStatement stat = conn.prepareStatement(sql);){
            this.insertParamSafety(stat, paramList);
            ResultSet rs = stat.executeQuery();
            this.transDatasetToList(result, rs);
            PgSQL.updateCache(tableName, hardAsyncCache, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public <T extends Map<String, Object>> List<T> updateGetBatch(String sql, List<Object[]> paramList, String tableName, boolean hardAsyncCache) {
        return this.updateGetBatch(sql, paramList, tableName, hardAsyncCache, 1);
    }

    public <T extends Map<String, Object>> List<T> updateGetBatch(String sql, List<Object[]> paramList, String tableName, boolean hardAsyncCache, int type) {
        ArrayList result = new ArrayList();
        this.reconnect();
        log.info(sql);
        try (PreparedStatement stat = conn.prepareStatement(sql);){
            this.insertParamSafetyBatch(stat, paramList);
            ResultSet rs = stat.executeQuery();
            this.transDatasetToList(result, rs);
            PgSQL.updateCache(tableName, hardAsyncCache, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        testMode = Environment.getTestMode();
        className = Config.getConfig("pgSQL.className");
        urlOuter = Config.getConfig(testMode ? "pgSQL.url.test.outer" : "pgSQL.url.formal.outer");
        urlInner = Config.getConfig(testMode ? "pgSQL.url.test.inner" : "pgSQL.url.formal.inner");
        user = Config.getConfig("pgSQL.user");
        password = Config.getConfig("pgSQL.password");
        cacheTime_s = 3600;
    }
}

