/*
 * Decompiled with CFR 0.152.
 */
package top.lieder.modelBase;

import java.util.List;

public class SqlOperateClass {

    public static class OrderCell {
        public String columnName;
        public boolean desc;

        public OrderCell(String columnName) {
            this.columnName = columnName;
            this.desc = true;
        }

        public OrderCell(String columnName, boolean desc) {
            this.columnName = columnName;
            this.desc = desc;
        }
    }

    public static class SearchResult<T> {
        public int count;
        public List<T> list;

        public SearchResult(int count, List<T> list) {
            this.count = count;
            this.list = list;
        }
    }

    public static class ConditionCell {
        public String keyName;
        public EqualType type = EqualType.Equal;
        public Object value;

        public String getEqualTypeString() {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case EqualType.Equal -> "=";
                case EqualType.Less -> "<";
                case EqualType.Greater -> ">";
                case EqualType.NotEqual -> "!=";
                case EqualType.LessEqual -> "<=";
                case EqualType.GreaterEqual -> ">=";
            };
        }

        public ConditionCell(String name, Object value) {
            this.keyName = name;
            this.value = value;
        }

        public ConditionCell(String keyName, EqualType type, Object value) {
            this.keyName = keyName;
            this.type = type;
            this.value = value;
        }
    }

    public static enum EqualType {
        Equal,
        GreaterEqual,
        LessEqual,
        Greater,
        Less,
        NotEqual;

    }

    public static enum UpdateRangeType {
        Only_Id,
        Only_IdOwner,
        Include_id,
        Include_IdOwner,
        Another;

    }
}

