/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.CommonFunction;

public class InnerCache {
    private static final Logger log = LogManager.getLogger(InnerCache.class);
    public static Map<Integer, Map<String, CacheCore>> mainCache = new HashMap<Integer, Map<String, CacheCore>>();
    private static final OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    InnerCache() {
        InnerCache.setValue(0, "test", "122", 12222L);
        String t = InnerCache.getValue(0, "test");
        log.info(t);
    }

    static CacheCore getCore(int dbIndex, String key) {
        if (!mainCache.containsKey(dbIndex) || mainCache.get(dbIndex) == null) {
            return null;
        }
        CacheCore core = mainCache.get(dbIndex).get(key);
        if (core.expiredTime >= 0L && core.expiredTime < CommonFunction.getTimestamp()) {
            mainCache.get(dbIndex).remove(key);
            return null;
        }
        return core;
    }

    public static String getValue(int dbIndex, String key) {
        CacheCore core = InnerCache.getCore(dbIndex, key);
        if (core == null) {
            return null;
        }
        return core.value;
    }

    public static int getFreeMemoryRatio() {
        double totalMemorySize = operatingSystemMXBean.getTotalMemorySize();
        double freeMemorySize = operatingSystemMXBean.getFreeMemorySize();
        double value = freeMemorySize / totalMemorySize;
        return (int)((1.0 - value) * 100.0);
    }

    static void autoFreeMemory() {
        Thread thread = new Thread(() -> {
            if (InnerCache.getFreeMemoryRatio() > 90) {
                InnerCache.cleanAllExpiredData();
            }
        });
        thread.start();
    }

    static void cleanAllExpiredData() {
        long timestamp = CommonFunction.getTimestamp();
        mainCache.replaceAll((k, v) -> v.entrySet().parallelStream().filter(s -> ((CacheCore)s.getValue()).expiredTime > 0L && ((CacheCore)s.getValue()).expiredTime < timestamp).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    static void setValueCore(int dbIndex, String key, String value, long time_ms) {
        if (!mainCache.containsKey(dbIndex) || mainCache.get(dbIndex) == null) {
            mainCache.put(dbIndex, new HashMap());
        }
        CacheCore core = CacheCore.builder().value(value).expiredTime(time_ms < 0L ? -1L : CommonFunction.getTimestamp() + time_ms).build();
        mainCache.get(dbIndex).put(key, core);
        InnerCache.autoFreeMemory();
    }

    public static void setValue(int dbIndex, String key, String value, long time_s) {
        InnerCache.setValueCore(dbIndex, key, value, time_s < 0L ? -1L : time_s * 1000L);
    }

    public static void setValue(int dbIndex, String key, String value) {
        InnerCache.setValue(dbIndex, key, value, -1L);
    }

    public static boolean setTime(int dbIndex, String key, long time_s) {
        if (!mainCache.containsKey(dbIndex) || mainCache.get(dbIndex) == null) {
            return false;
        }
        CacheCore core = InnerCache.getCore(dbIndex, key);
        if (core == null) {
            return false;
        }
        core.expiredTime = time_s < 0L ? -1L : CommonFunction.getTimestamp() + time_s * 1000L;
        mainCache.get(dbIndex).put(key, core);
        return true;
    }

    static class CacheCore {
        public long expiredTime;
        public String value;

        CacheCore(long expiredTime, String value) {
            this.expiredTime = expiredTime;
            this.value = value;
        }

        public static CacheCoreBuilder builder() {
            return new CacheCoreBuilder();
        }

        public static class CacheCoreBuilder {
            private long expiredTime;
            private String value;

            CacheCoreBuilder() {
            }

            public CacheCoreBuilder expiredTime(long expiredTime) {
                this.expiredTime = expiredTime;
                return this;
            }

            public CacheCoreBuilder value(String value) {
                this.value = value;
                return this;
            }

            public CacheCore build() {
                return new CacheCore(this.expiredTime, this.value);
            }

            public String toString() {
                return "InnerCache.CacheCore.CacheCoreBuilder(expiredTime=" + this.expiredTime + ", value=" + this.value + ")";
            }
        }
    }
}

