/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.Config;
import top.lieder.JSON;

public class Environment {
    private static final Logger log = LogManager.getLogger(Environment.class);
    static Boolean testMode = null;
    static Boolean k8sMode = null;
    static Boolean innerMode = null;
    static JSON json = new JSON();

    public static Map<String, Boolean> getEnvironment() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("testMode", Environment.getTestMode());
        result.put("k8sMode", Environment.getK8sMode());
        result.put("innerMode", Environment.getInnerMode());
        return result;
    }

    static Map<String, Boolean> getMode() throws Exception {
        FileInputStream fileInputStream = new FileInputStream("/cert/env.config");
        String env = new String(fileInputStream.readAllBytes());
        Map result = (Map)json.fromJson(env);
        log.warn((Object)result);
        return result;
    }

    public static boolean getTestMode() {
        if (testMode == null) {
            try {
                testMode = Environment.getMode().getOrDefault("testMode", Boolean.parseBoolean(Config.getConfig("test.mode", "false")));
            }
            catch (Exception ignored) {
                testMode = Boolean.parseBoolean(Config.getConfig("test.mode", "false"));
            }
            finally {
                if (testMode == null) {
                    testMode = false;
                }
            }
        }
        return testMode;
    }

    public static boolean getK8sMode() {
        if (k8sMode == null) {
            try {
                k8sMode = Environment.getMode().getOrDefault("k8sMode", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (k8sMode == null) {
                    k8sMode = false;
                }
            }
        }
        return k8sMode;
    }

    public static boolean getInnerMode() {
        if (innerMode == null) {
            try {
                innerMode = Environment.getMode().getOrDefault("innerMode", false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (innerMode == null) {
                    innerMode = false;
                }
            }
        }
        return innerMode;
    }
}

