/*
 * Decompiled with CFR 0.152.
 */
package top.lieder;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.CommonFunction;
import top.lieder.Config;

public class RocketMqSender {
    private static final Logger log = LogManager.getLogger(RocketMqSender.class);
    Properties properties = new Properties();
    Producer producer;

    public RocketMqSender() {
        Config.fillConfig("rocketMq.properties", this.properties);
        this.producer = ONSFactory.createProducer((Properties)this.properties);
        this.producer.start();
    }

    public RocketMqSender(String groupId) {
        Config.fillConfig("rocketMq.properties", this.properties);
        if (groupId != null) {
            this.properties.setProperty("GROUP_ID", groupId);
        }
        this.producer = ONSFactory.createProducer((Properties)this.properties);
        this.producer.start();
    }

    public SendResult sendMessage(String topic, String tags, String key, String message) {
        Message msg = new Message(topic, tags, message.getBytes());
        if (key != null) {
            msg.setKey(key);
        }
        return this.producer.send(msg);
    }

    public SendResult sendDelayMessage_core(String topic, String tags, String key, String message, long time) {
        long delayTime = CommonFunction.getTimestamp() + time * 1000L;
        Message msg = new Message(topic, tags, message.getBytes());
        msg.setStartDeliverTime(delayTime);
        if (key != null) {
            msg.setKey(key);
        }
        return this.producer.send(msg);
    }

    public SendResult sendDelayMessage(String topic, String tags, String key, String message, long delay_s) {
        long delayTime = CommonFunction.getTimestamp() + delay_s * 1000L;
        return this.sendDelayMessage_core(topic, tags, key, message, delayTime);
    }

    public void multiThreadSendMessage(String topic, String tag, String message, String key, Map<String, Object> result) {
        Thread thread = new Thread(() -> {
            SendResult sendResult;
            Message msg = new Message(topic, tag, message.getBytes());
            if (key != null) {
                msg.setKey(key);
            }
            if ((sendResult = this.producer.send(msg)) != null) {
                result.put("false", sendResult);
            }
        });
        thread.setUncaughtExceptionHandler((t, e) -> result.put("false", e.getMessage()));
        thread.start();
        result.put("true", "");
    }

    public void asyncSendMessage(String topic, String tag, String message, String key, SendCallback sendCallback) {
        Message msg = new Message(topic, tag, message.getBytes());
        if (key != null) {
            msg.setKey(key);
        }
        this.producer.sendAsync(msg, sendCallback);
    }

    public void asyncSendMessage(String topic, String tag, String message, String key) {
        this.asyncSendMessage(topic, tag, message, key, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                log.info("send message success. topic=" + sendResult.getTopic() + ", msgId=" + sendResult.getMessageId());
            }

            public void onException(OnExceptionContext context) {
                log.info("send message failed. topic=" + context.getTopic() + ", msgId=" + context.getMessageId());
            }
        });
    }

    public List<SendResult> SendMessageOrder(String topic, List<MessageDetail> messageList) {
        OrderProducer producer = ONSFactory.createOrderProducer((Properties)this.properties);
        producer.start();
        ArrayList<SendResult> sendResultList = new ArrayList<SendResult>();
        for (int i = 0; i < messageList.size(); ++i) {
            MessageDetail messageDetail = messageList.get(i);
            Message msg = new Message(topic, messageDetail.tag, messageDetail.body.getBytes());
            if (messageDetail.key != null) {
                msg.setKey(messageDetail.key);
            } else {
                msg.setKey("index_" + i);
            }
            if (messageDetail.shardingKey == null) {
                messageDetail.shardingKey = "shardingKey";
            }
            sendResultList.add(producer.send(msg, messageDetail.shardingKey));
        }
        producer.shutdown();
        return sendResultList;
    }

    static class MessageDetail {
        public String tag;
        public String shardingKey;
        public String key;
        public String body;
        public int groupId;

        MessageDetail() {
        }
    }
}

