/*
 * Decompiled with CFR 0.152.
 */
package top.lieder.mongoBase;

import com.mongodb.BasicDBObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.lieder.CommonGet;
import top.lieder.JSON;
import top.lieder.MongoDB;
import top.lieder.modelBase.SqlOperateClass;

public class MongoBase {
    private static final Logger log = LogManager.getLogger(MongoBase.class);
    String databaseName;
    String collectionName;
    JSON json = new JSON();

    public MongoBase(String databaseName, String collectionName) {
        this.databaseName = databaseName;
        this.collectionName = collectionName;
    }

    public List<Map<String, Object>> search(Map<CommonGet.SearchType, Map<String, Object>> searchMap, List<SqlOperateClass.OrderCell> orderList, boolean withCache) throws Exception {
        Field[] fields = this.getClass().getDeclaredFields();
        Map<String, Field> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getName, s -> s));
        Set<String> columnNames = fieldMap.keySet();
        HashSet<MongoDB.FilterCell> filterCellSet = new HashSet<MongoDB.FilterCell>();
        if (searchMap != null) {
            block4: for (Map.Entry<CommonGet.SearchType, Map<String, Object>> search : searchMap.entrySet()) {
                Map<String, Object> searchElement = search.getValue();
                CommonGet.SearchType searchType = search.getKey();
                switch (searchType) {
                    case Accurate: 
                    case Vague: {
                        for (String colName : searchElement.keySet()) {
                            if (!columnNames.contains(colName)) {
                                throw new Exception("\u4e0d\u5305\u542bcolumnName:" + colName);
                            }
                            filterCellSet.add(new MongoDB.FilterCell(colName, searchElement.get(colName), searchType == CommonGet.SearchType.Accurate));
                        }
                        continue block4;
                    }
                    case Range: {
                        for (String colName : searchElement.keySet()) {
                            if (!columnNames.contains(colName)) {
                                throw new Exception("\u4e0d\u5305\u542bcolumnName:" + colName);
                            }
                            if (fieldMap.get(colName).getType() != Number.class) {
                                throw new Exception("key:" + colName + " \u5728Range\u7c7b\u578b\u4e2d\u4e0d\u4e3aNumber\u683c\u5f0f");
                            }
                            Map rangeMap = (Map)this.json.trans(searchElement.get(colName));
                            if (rangeMap == null) continue;
                            if (rangeMap.containsKey("start")) {
                                filterCellSet.add(new MongoDB.FilterCell(colName, new BasicDBObject("$gte", rangeMap.get("start")), true));
                            }
                            if (!rangeMap.containsKey("end")) continue;
                            filterCellSet.add(new MongoDB.FilterCell(colName, new BasicDBObject("$lte", rangeMap.get("start")), true));
                        }
                        continue block4;
                    }
                }
            }
        }
        List<MongoDB.SorterCell> sorterList = orderList != null && orderList.size() > 0 ? orderList.stream().map(s -> new MongoDB.SorterCell(s.columnName, !s.desc)).toList() : null;
        MongoDB mongoDB = new MongoDB(this.databaseName, this.collectionName);
        return mongoDB.getValue(filterCellSet, sorterList, withCache);
    }
}

