/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalmybatisextend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalmybatisextend.FinalExtendConfig;
import top.lingkang.finalmybatisextend.base.ParamObject;
import top.lingkang.finalmybatisextend.entity.SqlResult;
import top.lingkang.finalmybatisextend.log.NoLoggerImpl;

abstract class AbstractBaseExtend {
    protected static Logger log;
    protected List<Configuration> configuration = new ArrayList<Configuration>();
    protected FinalExtendConfig extendConfig;
    private static final Configuration sqlConfiguration;

    public AbstractBaseExtend(FinalExtendConfig extendConfig) {
        this.extendConfig = extendConfig;
        log = extendConfig.isShowSql() ? LoggerFactory.getLogger(this.getClass()) : new NoLoggerImpl();
        if (extendConfig.getXml() == null || extendConfig.getXml().length == 0) {
            log.warn("\u672a\u914d\u7f6emapper.xml");
        } else {
            for (InputStream xml : extendConfig.getXml()) {
                Configuration config = new Configuration();
                new XMLMapperBuilder(xml, config, null, null).parse();
                this.configuration.add(config);
                try {
                    xml.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public FinalExtendConfig getExtendConfig() {
        return this.extendConfig;
    }

    private List<Object> getParam(BoundSql boundSql, MappedStatement mappedStatement, Configuration configuration, ParamObject paramObject) {
        ArrayList<Object> params = new ArrayList<Object>();
        List parameterMappings = boundSql.getParameterMappings();
        TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        for (ParameterMapping parameterMapping : parameterMappings) {
            Object value;
            if (parameterMapping.getMode() == ParameterMode.OUT) continue;
            String propertyName = parameterMapping.getProperty();
            if (boundSql.hasAdditionalParameter(propertyName)) {
                value = boundSql.getAdditionalParameter(propertyName);
            } else if (paramObject == null) {
                value = null;
            } else if (typeHandlerRegistry.hasTypeHandler(paramObject.getClass())) {
                value = paramObject;
            } else {
                MetaObject metaObject = configuration.newMetaObject((Object)paramObject);
                value = metaObject.getValue(propertyName);
            }
            params.add(value);
        }
        if ((paramObject == null || paramObject.isEmpty()) && !params.isEmpty()) {
            throw new IllegalArgumentException("\u89e3\u6790xml\u5165\u53c2\u4e0d\u5339\u914d\uff0cxml\u9700\u8981\u7684\u53c2\u6570\u53d8\u91cf\u6570\uff1a" + params.size() + "   \u5165\u53c2\uff1a" + paramObject);
        }
        return params;
    }

    public SqlResult get(String id) {
        return this.get(id, null);
    }

    public SqlResult get(String id, ParamObject paramObject) {
        SqlResult sqlResult = new SqlResult();
        Configuration config = this.getConfiguration(id);
        MappedStatement mappedStatement = config.getMappedStatement(id);
        BoundSql boundSql = mappedStatement.getBoundSql((Object)paramObject);
        sqlResult.setSql(boundSql.getSql());
        sqlResult.setParams(this.getParam(boundSql, mappedStatement, config, paramObject));
        if (this.extendConfig.isShowSql()) {
            log.info("\n\nsql:\n{}\nparam:\n{}\n", (Object)sqlResult.getSql(), sqlResult.getParams());
        }
        return sqlResult;
    }

    public Configuration getConfiguration(String id) {
        for (Configuration config : this.configuration) {
            if (!config.hasStatement(id, false)) continue;
            return config;
        }
        throw new IllegalArgumentException("xml\u4e2d\u672a\u627e\u5230\u6620\u5c04id\uff1a" + id);
    }

    public SqlResult sqlToSqlResult(String mybatisSql, ParamObject paramObject) {
        SqlSource sqlSource = new SqlSourceBuilder(sqlConfiguration).parse(mybatisSql, HashMap.class, null);
        BoundSql boundSql = sqlSource.getBoundSql((Object)paramObject);
        return new SqlResult(boundSql.getSql(), this.getSqlParam(boundSql, paramObject));
    }

    private List<Object> getSqlParam(BoundSql boundSql, ParamObject paramObject) {
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings.size() < paramObject.size()) {
            throw new IllegalArgumentException("sql\u9700\u8981\u53c2\u6570\u4e2a\u6570\u4e0e\u5165\u53c2\u4e2a\u6570\u4e0d\u4e00\u81f4: \u9700\u8981\u4e2a\u6570\uff1a" + parameterMappings.size() + " \u5165\u53c2\u4e2a\u6570\uff1a" + paramObject.size());
        }
        ArrayList<Object> list = new ArrayList<Object>(parameterMappings.size());
        for (ParameterMapping parameterMapping : parameterMappings) {
            String property = parameterMapping.getProperty();
            list.add(paramObject.get(property));
        }
        return list;
    }

    static {
        sqlConfiguration = new Configuration();
    }
}

