/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalsecurity.common.base.FinalExceptionHandler;
import top.lingkang.finalsecurity.common.utils.StringUtils;

public class DefaultFinalExceptionHandler
implements FinalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultFinalExceptionHandler.class);

    public void permissionException(Throwable e, Object request, Object response) {
        this.printError(e, (HttpServletRequest)request, (HttpServletResponse)response, 403);
    }

    public void notLoginException(Throwable e, Object request, Object response) {
        this.printError(e, (HttpServletRequest)request, (HttpServletResponse)response, 400);
    }

    public void exception(Throwable e, Object request, Object response) {
        e.printStackTrace();
        try {
            ((HttpServletResponse)response).getWriter().println(e.getMessage());
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private void printError(Throwable e, HttpServletRequest request, HttpServletResponse response, int code) {
        log.warn(e.getMessage() + "  url=" + request.getServletPath());
        String contentType = request.getContentType();
        if (StringUtils.isEmpty((Object)contentType)) {
            contentType = "text/html; charset=UTF-8";
        }
        response.setContentType(contentType);
        response.setStatus(200);
        try {
            if (contentType.toLowerCase().indexOf("html") == -1) {
                response.getWriter().print("{\"code\":" + code + ",\"msg\":\"" + e.getMessage() + "\"}");
            } else {
                response.getWriter().print(e.getMessage());
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

