/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.config;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import top.lingkang.finalsecurity.common.base.FinalAuth;
import top.lingkang.finalsecurity.common.base.FinalExceptionHandler;
import top.lingkang.finalsecurity.common.base.FinalHttpProperties;
import top.lingkang.finalsecurity.common.base.FinalSessionObject;
import top.lingkang.finalsecurity.common.error.FinalBaseException;
import top.lingkang.finalsecurity.common.error.FinalNotLoginException;
import top.lingkang.finalsecurity.common.error.FinalPermissionException;
import top.lingkang.finalsecurity.common.utils.AuthUtils;
import top.lingkang.finalsecurity.config.DefaultFinalExceptionHandler;
import top.lingkang.finalsecurity.config.FinalSessionObjectServlet;
import top.lingkang.finalsecurity.http.FinalRequestContext;

public class FinalSecurityConfiguration
implements Filter {
    private FinalHttpProperties properties = new FinalHttpProperties();
    private FinalSessionObject sessionObject = new FinalSessionObjectServlet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        block25: {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            FinalRequestContext.setRequest(request);
            try {
                String path = request.getServletPath();
                if (this.properties.getCheckPathCache().getExcludePath().contains(path)) {
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                if (this.properties.getCheckPathCache().getAuths().containsKey(path)) {
                    FinalAuth[] finalAuths;
                    this.sessionObject.init((Object)request.getSession());
                    for (FinalAuth auth : finalAuths = (FinalAuth[])this.properties.getCheckPathCache().getAuths().get(path)) {
                        auth.check(this.sessionObject);
                    }
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                for (String url : this.properties.getExcludePath()) {
                    if (!AuthUtils.matcher((String)url, (String)path)) continue;
                    this.properties.getCheckPathCache().getExcludePath().add(path);
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                HashMap checkAuth = this.properties.getCheckAuthorize().getAuthorize();
                ArrayList<FinalAuth> auths = new ArrayList<FinalAuth>();
                for (Map.Entry entry : checkAuth.entrySet()) {
                    if (!AuthUtils.matcher((String)((String)entry.getKey()), (String)path)) continue;
                    auths.add((FinalAuth)entry.getValue());
                }
                this.properties.getCheckPathCache().getAuths().put(path, AuthUtils.AllToOne((FinalAuth[])auths.toArray(new FinalAuth[auths.size()])));
                if (auths.isEmpty()) {
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                this.sessionObject.init((Object)request.getSession());
                for (FinalAuth auth : auths) {
                    auth.check(this.sessionObject);
                }
                chain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                if (FinalBaseException.class.isAssignableFrom(e.getClass()) || FinalBaseException.class.isAssignableFrom(e.getCause().getClass())) {
                    if (e instanceof FinalPermissionException) {
                        this.properties.getExceptionHandler().permissionException((Throwable)e, (Object)request, (Object)((HttpServletResponse)servletResponse));
                    } else if (e.getCause() instanceof FinalPermissionException) {
                        this.properties.getExceptionHandler().permissionException(e.getCause(), (Object)request, (Object)((HttpServletResponse)servletResponse));
                    } else if (e instanceof FinalNotLoginException) {
                        this.properties.getExceptionHandler().notLoginException((Throwable)e, (Object)request, (Object)((HttpServletResponse)servletResponse));
                    } else if (e.getCause() instanceof FinalNotLoginException) {
                        this.properties.getExceptionHandler().notLoginException(e.getCause(), (Object)request, (Object)((HttpServletResponse)servletResponse));
                    } else {
                        this.properties.getExceptionHandler().exception((Throwable)e, (Object)request, (Object)((HttpServletResponse)servletResponse));
                    }
                    break block25;
                }
                throw e;
            }
            finally {
                FinalRequestContext.removeRequest();
            }
        }
    }

    protected void config(FinalHttpProperties properties) {
        this.properties = properties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.properties.getExceptionHandler() == null) {
            this.properties.setExceptionHandler((FinalExceptionHandler)new DefaultFinalExceptionHandler());
        }
        this.config(this.properties);
    }

    public FinalHttpProperties getProperties() {
        return this.properties;
    }
}

