/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.jakarta.http;

import jakarta.servlet.http.HttpSession;
import org.springframework.context.annotation.Configuration;
import top.lingkang.finalsecurity.common.base.FinalHolder;
import top.lingkang.finalsecurity.jakarta.http.FinalRequestContext;

@Configuration
public class FinalSecurityHolder
extends FinalHolder {
    public void login(String username, String[] role) {
        HttpSession session = FinalRequestContext.getRequest().getSession();
        session.setAttribute("final_loginUsername", (Object)username);
        session.setAttribute("final_hasRoles", (Object)role);
        session.setAttribute("final_isLogin", (Object)true);
    }

    public void logout() {
        HttpSession session = FinalRequestContext.getRequest().getSession();
        session.removeAttribute("final_isLogin");
        session.removeAttribute("final_hasRoles");
        session.removeAttribute("final_loginUsername");
    }

    public String[] getRole() {
        Object finalRole = FinalRequestContext.getRequest().getSession().getAttribute("final_hasRoles");
        if (finalRole != null) {
            return (String[])finalRole;
        }
        return null;
    }

    public String getUsername() {
        Object username = FinalRequestContext.getRequest().getSession().getAttribute("final_loginUsername");
        if (username != null) {
            return (String)username;
        }
        return null;
    }

    public boolean isLogin() {
        Object login = FinalRequestContext.getRequest().getSession().getAttribute("final_isLogin");
        if (login != null) {
            return (Boolean)login;
        }
        return false;
    }
}

