/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.jakarta.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static final Log log = LogFactory.getLog(BeanUtils.class);

    public static void copyProperty(Object source, Object target, boolean ignoreNullValue) {
        for (Field s : source.getClass().getDeclaredFields()) {
            if (BeanUtils.getField(target, s.getName()) == null) continue;
            try {
                Object value = BeanUtils.getProperty(source, s.getName());
                if (value == null && ignoreNullValue) continue;
                BeanUtils.setProperty(target, s.getName(), value);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static Field getField(Object o, String name) {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static void setProperty(Object o, String name, Object value) throws Exception {
        PropertyDescriptor propDesc = new PropertyDescriptor(name, o.getClass());
        Method methodSetUserName = propDesc.getWriteMethod();
        methodSetUserName.invoke(o, value);
    }

    public static Object getProperty(Object o, String name) throws Exception {
        PropertyDescriptor proDescriptor = new PropertyDescriptor(name, o.getClass());
        Method methodGetUserName = proDescriptor.getReadMethod();
        return methodGetUserName.invoke(o, new Object[0]);
    }
}

