/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.annotation.impl;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import top.lingkang.annotation.FinalCheck;
import top.lingkang.error.FinalNotLoginException;
import top.lingkang.http.FinalSecurityHolder;
import top.lingkang.utils.AuthUtils;

@Aspect
public class FinalCheckAnnotation {
    @Autowired(required=false)
    private FinalSecurityHolder securityHolder;

    @Around(value="@within(top.lingkang.annotation.FinalCheck) || @annotation(top.lingkang.annotation.FinalCheck)")
    public Object method(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature;
        FinalCheck method;
        if (!this.securityHolder.isLogin()) {
            throw new FinalNotLoginException("400 Not Login, \u60a8\u8fd8\u672a\u767b\u5f55\uff01");
        }
        FinalCheck clazz = joinPoint.getTarget().getClass().getAnnotation(FinalCheck.class);
        if (clazz != null) {
            this.check(clazz);
        }
        if ((method = (signature = (MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(FinalCheck.class)) != null) {
            this.check(method);
        }
        return joinPoint.proceed();
    }

    private void check(FinalCheck check) {
        if (check.anyRole().length != 0) {
            AuthUtils.checkRole(check.anyRole(), this.securityHolder.getRole());
        }
        if (check.andRole().length != 0) {
            AuthUtils.checkAndRole(check.andRole(), this.securityHolder.getRole());
        }
    }
}

