/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.annotation.Bean;
import top.lingkang.base.FinalAuth;
import top.lingkang.base.FinalHttpProperties;
import top.lingkang.error.FinalNotLoginException;
import top.lingkang.error.FinalPermissionException;
import top.lingkang.http.FinalRequestContext;
import top.lingkang.utils.AuthUtils;

public class FinalSecurityConfiguration
implements Filter {
    private FinalHttpProperties properties = new FinalHttpProperties();
    private HashSet<String> cacheExcludePath = new HashSet();
    private HashMap<String, FinalAuth[]> cacheAuths = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        FinalRequestContext.setRequest(request);
        try {
            String path = request.getServletPath();
            if (this.cacheExcludePath.contains(path)) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (this.cacheAuths.containsKey(path)) {
                FinalAuth[] finalAuths;
                HttpSession session = request.getSession();
                if (session.getAttribute("final_isLogin") == null) {
                    throw new FinalNotLoginException("400 Not Login, \u60a8\u8fd8\u672a\u767b\u5f55\uff01");
                }
                for (FinalAuth auth : finalAuths = this.cacheAuths.get(path)) {
                    auth.check(session);
                }
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            for (String url : this.properties.getExcludePath()) {
                if (!AuthUtils.matcher(url, path)) continue;
                this.cacheExcludePath.add(path);
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpSession session = request.getSession();
            if (session.getAttribute("final_isLogin") == null) {
                throw new FinalNotLoginException("400 Not Login, \u60a8\u8fd8\u672a\u767b\u5f55\uff01");
            }
            HashMap<String, FinalAuth> checkAuth = this.properties.getCheckAuthorize().getAuthorize();
            ArrayList<FinalAuth> auths = new ArrayList<FinalAuth>();
            for (Map.Entry<String, FinalAuth> entry : checkAuth.entrySet()) {
                if (!AuthUtils.matcher(entry.getKey(), path)) continue;
                auths.add(entry.getValue());
            }
            this.cacheAuths.put(path, auths.toArray(new FinalAuth[auths.size()]));
            for (FinalAuth auth : auths) {
                auth.check(session);
            }
            chain.doFilter(servletRequest, servletResponse);
        }
        catch (Exception e) {
            if (e instanceof FinalPermissionException) {
                this.properties.getExceptionHandler().permissionException(e, request, (HttpServletResponse)servletResponse);
            } else if (e instanceof FinalNotLoginException) {
                this.properties.getExceptionHandler().notLoginException(e, request, (HttpServletResponse)servletResponse);
            } else {
                this.properties.getExceptionHandler().exception(e, request, (HttpServletResponse)servletResponse);
            }
        }
        finally {
            FinalRequestContext.removeRequest();
        }
    }

    protected void config(FinalHttpProperties properties) {
        this.properties = properties;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config(this.properties);
    }

    @Bean
    public FinalHttpProperties finalHttpProperties() {
        return this.properties;
    }
}

