/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.utils;

import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class FinalPasswordUtils {
    private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Base64.Encoder encoder = Base64.getEncoder();
    private static Base64.Decoder decoder = Base64.getDecoder();
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;

    public static String base64Encoder(String str) {
        try {
            return encoder.encodeToString(str.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String base64Decoder(String str) {
        return new String(decoder.decode(str));
    }

    public static String md5BySalt(String str, String salt) {
        return FinalPasswordUtils.md5(FinalPasswordUtils.md5(str) + FinalPasswordUtils.md5(salt));
    }

    public static String md5BySalttoLowerCase(String str, String salt) {
        return FinalPasswordUtils.md5(FinalPasswordUtils.md5(str) + FinalPasswordUtils.md5(salt)).toLowerCase();
    }

    public static String md5toLowerCase(String str) {
        return FinalPasswordUtils.md5(str).toLowerCase();
    }

    public static String md5(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            byte[] b = str.getBytes();
            byte[] digest = md5.digest(b);
            StringBuffer sb = new StringBuffer();
            for (byte bb : digest) {
                sb.append(chars[bb >> 4 & 0xF]);
                sb.append(chars[bb & 0xF]);
            }
            return sb.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sha1(String str) {
        try {
            str = str == null ? "" : str;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] b = str.getBytes();
            md.update(b);
            byte[] b2 = md.digest();
            int len = b2.length;
            char[] chs = new char[len * 2];
            int k = 0;
            for (int i = 0; i < len; ++i) {
                byte b3 = b2[i];
                chs[k++] = chars[b3 >>> 4 & 0xF];
                chs[k++] = chars[b3 & 0xF];
            }
            return new String(chs);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sha256(String str) {
        try {
            str = str == null ? "" : str;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            byte[] bytes = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                String temp = Integer.toHexString(bytes[i] & 0xFF);
                if (temp.length() == 1) {
                    builder.append("0");
                }
                builder.append(temp);
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String aesEncrypt(String key, String text) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = text.getBytes("utf-8");
            cipher.init(1, FinalPasswordUtils.getSecretKey(key));
            byte[] result = cipher.doFinal(byteContent);
            return encoder.encodeToString(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String aesDecrypt(String key, String text) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, FinalPasswordUtils.getSecretKey(key));
            byte[] result = cipher.doFinal(decoder.decode(text));
            return new String(result, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        kg.init(128, random);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    public static HashMap<String, String> rsaGenerateKeyPair() throws Exception {
        return FinalPasswordUtils.rsaGenerateKeyPair(1024);
    }

    public static HashMap<String, String> rsaGenerateKeyPair(int keySize) throws Exception {
        KeyPair keyPair;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        try {
            keyPairGenerator.initialize(keySize, new SecureRandom(UUID.randomUUID().toString().replaceAll("-", "").getBytes()));
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("private", encoder.encodeToString(rsaPrivateKey.getEncoded()));
        map.put("public", encoder.encodeToString(rsaPublicKey.getEncoded()));
        return map;
    }

    public static String rsaEncryptByPublic(String publicKeyString, String content) {
        try {
            PublicKey publicKey = FinalPasswordUtils.getPublicKeyFromString(publicKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, publicKey);
            int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8 - 11;
            byte[][] arrays = FinalPasswordUtils.splitBytes(content.getBytes(), splitLength);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte[] array : arrays) {
                stringBuffer.append(FinalPasswordUtils.bytesToHexString(cipher.doFinal(array)));
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String rsaEncryptByPrivate(String privateKeyString, String content) {
        try {
            PrivateKey privateKey = FinalPasswordUtils.getPrivateKeyFromString(privateKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, privateKey);
            int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8 - 11;
            byte[][] arrays = FinalPasswordUtils.splitBytes(content.getBytes(), splitLength);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte[] array : arrays) {
                stringBuffer.append(FinalPasswordUtils.bytesToHexString(cipher.doFinal(array)));
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String rsaDecryptByPublic(String publicKeyString, String content) {
        try {
            PublicKey publicKey = FinalPasswordUtils.getPublicKeyFromString(publicKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, publicKey);
            int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8;
            byte[] contentBytes = FinalPasswordUtils.hexStringToBytes(content);
            byte[][] arrays = FinalPasswordUtils.splitBytes(contentBytes, splitLength);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte[] array : arrays) {
                stringBuffer.append(new String(cipher.doFinal(array)));
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String rsaDecryptByPrivate(String privateKeyString, String content) {
        try {
            PrivateKey privateKey = FinalPasswordUtils.getPrivateKeyFromString(privateKeyString);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, privateKey);
            int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8;
            byte[] contentBytes = FinalPasswordUtils.hexStringToBytes(content);
            byte[][] arrays = FinalPasswordUtils.splitBytes(contentBytes, splitLength);
            StringBuffer stringBuffer = new StringBuffer();
            for (byte[] array : arrays) {
                stringBuffer.append(new String(cipher.doFinal(array)));
            }
            return stringBuffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PublicKey getPublicKeyFromString(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        key = key.replace("\r\n", "");
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(decoder.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        return publicKey;
    }

    private static PrivateKey getPrivateKeyFromString(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        key = key.replace("\r\n", "");
        PKCS8EncodedKeySpec x509KeySpec = new PKCS8EncodedKeySpec(decoder.decode(key));
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(x509KeySpec);
        return privateKey;
    }

    private static byte[][] splitBytes(byte[] bytes, int splitLength) {
        int remainder = bytes.length % splitLength;
        int quotient = remainder != 0 ? bytes.length / splitLength + 1 : bytes.length / splitLength;
        byte[][] arrays = new byte[quotient][];
        byte[] array = null;
        for (int i = 0; i < quotient; ++i) {
            if (i == quotient - 1 && remainder != 0) {
                array = new byte[remainder];
                System.arraycopy(bytes, i * splitLength, array, 0, remainder);
            } else {
                array = new byte[splitLength];
                System.arraycopy(bytes, i * splitLength, array, 0, splitLength);
            }
            arrays[i] = array;
        }
        return arrays;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length);
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(0xFF & bytes[i]);
            if (temp.length() < 2) {
                sb.append(0);
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    private static byte[] hexStringToBytes(String hex) {
        int len = hex.length() / 2;
        hex = hex.toUpperCase();
        byte[] result = new byte[len];
        char[] chars = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(FinalPasswordUtils.toByte(chars[pos]) << 4 | FinalPasswordUtils.toByte(chars[pos + 1]));
        }
        return result;
    }

    private static byte toByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

