/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.utils;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringBeanUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpringBeanUtils.applicationContext == null) {
            SpringBeanUtils.applicationContext = applicationContext;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        try {
            return SpringBeanUtils.getApplicationContext().getBean(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)SpringBeanUtils.getApplicationContext().getBean(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        try {
            return (T)SpringBeanUtils.getApplicationContext().getBean(name, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isExistsBean(Class<?> clazz) {
        try {
            return SpringBeanUtils.getApplicationContext().getBean(clazz) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

