/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.annotation.impl;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import top.lingkang.finalsecurity.common.annotation.FinalCheck;
import top.lingkang.finalsecurity.common.error.FinalNotLoginException;
import top.lingkang.finalsecurity.common.utils.AuthUtils;
import top.lingkang.finalsecurity.config.FinalSecurityConfiguration;
import top.lingkang.finalsecurity.http.FinalRequestContext;
import top.lingkang.finalsecurity.http.FinalSecurityHolder;

@Aspect
public class FinalCheckAnnotation {
    @Autowired(required=false)
    private FinalSecurityHolder securityHolder;
    @Autowired(required=false)
    private FinalSecurityConfiguration finalSecurityConfiguration;

    @Around(value="@within(top.lingkang.finalsecurity.common.annotation.FinalCheck) || @annotation(top.lingkang.finalsecurity.common.annotation.FinalCheck)")
    public Object method(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature;
        FinalCheck method;
        if (this.finalSecurityConfiguration.getProperties().getCheckPathCache().getExcludePath().contains(FinalRequestContext.getRequest().getServletPath())) {
            return joinPoint.proceed();
        }
        if (!this.securityHolder.isLogin()) {
            throw new FinalNotLoginException("400 Not Login, \u60a8\u8fd8\u672a\u767b\u5f55\uff01");
        }
        FinalCheck clazz = joinPoint.getTarget().getClass().getAnnotation(FinalCheck.class);
        if (clazz != null) {
            this.check(clazz);
        }
        if ((method = (signature = (MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(FinalCheck.class)) != null) {
            this.check(method);
        }
        return joinPoint.proceed();
    }

    private void check(FinalCheck check) {
        if (check.anyRole().length != 0) {
            AuthUtils.checkRole((String[])check.anyRole(), (String[])this.securityHolder.getRole());
        }
        if (check.andRole().length != 0) {
            AuthUtils.checkAndRole((String[])check.andRole(), (String[])this.securityHolder.getRole());
        }
    }
}

