/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsecurity.config;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalsecurity.common.base.FinalExceptionHandler;
import top.lingkang.finalsecurity.common.utils.StringUtils;

public class DefaultFinalExceptionHandler
implements FinalExceptionHandler<HttpServletRequest, HttpServletResponse> {
    private static final Logger log = LoggerFactory.getLogger(DefaultFinalExceptionHandler.class);

    public void permissionException(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        this.printError(e, request, response, 403);
    }

    public void notLoginException(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        this.printError(e, request, response, 400);
    }

    public void exception(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        e.printStackTrace();
        try {
            response.getWriter().println(e.getMessage());
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private void printError(Throwable e, HttpServletRequest request, HttpServletResponse response, int code) {
        log.warn(e.getMessage() + "  url=" + request.getServletPath());
        String contentType = request.getContentType();
        if (contentType == null) {
            contentType = response.getContentType();
        }
        if (StringUtils.isEmpty((Object)contentType)) {
            contentType = "text/html; charset=UTF-8";
        }
        response.setContentType(contentType);
        response.setStatus(200);
        try {
            if (!contentType.toLowerCase().contains("html")) {
                response.getWriter().print("{\"code\":" + code + ",\"msg\":\"" + e.getMessage() + "\"}");
            } else {
                response.getWriter().print(e.getMessage());
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

