/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.util.ArrayList;
import java.util.List;
import top.lingkang.finalsql.constants.WhereType;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.sql.SqlCondition;

public class Condition {
    private String sql = "";
    private String order = " order by ";
    private List<String> orderByAsc;
    private List<String> orderByDesc;
    private List<SqlCondition> where = new ArrayList<SqlCondition>();
    private boolean custom;
    private List<Object> list = new ArrayList<Object>();

    public Condition orderByAsc(String ... column) {
        for (String c : column) {
            this.order = this.order + c + ", ";
        }
        this.order = this.order.substring(0, this.order.length() - 2);
        this.order = this.order + " ASC, ";
        return this;
    }

    public Condition orderByDesc(String ... column) {
        for (String c : column) {
            this.order = this.order + c + ", ";
        }
        this.order = this.order.substring(0, this.order.length() - 2);
        this.order = this.order + " DESC, ";
        return this;
    }

    public Condition eq(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.AND));
        return this;
    }

    public Condition or(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.OR));
        return this;
    }

    public Condition andIn(String column, List value) {
        this.where.add(new SqlCondition(column, value, WhereType.AND_IN));
        return this;
    }

    public Condition orIn(String column, List value) {
        this.where.add(new SqlCondition(column, value, WhereType.OR_IN));
        return this;
    }

    public Condition like(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.LIKE));
        return this;
    }

    public Condition leftLike(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.LEFT_LIKE));
        return this;
    }

    public Condition rightLike(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.RIGHT_LIKE));
        return this;
    }

    public Condition ne(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.NE));
        return this;
    }

    public Condition gt(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.GT));
        return this;
    }

    public Condition ge(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.GE));
        return this;
    }

    public Condition lt(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.LT));
        return this;
    }

    public Condition le(String column, Object value) {
        this.where.add(new SqlCondition(column, value, WhereType.LE));
        return this;
    }

    public Condition custom(String sql, Object ... param) {
        this.custom = true;
        for (Object o : param) {
            this.list.add(o);
        }
        this.sql = " " + sql;
        return this;
    }

    public String getOrder() {
        if (this.order.endsWith("by ")) {
            return null;
        }
        if (this.order.endsWith(", ")) {
            this.order = this.order.substring(0, this.order.length() - 2);
        }
        return this.order;
    }

    public ExSqlEntity getSql() {
        if (this.custom) {
            return new ExSqlEntity(this.sql, this.list);
        }
        ArrayList<Object> param = new ArrayList<Object>();
        for (SqlCondition condition : this.where) {
            switch (condition.getType()) {
                case AND: {
                    this.sql = this.sql + " and " + condition.getColumn() + "=?";
                    param.add(condition.getParam());
                    break;
                }
                case OR: {
                    this.sql = this.sql + " or " + condition.getColumn() + "=?";
                    param.add(condition.getParam());
                    break;
                }
                case AND_IN: {
                    List list = (List)condition.getParam();
                    if (list.isEmpty()) break;
                    this.setIn(this.sql, param, list, condition, true);
                    break;
                }
                case OR_IN: {
                    List list = (List)condition.getParam();
                    if (list.isEmpty()) break;
                    this.setIn(this.sql, param, list, condition, false);
                    break;
                }
                case LIKE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " like ?";
                    param.add("%" + condition.getParam() + "%");
                    break;
                }
                case LEFT_LIKE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " like ?";
                    param.add("%" + condition.getParam());
                    break;
                }
                case RIGHT_LIKE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " like ?";
                    param.add(condition.getParam() + "%");
                    break;
                }
                case NE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " <> ?";
                    param.add(condition.getParam());
                    break;
                }
                case GT: {
                    this.sql = this.sql + " and " + condition.getColumn() + " > ?";
                    param.add(condition.getParam());
                    break;
                }
                case GE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " >= ?";
                    param.add(condition.getParam());
                    break;
                }
                case LT: {
                    this.sql = this.sql + " and " + condition.getColumn() + " < ?";
                    param.add(condition.getParam());
                    break;
                }
                case LE: {
                    this.sql = this.sql + " and " + condition.getColumn() + " <= ?";
                    param.add(condition.getParam());
                }
            }
        }
        return new ExSqlEntity(this.sql, param);
    }

    public boolean hasWhere() {
        return !this.where.isEmpty() || this.custom;
    }

    private void setIn(String sql, List param, List list, SqlCondition condition, boolean isAnd) {
        String in = "";
        for (int i = 0; i < list.size(); ++i) {
            in = in + "?,";
            param.add(list.get(i));
        }
        this.sql = sql = sql + (isAnd ? " and " : " or ") + condition.getColumn() + " in (" + in.substring(0, in.length() - 1) + ")";
    }

    public static String getIn(int size) {
        String in = "";
        for (int i = 0; i < size; ++i) {
            in = in + "?,";
        }
        return in.substring(0, in.length() - 1);
    }
}

