/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.lingkang.finalsql.annotation.Nullable;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.error.ResultHandlerException;
import top.lingkang.finalsql.utils.AssertUtils;
import top.lingkang.finalsql.utils.ClassUtils;
import top.lingkang.finalsql.utils.NameUtils;

public class ResultHandler {
    private SqlConfig sqlConfig;

    public ResultHandler(SqlConfig config) {
        this.sqlConfig = config;
    }

    @Nullable
    public <T> List<T> list(ResultSet resultSet, T entity) {
        AssertUtils.notNull(resultSet, "ResultSet \u7ed3\u679c\u96c6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            Class<Object> clazz = ClassUtils.getClass(entity);
            Field[] fields = ClassUtils.getColumnField(clazz.getDeclaredFields());
            while (resultSet.next()) {
                Object obj = clazz.newInstance();
                for (Field field : fields) {
                    field.setAccessible(true);
                    field.set(obj, resultSet.getObject(field.getName(), field.getType()));
                }
                list.add(obj);
            }
            return list;
        }
        catch (IllegalAccessException | InstantiationException | SQLException e) {
            throw new ResultHandlerException(e);
        }
    }

    public <T> List<T> selectForList(ResultSet result, Class<T> entity) throws Exception {
        T t;
        ArrayList<T> list = new ArrayList<T>();
        while ((t = this.selectForObject(result, entity)) != null) {
            list.add(t);
        }
        return list;
    }

    public <T> T selectForObject(ResultSet result, Class<T> entity) throws Exception {
        if (entity == Map.class) {
            if (result.next()) {
                return (T)this.selectForMap(result);
            }
        } else if (ClassUtils.isBaseWrapper(entity)) {
            if (result.next()) {
                return result.getObject(1, entity);
            }
        } else if (entity == Blob.class) {
            if (result.next()) {
                return (T)result.getBlob(1);
            }
        } else if (result.next()) {
            ResultSetMetaData metaData = result.getMetaData();
            T ins = entity.newInstance();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                Field field = ClassUtils.getField(NameUtils.toHump(metaData.getColumnLabel(i)), ins.getClass().getDeclaredFields());
                if (field == null) continue;
                field.setAccessible(true);
                field.set(ins, result.getObject(i, field.getType()));
            }
            return ins;
        }
        return null;
    }

    public <T> T one(ResultSet resultSet, T entity) {
        AssertUtils.notNull(resultSet, "ResultSet \u7ed3\u679c\u96c6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            Field[] fields;
            Class<?> clazz = entity.getClass();
            for (Field field : fields = ClassUtils.getColumnField(clazz.getDeclaredFields())) {
                field.setAccessible(true);
                field.set(entity, resultSet.getObject(field.getName(), field.getType()));
            }
            return entity;
        }
        catch (IllegalAccessException | SQLException e) {
            throw new ResultHandlerException(e);
        }
    }

    public <T> int insert(ResultSet resultSet, T entity) throws SQLException, IllegalAccessException {
        int row = resultSet.getRow();
        Class<?> clazz = entity.getClass();
        Field idColumn = ClassUtils.getIdColumn(clazz.getDeclaredFields());
        if (idColumn != null) {
            idColumn.setAccessible(true);
            idColumn.set(entity, resultSet.getObject(1, idColumn.getType()));
        }
        return row;
    }

    public <T> int batchInsert(ResultSet resultSet, List<T> entity) throws SQLException, IllegalAccessException {
        int row = resultSet.getRow();
        int i = 0;
        while (resultSet.next()) {
            Class<?> clazz = entity.get(i).getClass();
            Field idColumn = ClassUtils.getIdColumn(clazz.getDeclaredFields());
            if (idColumn != null) {
                idColumn.setAccessible(true);
                idColumn.set(entity.get(i), resultSet.getObject(1, idColumn.getType()));
            }
            ++i;
        }
        return row;
    }

    public Map selectForMap(ResultSet result) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData metaData = result.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            map.put(NameUtils.toHump(metaData.getColumnLabel(i)), result.getObject(i));
        }
        return map;
    }
}

