/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import top.lingkang.finalsql.annotation.Column;
import top.lingkang.finalsql.annotation.Id;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.constants.IdType;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.error.FinalSqlException;
import top.lingkang.finalsql.sql.Condition;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.utils.ClassUtils;
import top.lingkang.finalsql.utils.CommonUtils;
import top.lingkang.finalsql.utils.NameUtils;

public class SqlGenerate {
    private SqlDialect dialect;
    private SqlConfig sqlConfig;

    public SqlGenerate(SqlDialect dialect, SqlConfig sqlConfig) {
        this.dialect = dialect;
        this.sqlConfig = sqlConfig;
    }

    public <T> ExSqlEntity querySql(T entity, Condition condition) {
        ExSqlEntity exSqlEntity = this.columnAndTableAndWhere(entity);
        this.addQueryCondition(exSqlEntity, condition);
        exSqlEntity.setSql("select " + exSqlEntity.getSql());
        return exSqlEntity;
    }

    public <T> ExSqlEntity oneSql(T entity, Condition condition) {
        ExSqlEntity exSqlEntity = this.columnAndTableAndWhere(entity);
        this.addQueryCondition(exSqlEntity, condition);
        exSqlEntity.setSql(this.dialect.one(exSqlEntity.getSql()));
        return exSqlEntity;
    }

    public <T> ExSqlEntity countSql(T t, Condition condition) {
        ExSqlEntity exSqlEntity = this.tableAndWhere(t);
        this.addCondition(exSqlEntity, condition);
        exSqlEntity.setSql(this.dialect.count(exSqlEntity.getSql()));
        return exSqlEntity;
    }

    public <T> ExSqlEntity selectRowSql(ExSqlEntity exSqlEntity, int row) {
        exSqlEntity.setSql(this.dialect.rowSql(exSqlEntity.getSql(), 0, row));
        return exSqlEntity;
    }

    public <T> ExSqlEntity insertSql(T t) {
        this.checkId(t);
        return this.insert(t);
    }

    public <T> ExSqlEntity batchInsert(List<T> entity) {
        String sql = "";
        ArrayList<Object> param = new ArrayList<Object>();
        boolean isFirst = false;
        int start = 0;
        int eq = entity.size() - 1;
        for (int i = 0; i < entity.size(); ++i) {
            T t = entity.get(i);
            ExSqlEntity exSqlEntity = this.insertSql(t);
            if (!isFirst) {
                sql = sql + exSqlEntity.getSql() + "";
                start = sql.indexOf("values") + 7;
                isFirst = true;
            } else {
                sql = sql + exSqlEntity.getSql().substring(start);
            }
            sql = i == eq ? sql + ";" : sql + ",\n";
            param.addAll(exSqlEntity.getParam());
        }
        return new ExSqlEntity(sql, param);
    }

    public <T> ExSqlEntity updateSql(T t, Condition condition) {
        return this.update(t, condition);
    }

    public <T> ExSqlEntity deleteSql(T t, Condition condition) {
        return this.delete(t, condition);
    }

    public <T> ExSqlEntity deleteSql(Class<T> t, List<Object> ids) {
        return this.deleteByIds(t, ids);
    }

    private void addQueryCondition(ExSqlEntity exSqlEntity, Condition condition) {
        if (condition != null) {
            String sql = exSqlEntity.getSql();
            if (sql.indexOf("where") == -1) {
                sql = sql + " where 1=1";
            }
            ExSqlEntity sql1 = condition.getSql();
            sql = sql + sql1.getSql();
            exSqlEntity.getParam().addAll(sql1.getParam());
            if (condition.getOrder() != null) {
                sql = sql + condition.getOrder();
            }
            exSqlEntity.setSql(sql);
        }
    }

    private void addCondition(ExSqlEntity exSqlEntity, Condition condition) {
        if (condition != null) {
            String sql = exSqlEntity.getSql();
            if (sql.indexOf("where") == -1) {
                sql = sql + " where 1=1";
            }
            ExSqlEntity sql1 = condition.getSql();
            sql = sql + sql1.getSql();
            exSqlEntity.getParam().addAll(sql1.getParam());
            exSqlEntity.setSql(sql);
        }
    }

    private <T> ExSqlEntity tableAndWhere(T entity) {
        Class<Object> clazz = ClassUtils.getClass(entity);
        if (entity instanceof Class) {
            try {
                entity = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new FinalException(e);
            }
        }
        String sql = " from " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields.length > 0) {
            sql = sql + " where 1=1";
            ArrayList<Object> param = new ArrayList<Object>();
            for (Field field : clazz.getDeclaredFields()) {
                Object o = ClassUtils.getValue(entity, clazz, field.getName());
                Column annotation = field.getAnnotation(Column.class);
                if (o == null || annotation == null) continue;
                param.add(o);
                sql = sql + " and ";
                sql = !"".equals(annotation.value()) ? sql + field.getName() + "=?" : sql + NameUtils.unHump(field.getName()) + "=?";
            }
            exSqlEntity.setParam(param);
        }
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity columnAndTableAndWhere(T entity) {
        Class<Object> clazz = ClassUtils.getClass(entity);
        if (entity instanceof Class) {
            try {
                entity = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new FinalException(e);
            }
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        String col = "";
        String sql = " where 1=1";
        ArrayList<Object> param = new ArrayList<Object>();
        if (declaredFields.length > 0) {
            for (Field field : declaredFields) {
                Column annotation = field.getAnnotation(Column.class);
                if (annotation == null) continue;
                String unHump = CommonUtils.isEmpty(annotation.value()) ? NameUtils.unHump(field.getName()) : annotation.value();
                col = unHump.equals(field.getName()) ? col + unHump + ", " : col + unHump + " as " + field.getName() + ", ";
                Object value = ClassUtils.getValue(entity, clazz, field.getName());
                if (value == null) continue;
                param.add(value);
                sql = sql + " and " + unHump + "=?";
            }
            col = CommonUtils.isEmpty(col) ? " * " : col.substring(0, col.length() - 2);
        }
        sql = col + " from " + NameUtils.getTableName(clazz, this.dialect) + sql;
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        exSqlEntity.setSql(sql);
        exSqlEntity.setParam(param);
        return exSqlEntity;
    }

    private <T> ExSqlEntity insert(T entity) {
        Class<?> clazz = entity.getClass();
        String sql = "insert into " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        Field[] declaredFields = clazz.getDeclaredFields();
        if (declaredFields.length < 1) {
            throw new FinalSqlException("\u63d2\u5165\u5bf9\u8c61\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String val = "";
        sql = sql + " (";
        ArrayList<Object> param = new ArrayList<Object>();
        for (Field field : declaredFields) {
            Object o;
            String unHump;
            Column column = field.getAnnotation(Column.class);
            Id id = field.getAnnotation(Id.class);
            if (id != null && id.value() == IdType.AUTO) {
                if ("".equals(id.sequence())) continue;
                String nextval = this.dialect.nextval(id.sequence());
                unHump = CommonUtils.isEmpty(column.value()) ? NameUtils.unHump(field.getName()) : column.value();
                sql = sql + unHump + ", ";
                val = val + nextval + ", ";
                continue;
            }
            if (column == null || (o = ClassUtils.getValue(entity, clazz, field.getName())) == null) continue;
            unHump = CommonUtils.isEmpty(column.value()) ? NameUtils.unHump(field.getName()) : column.value();
            sql = sql + unHump + ", ";
            param.add(o);
            val = val + "?, ";
        }
        if (param.isEmpty()) {
            throw new FinalSqlException("\u4e0d\u80fd\u63d2\u5165\u7a7a\u5bf9\u8c61\uff1a" + entity);
        }
        exSqlEntity.setParam(param);
        sql = sql.substring(0, sql.length() - 2) + ")";
        sql = sql + " values (" + val.substring(0, val.length() - 2) + ")";
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity update(T entity, Condition condition) {
        Class<?> clazz = entity.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        boolean hasCondition = false;
        if (condition != null && condition.hasWhere()) {
            hasCondition = true;
        }
        Field idField = null;
        Object id = null;
        if (!hasCondition) {
            idField = ClassUtils.getIdField(declaredFields);
            if (idField == null) {
                throw new FinalSqlException("\u66f4\u65b0\u5bf9\u8c61\u4e2d\u4e3b\u952eId\u4e3a\u7a7a\uff01");
            }
            id = ClassUtils.getValue(entity, clazz, idField.getName());
            if (id == null) {
                throw new FinalSqlException("\u66f4\u65b0\u5bf9\u8c61\u4e2d\u4e3b\u952eId\u4e3a\u7a7a\uff01");
            }
        }
        String sql = "update " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        sql = sql + " set ";
        ArrayList<Object> param = new ArrayList<Object>();
        for (Field field : declaredFields) {
            Object o;
            Column annotation = field.getAnnotation(Column.class);
            if (annotation == null || (o = ClassUtils.getValue(entity, clazz, field.getName())) == null) continue;
            String unHump = CommonUtils.isEmpty(annotation.value()) ? NameUtils.unHump(field.getName()) : annotation.value();
            sql = sql + unHump + "=?, ";
            param.add(o);
        }
        if (param.size() == 0) {
            throw new FinalSqlException("\u66f4\u65b0\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5b9e\u4f53\u7c7b\uff1a" + entity.getClass());
        }
        sql = sql.substring(0, sql.length() - 2);
        if (hasCondition) {
            sql = sql + " where 1=1";
            ExSqlEntity exSql = condition.getSql();
            sql = sql + exSql.getSql();
            exSqlEntity.getParam().addAll(exSql.getParam());
            sql = sql.substring(0, sql.length() - 2);
        } else {
            sql = sql + " where " + idField.getName() + "=?";
            param.add(id);
        }
        exSqlEntity.setParam(param);
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity delete(T entity, Condition condition) {
        if (entity instanceof Class) {
            try {
                entity = ((Class)entity).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Class<?> clazz = entity.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        boolean hasCondition = false;
        if (condition != null && condition.hasWhere()) {
            hasCondition = true;
        }
        String sql = "delete from " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        sql = sql + " where 1=1";
        ArrayList<Object> param = new ArrayList<Object>();
        for (Field field : declaredFields) {
            Column annotation = field.getAnnotation(Column.class);
            Object o = ClassUtils.getValue(entity, clazz, field.getName());
            if (o == null) continue;
            String unHump = CommonUtils.isEmpty(annotation.value()) ? NameUtils.unHump(field.getName()) : annotation.value();
            sql = sql + " and " + unHump + "=?";
            param.add(o);
            break;
        }
        if (param.size() == 0 && !hasCondition) {
            throw new FinalSqlException("\u4e0d\u652f\u6301\u4f7f\u7528\u6574\u8868\u6570\u636e\u5220\u9664\uff0c\u8bf7\u6dfb\u52a0\u53c2\u6570\u6761\u4ef6\uff01\u5b9e\u4f53\u7c7b\uff1a" + entity.getClass() + "\n \u82e5\u60f3\u6574\u8868\u6570\u636e\u5220\u9664\uff0c\u53ef\u6dfb\u52a0\u6761\u4ef6 1=1");
        }
        if (hasCondition) {
            ExSqlEntity exSql = condition.getSql();
            sql = sql + exSql.getSql();
            param.addAll(exSql.getParam());
        }
        exSqlEntity.setParam(param);
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity deleteByIds(Class<T> t, List<Object> ids) {
        String sql = "delete from " + NameUtils.getTableName(t, this.dialect);
        Field idColumn = ClassUtils.getIdColumn(t.getDeclaredFields());
        if (idColumn == null) {
            throw new FinalException("\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230 @Id \u6ce8\u89e3\uff0c\u65e0\u6cd5\u83b7\u53d6 Id \u5b57\u6bb5");
        }
        sql = sql + " where " + NameUtils.unHump(idColumn.getName()) + " in (" + Condition.getIn(ids.size()) + ")";
        return new ExSqlEntity(sql, ids);
    }

    private <T> void checkId(T entity) {
        Id annotation = null;
        Field id = null;
        for (Field field : entity.getClass().getDeclaredFields()) {
            annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            id = field;
            break;
        }
        if (annotation == null) {
            return;
        }
        if (annotation.value() == IdType.INPUT && ClassUtils.getValue(entity, entity.getClass(), id.getName()) == null) {
            throw new FinalException("\u5b9e\u4f53\u5bf9\u8c61 @Id \u7c7b\u578b\u4e3a IdType.INPUT\uff0c\u5219\u4e3b\u952e id \u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

