/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import top.lingkang.finalsql.annotation.Column;
import top.lingkang.finalsql.annotation.Id;
import top.lingkang.finalsql.annotation.Nullable;
import top.lingkang.finalsql.annotation.Table;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.utils.CommonUtils;
import top.lingkang.finalsql.utils.NameUtils;

public class ClassUtils {
    private static final HashMap<String, Class> typeMap = new HashMap();

    public static <T> String getColumn(Field[] df) {
        String col = "";
        for (Field field : df) {
            Column annotation = field.getAnnotation(Column.class);
            if (annotation == null) continue;
            if ("".equals(annotation.value())) {
                String unHump = NameUtils.unHump(field.getName());
                if (unHump.equals(field.getName())) {
                    col = col + unHump + ", ";
                    continue;
                }
                col = col + unHump + " as " + field.getName() + ", ";
                continue;
            }
            col = col + annotation.value() + ", ";
        }
        return CommonUtils.isEmpty(col) ? null : col.substring(0, col.length() - 2);
    }

    public static <T> Field getIdColumn(Field[] df) {
        for (Field field : df) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return field;
        }
        return null;
    }

    public static <T> Class<? extends Object> getClass(T entity) {
        if (!(entity instanceof Class)) {
            return entity.getClass();
        }
        try {
            return ((Class)entity).newInstance().getClass();
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    public static Field[] getColumnField(Field[] df) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : df) {
            Column annotation = field.getAnnotation(Column.class);
            if (annotation == null) continue;
            list.add(field);
        }
        return list.toArray(new Field[list.size()]);
    }

    @Nullable
    public static Field getIdField(Field[] df) {
        for (Field field : df) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static Id getId(Field[] df) {
        for (Field field : df) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static Field getField(String name, Field[] df) {
        for (Field field : df) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static <T> Object getValue(T t, Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(t);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new FinalException(e);
        }
    }

    public static boolean isBaseWrapper(Class o) {
        return typeMap.containsKey(o.getSimpleName());
    }

    public static boolean isTableEntity(Class<?> clazz) {
        return clazz.getAnnotation(Table.class) != null;
    }

    public static Class<?>[] getClassTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] clazz = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            clazz[i] = args[i].getClass();
        }
        return clazz;
    }

    public static <T> T getMapper(Class<T> clazz, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    @Nullable
    public static Class<?> getReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            return (Class)type.getActualTypeArguments()[0];
        }
        Class<?> baseClass = ClassUtils.getBaseClass(returnType.getTypeName());
        if (baseClass != null) {
            return baseClass;
        }
        return method.getReturnType();
    }

    @Nullable
    public static Class<?> getBaseClass(String typeName) {
        if ("java.util.Map".equals(typeName)) {
            return Map.class;
        }
        if ("int".equals(typeName) || "java.lang.Integer".equals(typeName)) {
            return Integer.class;
        }
        if ("long".equals(typeName) || "java.lang.Long".equals(typeName)) {
            return Long.class;
        }
        if ("java.util.Date".equals(typeName)) {
            return Date.class;
        }
        if ("void".equals(typeName)) {
            return null;
        }
        return null;
    }

    static {
        typeMap.put("String", String.class);
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.TYPE);
        typeMap.put("Long", Long.class);
        typeMap.put("Date", Date.class);
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("Short", Short.class);
        typeMap.put("Float", Float.class);
    }
}

