/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.utils;

import java.sql.Connection;
import javax.sql.DataSource;
import top.lingkang.finalsql.constants.DbType;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.utils.CommonUtils;

public class DataSourceUtils {
    public static DbType getDataType(DataSource dataSource) throws FinalException {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String name = connection.getMetaData().getDriverName();
            if (CommonUtils.isEmpty(name)) {
                throw new FinalException("\u914d\u7f6e\u65b9\u8a00\u5931\u8d25\uff1a\u672a\u8bc6\u522b\u7684jdbc\u8fde\u63a5\u9a71\u52a8");
            }
            if ((name = name.toLowerCase()).indexOf("mysql") != -1) {
                DbType dbType = DbType.MYSQL;
                return dbType;
            }
            if (name.indexOf("postgresql") != -1) {
                DbType dbType = DbType.POSTGRESQL;
                return dbType;
            }
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
        finally {
            CommonUtils.close(connection);
        }
        return DbType.OTHER;
    }
}

