/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import top.lingkang.finalsql.annotation.Delete;
import top.lingkang.finalsql.annotation.Insert;
import top.lingkang.finalsql.annotation.Select;
import top.lingkang.finalsql.annotation.Table;
import top.lingkang.finalsql.annotation.Update;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.sql.core.FinalSqlManage;
import top.lingkang.finalsql.utils.AssertUtils;
import top.lingkang.finalsql.utils.CommonUtils;

public abstract class AbstractMapperHandler {
    protected FinalSqlManage manage;
    protected Class<?> clazz;

    protected AbstractMapperHandler(Class<?> clazz, FinalSqlManage manage) {
        this.manage = manage;
        this.clazz = clazz;
    }

    protected Object select(Select select, Method method, Object[] args) {
        boolean hasList = false;
        Class returnType = method.getReturnType();
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            hasList = true;
            returnType = (Class)pt.getActualTypeArguments()[0];
        }
        AssertUtils.notNull(returnType, "\u67e5\u8be2\u63a5\u53e3\u65b9\u6cd5\u7684\u8fd4\u56de\u7c7b\u578b\u672a\u80fd\u8bc6\u522b\u6216\u8005\u4e3avoid\uff1a" + method.toGenericString() + "  \u9700\u8981\u8fd4\u56de\u7ed3\u679c\uff01");
        if ("".equals(select.value())) {
            if (args[0].getClass().getAnnotation(Table.class) != null) {
                return this.manage.select(args[0].getClass());
            }
            throw new FinalException("@Select \u67e5\u8be2SQL\u4e3a\u7a7a\u65f6\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u5bf9\u8c61\u5e94\u4e3a\u8868\u6620\u5c04\u5b9e\u4f53\u7c7b\u5bf9\u8c61\uff01\u5f53\u524d\uff1a" + returnType);
        }
        CommonUtils.checkParam(select.value(), args);
        if (hasList) {
            return this.manage.selectForList(select.value(), returnType, args);
        }
        if (returnType == List.class) {
            return this.manage.selectForList(select.value(), returnType, args);
        }
        String simpleName = returnType.getSimpleName();
        if ("Map".equals(simpleName)) {
            return this.manage.selectForMap(select.value(), false, args);
        }
        return this.manage.selectForObject(select.value(), returnType, args);
    }

    protected Object update(Update update, Method method, Object[] args) {
        int count = 0;
        if ("".equals(update.value())) {
            for (Object obj : args) {
                Table annotation = obj.getClass().getAnnotation(Table.class);
                if (annotation == null || this.manage.update(obj) <= 0) continue;
                ++count;
            }
        } else {
            count = this.manage.nativeUpdate(update.value(), args);
        }
        if ("void".equals(method.getReturnType().getSimpleName().toLowerCase())) {
            return null;
        }
        return count;
    }

    protected Object insert(Insert insert, Method method, Object[] args) {
        int count = 0;
        if ("".equals(insert.value())) {
            for (Object obj : args) {
                Table annotation = obj.getClass().getAnnotation(Table.class);
                if (annotation == null || this.manage.insert(obj) <= 0) continue;
                ++count;
            }
        } else {
            count = this.manage.nativeUpdate(insert.value(), args);
        }
        if ("void".equals(method.getReturnType().getSimpleName().toLowerCase())) {
            return null;
        }
        return count;
    }

    protected Object delete(Delete delete, Method method, Object[] args) {
        int count = 0;
        if ("".equals(delete.value())) {
            for (Object obj : args) {
                Table annotation = obj.getClass().getAnnotation(Table.class);
                if (annotation == null) continue;
                count += this.manage.delete(obj);
            }
        } else {
            count = this.manage.nativeUpdate(delete.value(), args);
        }
        if ("void".equals(method.getReturnType().getSimpleName().toLowerCase())) {
            return null;
        }
        return count;
    }
}

