/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.lingkang.finalsql.annotation.Id;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.constants.IdType;
import top.lingkang.finalsql.error.ResultHandlerException;
import top.lingkang.finalsql.utils.ClassUtils;
import top.lingkang.finalsql.utils.NameUtils;
import top.lingkang.finalsql.utils.TabCache;

public class ResultHandler {
    private SqlConfig sqlConfig;

    public ResultHandler(SqlConfig config) {
        this.sqlConfig = config;
    }

    public <T> List<T> list(ResultSet resultSet, Class<T> clazz) {
        try {
            ArrayList<T> list = new ArrayList<T>();
            TabCache tabCache = ClassUtils.tabCache.get(clazz);
            while (resultSet.next()) {
                T obj = clazz.newInstance();
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    String columnLabel = metaData.getColumnLabel(i + 1);
                    Field columnField = ClassUtils.getFieldByColumnLabel(columnLabel, tabCache);
                    if (columnField == null) continue;
                    columnField.setAccessible(true);
                    columnField.set(obj, tabCache.getTypeHandler()[i].getResult(resultSet, columnField.getName()));
                }
                list.add(obj);
            }
            return list;
        }
        catch (IllegalAccessException | InstantiationException | SQLException e) {
            throw new ResultHandlerException(e);
        }
    }

    public <T> List<T> selectForList(ResultSet result, Class<T> clazz) throws Exception {
        T t;
        ArrayList<T> list = new ArrayList<T>();
        while ((t = this.selectForObject(result, clazz)) != null) {
            list.add(t);
        }
        return list;
    }

    public <T> T selectForObject(ResultSet result, Class<T> entity) throws Exception {
        if (entity == Map.class) {
            if (result.next()) {
                return (T)this.selectForMap(result);
            }
        } else if (ClassUtils.isBaseWrapper(entity)) {
            if (result.next()) {
                return (T)result.getObject(1);
            }
        } else if (entity == Blob.class) {
            if (result.next()) {
                return (T)result.getBlob(1);
            }
        } else if (result.next()) {
            ResultSetMetaData metaData = result.getMetaData();
            T ins = entity.newInstance();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                Field field = ClassUtils.getField(NameUtils.toHump(metaData.getColumnLabel(i)), ins.getClass().getDeclaredFields());
                if (field == null) continue;
                field.setAccessible(true);
                field.set(ins, ClassUtils.setTypeHandler(field.getType()).getResult(result, metaData.getColumnLabel(i)));
            }
            return ins;
        }
        return null;
    }

    public <T> T oneResult(ResultSet resultSet, Class<T> clazz) {
        try {
            TabCache tabCache = ClassUtils.tabCache.get(clazz);
            T entity = clazz.newInstance();
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i + 1);
                Field columnField = ClassUtils.getFieldByColumnLabel(columnName, tabCache);
                if (columnField == null) continue;
                columnField.setAccessible(true);
                columnField.set(entity, tabCache.getTypeHandler()[i].getResult(resultSet, columnField.getName()));
            }
            return entity;
        }
        catch (Exception e) {
            throw new ResultHandlerException(e);
        }
    }

    public <T> int insert(ResultSet resultSet, T entity) throws SQLException, IllegalAccessException {
        TabCache tabCache = ClassUtils.tabCache.get(entity.getClass());
        if (tabCache.getIdType() == IdType.INPUT) {
            return 1;
        }
        Field idColumn = tabCache.getIdColumnField();
        if (idColumn != null) {
            idColumn.setAccessible(true);
            idColumn.set(entity, ClassUtils.setTypeHandler(idColumn.getType()).getResult(resultSet, 1));
        }
        return 1;
    }

    public <T> int batchInsert(ResultSet resultSet, List<T> entity) throws SQLException, IllegalAccessException {
        boolean notSetId = false;
        Id id = ClassUtils.getId(entity.get(0).getClass());
        if (id != null && id.value() == IdType.INPUT) {
            notSetId = true;
        }
        int i = 0;
        while (resultSet.next()) {
            if (notSetId) continue;
            TabCache tabCache = ClassUtils.tabCache.get(entity.get(i).getClass());
            Field idColumn = tabCache.getIdColumnField();
            if (idColumn != null) {
                idColumn.setAccessible(true);
                idColumn.set(entity.get(i), ClassUtils.setTypeHandler(idColumn.getType()).getResult(resultSet, 1));
            }
            ++i;
        }
        return i;
    }

    public Map selectForMap(ResultSet result) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResultSetMetaData metaData = result.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            map.put(metaData.getColumnLabel(i), result.getObject(i));
        }
        return map;
    }
}

