/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalsql.base.SqlInterceptor;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.sql.ResultCallback;
import top.lingkang.finalsql.sql.core.AbstractFinalConnection;
import top.lingkang.finalsql.utils.ExceptionUtils;

public abstract class AbstractFinalSqlExecute
extends AbstractFinalConnection {
    public static SqlInterceptor[] interceptor;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractFinalSqlExecute(SqlConfig sqlConfig) {
        super(sqlConfig);
    }

    protected <T> T execute(ExSqlEntity exSqlEntity, ResultCallback<T> rc) throws Exception {
        return this.execute(exSqlEntity, rc, false);
    }

    protected <T> T execute(ExSqlEntity exSqlEntity, ResultCallback<T> rc, boolean oneRow) throws Exception {
        Connection connection = this.getConnection();
        this.before(exSqlEntity, connection);
        try {
            PreparedStatement statement = this.getPreparedStatement(connection, exSqlEntity.getSql(), exSqlEntity.getParam());
            if (oneRow) {
                statement.setMaxRows(1);
            }
            ResultSet resultSet = statement.executeQuery();
            if (rc == null) {
                T t = null;
                return t;
            }
            T callback = rc.callback(resultSet);
            this.after(exSqlEntity, connection, callback);
            if (this.sqlConfig.isShowLog()) {
                ExceptionUtils.outLogSql(exSqlEntity, callback, this.logger);
            }
            statement.close();
            T t = callback;
            return t;
        }
        catch (Exception e) {
            ExceptionUtils.outError(exSqlEntity, this.logger);
            throw e;
        }
        finally {
            this.close(connection);
        }
    }

    protected <T> int executeReturn(ExSqlEntity exSqlEntity, ResultCallback<T> rc) throws Exception {
        Connection connection = this.getConnection();
        this.before(exSqlEntity, connection);
        try {
            PreparedStatement statement = this.getPreparedStatementInsert(connection, exSqlEntity.getSql(), exSqlEntity.getParam());
            int success = statement.executeUpdate();
            if (rc == null) {
                int n = success;
                return n;
            }
            ResultSet generatedKeys = statement.getGeneratedKeys();
            T callback = rc.callback(generatedKeys);
            this.after(exSqlEntity, connection, callback);
            if (this.sqlConfig.isShowLog()) {
                ExceptionUtils.outLogSql(exSqlEntity, callback, this.logger);
            }
            statement.close();
            int n = success;
            return n;
        }
        catch (Exception e) {
            ExceptionUtils.outError(exSqlEntity, this.logger);
            throw e;
        }
        finally {
            this.close(connection);
        }
    }

    protected <T> List<T> executeReturnList(ExSqlEntity exSqlEntity, ResultCallback<T> rc) throws Exception {
        Connection connection = this.getConnection();
        this.before(exSqlEntity, connection);
        try {
            PreparedStatement statement = this.getPreparedStatement(connection, exSqlEntity.getSql(), exSqlEntity.getParam());
            ResultSet resultSet = statement.executeQuery();
            ArrayList<T> callback = new ArrayList<T>();
            while (resultSet.next()) {
                callback.add(rc.callback(resultSet));
            }
            this.after(exSqlEntity, connection, callback);
            if (this.sqlConfig.isShowLog()) {
                ExceptionUtils.outLogSql(exSqlEntity, callback, this.logger);
            }
            statement.close();
            ArrayList<T> arrayList = callback;
            return arrayList;
        }
        catch (Exception e) {
            ExceptionUtils.outError(exSqlEntity, this.logger);
            throw e;
        }
        finally {
            this.close(connection);
        }
    }

    protected int executeUpdate(ExSqlEntity exSqlEntity) throws Exception {
        Connection connection = this.getConnection();
        this.before(exSqlEntity, connection);
        try {
            PreparedStatement statement = this.getPreparedStatement(connection, exSqlEntity.getSql(), exSqlEntity.getParam());
            int i = statement.executeUpdate();
            this.after(exSqlEntity, connection, i);
            if (this.sqlConfig.isShowLog()) {
                ExceptionUtils.outLogSql(exSqlEntity, i, this.logger);
            }
            statement.close();
            int n = i;
            return n;
        }
        catch (Exception e) {
            ExceptionUtils.outError(exSqlEntity, this.logger);
            throw e;
        }
        finally {
            this.close(connection);
        }
    }

    private void before(ExSqlEntity exSqlEntity, Connection connection) {
        if (interceptor != null) {
            for (SqlInterceptor in : interceptor) {
                in.before(exSqlEntity, connection);
            }
        }
    }

    private void after(ExSqlEntity sqlEntity, Connection connection, Object result) {
        if (interceptor != null) {
            for (SqlInterceptor in : interceptor) {
                in.after(sqlEntity, connection, result);
            }
        }
    }
}

