/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.error.FinalSqlException;
import top.lingkang.finalsql.sql.SqlGenerate;
import top.lingkang.finalsql.sql.core.AbstractFinalCommonHandler;
import top.lingkang.finalsql.utils.AssertUtils;
import top.lingkang.finalsql.utils.CommonUtils;

abstract class AbstractFinalConnection
extends AbstractFinalCommonHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected DataSource dataSource;
    protected SqlGenerate sqlGenerate;
    protected final SqlConfig sqlConfig;
    private static final ThreadLocal<Connection> transaction = new ThreadLocal();

    public AbstractFinalConnection(SqlConfig sqlConfig) {
        this.sqlConfig = sqlConfig;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected Connection getConnection() {
        Connection connection = transaction.get();
        if (connection != null) {
            return connection;
        }
        try {
            connection = this.dataSource.getConnection();
            AssertUtils.isFalse(connection.isClosed(), "DataSource \u8fde\u63a5\u72b6\u6001\uff1aclose");
            return connection;
        }
        catch (SQLException e) {
            throw new FinalSqlException(e);
        }
    }

    protected void begin() {
        Connection connection = transaction.get();
        if (connection != null) {
            this.log.warn("\u4e8b\u52a1\u5df2\u7ecf\u662f\u5f00\u542f\u72b6\u6001\uff01");
            return;
        }
        try {
            connection = this.dataSource.getConnection();
            AssertUtils.isFalse(connection.isClosed(), "DataSource \u8fde\u63a5\u72b6\u6001\uff1aclose");
            connection.setAutoCommit(false);
            transaction.set(connection);
        }
        catch (SQLException e) {
            throw new FinalSqlException(e);
        }
        if (this.sqlConfig.isShowLog()) {
            this.log.info("\u5f00\u542f\u4e8b\u52a1\u6210\u529f");
        }
    }

    protected void commit() {
        Connection connection = transaction.get();
        if (connection == null) {
            throw new FinalSqlException("\u4e8b\u52a1\u672a\u5f00\u542f\uff01");
        }
        try {
            connection.commit();
        }
        catch (SQLException e) {
            throw new FinalSqlException(e);
        }
        finally {
            this.ignoreTransactionClose(connection);
        }
        if (this.sqlConfig.isShowLog()) {
            this.log.info("\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f");
        }
    }

    protected void rollback() {
        Connection connection = transaction.get();
        if (connection == null) {
            throw new FinalSqlException("\u4e8b\u52a1\u672a\u5f00\u542f\uff01");
        }
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            throw new FinalSqlException(e);
        }
        finally {
            this.ignoreTransactionClose(connection);
        }
        if (this.sqlConfig.isShowLog()) {
            this.log.info("\u4e8b\u52a1\u56de\u6eda\u6210\u529f");
        }
    }

    protected boolean isOpenTransaction() {
        return transaction.get() != null;
    }

    protected void ignoreTransactionClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                transaction.remove();
                closeable.close();
            }
            catch (Exception e) {
                this.log.warn("\u5173\u95ed\u8fde\u63a5\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    protected void close(AutoCloseable closeable) {
        if (transaction.get() != null) {
            return;
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.log.warn("\u5173\u95ed\u8fde\u63a5\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    protected PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        this.applyStatementSettings(statement);
        return statement;
    }

    protected PreparedStatement getPreparedStatement(Connection connection, String sql, Object ... param) throws SQLException {
        PreparedStatement statement = this.getPreparedStatement(connection, sql);
        this.applyStatementSettings(statement);
        this.setParamValue(statement, param);
        return statement;
    }

    protected PreparedStatement getPreparedStatement(Connection connection, String sql, List param) throws SQLException {
        PreparedStatement statement = this.getPreparedStatement(connection, sql);
        this.applyStatementSettings(statement);
        if (param != null) {
            this.setParamValue(statement, param);
        }
        return statement;
    }

    protected PreparedStatement getPreparedStatementInsert(Connection connection, String sql, List param) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql, 1);
        this.applyStatementSettings(statement);
        if (param != null) {
            this.setParamValue(statement, param);
        }
        return statement;
    }

    protected void setParamValue(PreparedStatement statement, List list) throws SQLException {
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof Date) {
                statement.setObject(++i, CommonUtils.dateFormat.format(o));
                continue;
            }
            statement.setObject(++i, o);
        }
    }

    protected void setParamValue(PreparedStatement statement, Object ... param) throws SQLException {
        int i = 0;
        while (i < param.length) {
            Object o = param[i];
            if (o instanceof Date) {
                statement.setObject(++i, o);
                continue;
            }
            statement.setObject(++i, o);
        }
    }

    protected void applyStatementSettings(PreparedStatement statement) throws SQLException {
        statement.setFetchSize(this.sqlConfig.getFetchSize());
        statement.setMaxRows(this.sqlConfig.getMaxRows());
    }
}

