/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.lingkang.finalsql.annotation.Table;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.error.FinalCheckException;
import top.lingkang.finalsql.utils.CommonUtils;

public class NameUtils {
    private static final Pattern toHump = Pattern.compile("_+[a-zA-Z0-9]");
    private static final Pattern unHump = Pattern.compile("[a-z0-9][A-Z0-9]");

    public static String toHump(String str) {
        Matcher matcher;
        while ((matcher = toHump.matcher(str)).find()) {
            String group = matcher.group();
            str = str.replaceAll(group, group.substring(1).toUpperCase());
        }
        return str;
    }

    public static String unHump(String str) {
        Matcher matcher;
        str = str.substring(0, 1).toLowerCase() + str.substring(1);
        while ((matcher = unHump.matcher(str)).find()) {
            String group = matcher.group();
            str = str.replaceAll(group, group.substring(0, 1) + "_" + group.substring(1).toLowerCase());
        }
        return str;
    }

    public static String getTableName(Class<?> clazz, SqlDialect dialect) {
        Table annotation = clazz.getAnnotation(Table.class);
        if (annotation == null) {
            throw new FinalCheckException("\u8868\u5bf9\u8c61\u65e0 @Table \u6ce8\u89e3");
        }
        if (CommonUtils.isNotEmpty(annotation.value())) {
            return dialect.getTableName(annotation.value());
        }
        return dialect.getTableName(NameUtils.unHump(clazz.getSimpleName()));
    }
}

