/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import top.lingkang.finalsql.base.SqlInterceptor;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.constants.DbType;
import top.lingkang.finalsql.dialect.Mysql57Dialect;
import top.lingkang.finalsql.dialect.PostgreSqlDialect;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.dialect.Sqlite3Dialect;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.error.ResultHandlerException;
import top.lingkang.finalsql.sql.Condition;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.sql.FinalPageInterceptor;
import top.lingkang.finalsql.sql.FinalSql;
import top.lingkang.finalsql.sql.PageInfo;
import top.lingkang.finalsql.sql.ResultCallback;
import top.lingkang.finalsql.sql.ResultHandler;
import top.lingkang.finalsql.sql.SqlGenerate;
import top.lingkang.finalsql.sql.core.AbstractFinalSqlExecute;
import top.lingkang.finalsql.sql.core.FinalMapperInvocation;
import top.lingkang.finalsql.utils.AssertUtils;
import top.lingkang.finalsql.utils.ClassUtils;
import top.lingkang.finalsql.utils.CommonUtils;
import top.lingkang.finalsql.utils.DataSourceUtils;

public class FinalSqlManage
extends AbstractFinalSqlExecute
implements FinalSql {
    private SqlConfig sqlConfig;
    private int id;
    private ResultHandler resultHandler;
    private Map<String, Object> mappers = new HashMap<String, Object>();

    public FinalSqlManage(SqlConfig config) {
        super(config);
        this.checkDependencies();
        this.sqlConfig = config;
        this.dataSource = config.getDataSource();
        if (this.sqlConfig == null) {
            this.sqlConfig = new SqlConfig();
        }
        this.checkDialect();
        this.resultHandler = new ResultHandler(this.sqlConfig);
        this.sqlGenerate = new SqlGenerate(this.sqlConfig.getSqlDialect(), this.sqlConfig);
        interceptor = this.sqlConfig.getInterceptor();
        if (this.sqlConfig.isUsePageHelper()) {
            if (interceptor == null) {
                SqlInterceptor[] sqlInterceptors = new SqlInterceptor[]{new FinalPageInterceptor(this.sqlConfig, this)};
                interceptor = sqlInterceptors;
            } else {
                interceptor = Arrays.copyOf(interceptor, interceptor.length + 1);
                FinalSqlManage.interceptor[FinalSqlManage.interceptor.length - 1] = new FinalPageInterceptor(this.sqlConfig, this);
            }
        }
        ClassUtils.sqlConfig = this.sqlConfig;
        this.id = CommonUtils.generatorId();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public <T> List<T> select(Class<T> clazz) {
        return this.select(clazz, null);
    }

    @Override
    public <T> List<T> select(final Class<T> clazz, Condition condition) {
        AssertUtils.notNull(clazz, "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return (List)this.execute(this.sqlGenerate.querySql(clazz, condition), new ResultCallback<List<T>>(){

                @Override
                public List<T> callback(ResultSet result) throws Exception {
                    return FinalSqlManage.this.resultHandler.list(result, clazz);
                }
            });
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> T selectOne(Class<T> clazz) {
        return this.selectOne(clazz, null);
    }

    @Override
    public <T> T selectOne(final Class<T> clazz, Condition condition) {
        AssertUtils.notNull(clazz, "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return this.execute(this.sqlGenerate.oneSql(clazz, condition), new ResultCallback<T>(){

                @Override
                public T callback(ResultSet result) throws Exception {
                    if (result.next()) {
                        return FinalSqlManage.this.resultHandler.oneResult(result, clazz);
                    }
                    return null;
                }
            }, true);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int selectCount(Class<T> clazz) {
        return this.selectCount(clazz, null);
    }

    @Override
    public <T> int selectCount(Class<T> clazz, Condition condition) {
        AssertUtils.notNull(clazz, "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return this.execute(this.sqlGenerate.countSql(clazz, condition), new ResultCallback<Integer>(){

                @Override
                public Integer callback(ResultSet result) throws Exception {
                    if (result.next()) {
                        return result.getInt(1);
                    }
                    return 0;
                }
            }, true);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> List<T> selectForList(String sql, Class<T> resultClass) {
        return this.selectForList(sql, resultClass, new ArrayList());
    }

    @Override
    public <T> List<T> selectForListRow(String sql, Class<T> t, int row) {
        return this.selectForListRow(sql, t, row, new ArrayList());
    }

    @Override
    public <T> List<T> selectForList(String sql, Class<T> t, Object ... param) {
        ArrayList<Object> ps = new ArrayList<Object>();
        if (CommonUtils.notEmpty(param)) {
            ps.addAll(Arrays.asList(param));
        }
        return this.selectForList(sql, t, ps);
    }

    @Override
    public <T> List<T> selectForList(String sql, final Class<T> resultClass, List param) {
        AssertUtils.notNull(resultClass, "\u67e5\u8be2\u7684\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonUtils.checkParam(sql, param);
        try {
            return (List)this.execute(new ExSqlEntity(sql, param), new ResultCallback<List<T>>(){

                @Override
                public List<T> callback(ResultSet result) throws Exception {
                    return FinalSqlManage.this.resultHandler.selectForList(result, resultClass);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                throw new FinalException("\u4e0d\u652f\u6301\u7684\u7ed3\u679c\u7c7b\u578b\uff1a" + resultClass.getName());
            }
            throw new FinalException(e);
        }
    }

    @Override
    public <T> List<T> selectForListRow(String sql, Class<T> t, int row, Object ... param) {
        AssertUtils.notNull(t, "\u67e5\u8be2\u7684\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<Object> ps = new ArrayList<Object>();
        if (CommonUtils.notEmpty(param)) {
            ps.addAll(Arrays.asList(param));
        }
        return this.selectForListRow(sql, t, row, ps);
    }

    @Override
    public <T> List<T> selectForListRow(String sql, final Class<T> t, int row, List param) {
        AssertUtils.notNull(t, "\u67e5\u8be2\u7684\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return (List)this.execute(this.sqlGenerate.selectRowSql(new ExSqlEntity(sql, param), row), new ResultCallback<List<T>>(){

                @Override
                public List<T> callback(ResultSet result) throws Exception {
                    return FinalSqlManage.this.resultHandler.selectForList(result, t);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                throw new FinalException("\u4e0d\u652f\u6301\u7684\u7ed3\u679c\u7c7b\u578b\uff1a" + t.getName());
            }
            throw new FinalException(e);
        }
    }

    @Override
    public <T> T selectForObject(String sql, Class<T> t) {
        return this.selectForObject(sql, t, new ArrayList());
    }

    @Override
    public <T> T selectForObject(String sql, Class<T> t, Object ... param) throws FinalException {
        ArrayList<Object> ps = new ArrayList<Object>();
        if (CommonUtils.notEmpty(param)) {
            ps.addAll(Arrays.asList(param));
        }
        return this.selectForObject(sql, t, ps);
    }

    @Override
    public <T> T selectForObject(String sql, final Class<T> clazz, List param) {
        AssertUtils.notNull(clazz, "\u67e5\u8be2\u7684\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonUtils.checkParam(sql, param);
        try {
            return this.execute(new ExSqlEntity(sql, param), new ResultCallback<T>(){

                @Override
                public T callback(ResultSet result) throws Exception {
                    return FinalSqlManage.this.resultHandler.selectForObject(result, clazz);
                }
            }, true);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public Map selectForMap(String sql) {
        return this.selectForMap(sql, new ArrayList());
    }

    @Override
    public Map selectForMap(String sql, Object ... param) {
        List<Object> params = new ArrayList();
        if (CommonUtils.notEmpty(param)) {
            params = Arrays.asList(param);
        }
        return this.selectForMap(sql, params);
    }

    @Override
    public Map selectForMap(String sql, List param) {
        try {
            return this.execute(new ExSqlEntity(sql, param), new ResultCallback<Map>(){

                @Override
                public Map callback(ResultSet result) throws Exception {
                    if (result.next()) {
                        return FinalSqlManage.this.resultHandler.selectForMap(result);
                    }
                    return null;
                }
            }, true);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int insert(final T entity) {
        AssertUtils.notNull(entity, "\u63d2\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isFalse(entity instanceof Class, "\u4e0d\u80fd\u63d2\u5165 class \u5bf9\u8c61\uff1a" + entity.getClass());
        try {
            return this.executeReturn(this.sqlGenerate.insertSql(entity), new ResultCallback<Integer>(){

                @Override
                public Integer callback(ResultSet result) throws Exception {
                    try {
                        if (result.next()) {
                            return FinalSqlManage.this.resultHandler.insert(result, entity);
                        }
                        return 0;
                    }
                    catch (IllegalAccessException e) {
                        throw new ResultHandlerException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int insert(T entity, ResultCallback<T> rc) {
        AssertUtils.notNull(entity, "\u63d2\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isFalse(entity instanceof Class, "\u4e0d\u80fd\u63d2\u5165 class \u5bf9\u8c61\uff1a" + entity.getClass());
        try {
            return this.executeReturn(this.sqlGenerate.insertSql(entity), rc);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int batchInsert(final List<T> entity) throws FinalException {
        if (CommonUtils.isEmpty(entity)) {
            throw new FinalException("\u6279\u91cf\u63d2\u5165\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (entity.size() > 1000) {
            throw new FinalException("\u6bcf\u6b21\u6279\u91cf\u63d2\u5165\u4e0d\u80fd\u5927\u4e8e 1000 \u6761\uff01");
        }
        try {
            return this.executeReturn(this.sqlGenerate.batchInsert(entity), new ResultCallback<Integer>(){

                @Override
                public Integer callback(ResultSet result) throws Exception {
                    try {
                        return FinalSqlManage.this.resultHandler.batchInsert(result, entity);
                    }
                    catch (IllegalAccessException e) {
                        throw new ResultHandlerException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> T insertReturnGeneratedKey(String sql, Class<T> classType) {
        return this.insertReturnGeneratedKey(sql, classType, null);
    }

    @Override
    public <T> T insertReturnGeneratedKey(String sql, final Class<T> classType, List<Object> param) {
        try {
            return this.executeReturnObject(new ExSqlEntity(sql, param), new ResultCallback<T>(){

                @Override
                public T callback(ResultSet result) throws Exception {
                    if (result.next()) {
                        return ClassUtils.typeHandler.get(classType).getResult(result, 1);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int update(T entity) {
        return this.update(entity, null);
    }

    @Override
    public <T> int update(T entity, Condition condition) {
        AssertUtils.notNull(entity, "\u63d2\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isFalse(entity instanceof Class, "\u4e0d\u80fd\u66f4\u65b0 class \u5bf9\u8c61\uff1a" + entity.getClass());
        try {
            return this.executeUpdate(this.sqlGenerate.updateSql(entity, condition));
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int delete(T entity) {
        return this.delete(entity, null);
    }

    @Override
    public <T> int delete(T entity, Condition condition) {
        AssertUtils.notNull(entity, "\u5220\u9664\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isFalse(entity instanceof Class, "\u4e0d\u80fd\u5220\u9664 class \u5bf9\u8c61\uff1a" + entity.getClass());
        try {
            return this.executeUpdate(this.sqlGenerate.deleteSql(entity, condition));
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> int deleteByIds(Class<T> entity, Object ... ids) {
        return this.deleteByIds(entity, Arrays.asList(ids));
    }

    @Override
    public <T> int deleteByIds(Class<T> entity, List ids) {
        AssertUtils.notNull(entity, "\u5220\u9664\u7684\u6620\u5c04\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(ids, "\u5165\u53c2 Id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return this.executeUpdate(this.sqlGenerate.deleteSql(entity, ids));
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public <T> List<T> nativeSelect(String sql, ResultCallback<T> callback) throws FinalException {
        return this.nativeSelect(sql, callback, new ArrayList());
    }

    public <T> List nativeSelect(String sql, ResultCallback<T> rc, Object ... param) throws FinalException {
        List<Object> ps = new ArrayList();
        if (CommonUtils.notEmpty(param)) {
            ps = Arrays.asList(param);
        }
        return this.nativeSelect(sql, rc, ps);
    }

    @Override
    public <T> List<T> nativeSelect(String sql, ResultCallback<T> callback, List param) throws FinalException {
        AssertUtils.notEmpty(sql, "sql \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return this.executeReturnList(new ExSqlEntity(sql, param), callback);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public int nativeUpdate(String sql) throws FinalException {
        return this.nativeUpdate(sql, new ArrayList());
    }

    @Override
    public int nativeUpdate(String sql, Object ... param) throws FinalException {
        List<Object> params = new ArrayList();
        if (CommonUtils.notEmpty(param)) {
            params = Arrays.asList(param);
        }
        return this.nativeUpdate(sql, params);
    }

    @Override
    public int nativeUpdate(String sql, List param) throws FinalException {
        AssertUtils.notEmpty(sql, "sql \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            return this.executeUpdate(new ExSqlEntity(sql, param));
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public void nativeQueryRow(String sql, ResultCallback callback) throws FinalException {
        AssertUtils.notEmpty(sql, "sql \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            this.execute(new ExSqlEntity(sql, null), callback);
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return super.getDataSource();
    }

    @Override
    public Connection getConnection() {
        return super.getConnection();
    }

    @Override
    public void beginTransaction() {
        super.begin();
    }

    @Override
    public void commitTransaction() {
        super.commit();
    }

    @Override
    public void rollbackTransaction() {
        super.rollback();
    }

    @Override
    public boolean isOpenTransaction() {
        return super.isOpenTransaction();
    }

    @Override
    public <T> T getMapper(Class<T> clazz) {
        Object has = this.mappers.get(clazz.getName());
        if (has != null) {
            return (T)has;
        }
        if (!clazz.isInterface()) {
            throw new FinalException("\u64cd\u4f5cdao\u5e94\u8be5\u4e3a\u63a5\u53e3\u7c7b\u578b\uff1a" + clazz.getName());
        }
        T mapper = ClassUtils.getMapper(clazz, new FinalMapperInvocation(clazz, this));
        this.mappers.put(clazz.getName(), mapper);
        return mapper;
    }

    @Override
    public void startPage(Integer currentPage, Integer pageSize) {
        super.startPage(currentPage, pageSize);
    }

    @Override
    public PageInfo getPageInfo() {
        return super.getPageInfo();
    }

    @Override
    public SqlConfig getSqlConfig() {
        return this.sqlConfig;
    }

    private void checkDialect() {
        SqlDialect sqlDialect = this.sqlConfig.getSqlDialect();
        if (sqlDialect == null) {
            DbType dataType = DataSourceUtils.getDataType(this.dataSource);
            switch (dataType) {
                case MYSQL: {
                    this.sqlConfig.setSqlDialect(new Mysql57Dialect());
                    break;
                }
                case POSTGRESQL: {
                    this.sqlConfig.setSqlDialect(new PostgreSqlDialect());
                    break;
                }
                case SQLITE: {
                    this.sqlConfig.setSqlDialect(new Sqlite3Dialect());
                    break;
                }
                default: {
                    throw new FinalException("\u672a\u8bc6\u522b\u7684jdbc\u8fde\u63a5\u9a71\u52a8, \u8bf7\u81ea\u884c\u5b9e\u73b0 SqlDialect \u8fdb\u884c\u914d\u7f6e\u65b9\u8a00");
                }
            }
        }
    }

    private void checkDependencies() {
        try {
            Class.forName("org.slf4j.Logger");
        }
        catch (ClassNotFoundException e) {
            String err = "FinalSql\uff1a \u672a\u5f15\u5165\u4f9d\u8d56 slf4j \uff08<version>1.7.36</version>\u6216\u5176\u4ed6\u7248\u672c\uff09\u8bf7\u5728Maven\u4e2d\u6dfb\u52a0\uff1a\nFinalSql\uff1a -----------------------------------------------\n        <dependency>\n            <groupId>org.slf4j</groupId>\n            <artifactId>slf4j-api</artifactId>\n        </dependency>\nFinalSql\uff1a -----------------------------------------------\n";
            throw new FinalException("FinalSql \u521d\u59cb\u5316\u9519\u8bef: \n" + err);
        }
    }
}

