/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.spring;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.sql.FinalSql;

public class FinalSqlSpringTransactionManagement
extends AbstractPlatformTransactionManager {
    @Autowired
    private ApplicationContext applicationContext;
    private List<FinalSql> finalSqls = null;

    protected Object doGetTransaction() throws TransactionException {
        if (this.finalSqls == null) {
            this.finalSqls = new ArrayList<FinalSql>();
            this.applicationContext.getBeanProvider(FinalSql.class).forEach(finalSql -> this.finalSqls.add((FinalSql)finalSql));
        }
        return this.finalSqls;
    }

    protected void doBegin(Object o, TransactionDefinition transactionDefinition) throws TransactionException {
        for (FinalSql finalSql : this.finalSqls) {
            if (finalSql.isOpenTransaction()) continue;
            finalSql.beginTransaction();
            try {
                finalSql.getConnection().setReadOnly(transactionDefinition.isReadOnly());
                int level = transactionDefinition.getIsolationLevel();
                if (level == -1) continue;
                finalSql.getConnection().setTransactionIsolation(level);
            }
            catch (Exception var5) {
                throw new FinalException(var5);
            }
        }
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        for (FinalSql finalSql : this.finalSqls) {
            finalSql.commitTransaction();
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        for (FinalSql finalSql : this.finalSqls) {
            finalSql.rollbackTransaction();
        }
    }
}

