/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.sql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import top.lingkang.finalsql.annotation.Id;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.constants.IdType;
import top.lingkang.finalsql.dialect.SqlDialect;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.error.FinalSqlException;
import top.lingkang.finalsql.sql.Condition;
import top.lingkang.finalsql.sql.ExSqlEntity;
import top.lingkang.finalsql.utils.ClassUtils;
import top.lingkang.finalsql.utils.NameUtils;
import top.lingkang.finalsql.utils.TabCache;

public class SqlGenerate {
    private SqlDialect dialect;
    private SqlConfig sqlConfig;

    public SqlGenerate(SqlDialect dialect, SqlConfig sqlConfig) {
        this.dialect = dialect;
        this.sqlConfig = sqlConfig;
    }

    public <T> ExSqlEntity querySql(Class<T> clazz, Condition condition) {
        ClassUtils.addToCache(clazz);
        ExSqlEntity exSqlEntity = this.columnAndTable(clazz);
        this.addQueryCondition(exSqlEntity, condition);
        exSqlEntity.setSql("select " + exSqlEntity.getSql());
        return exSqlEntity;
    }

    public <T> ExSqlEntity oneSql(Class<T> clazz, Condition condition) {
        ClassUtils.addToCache(clazz);
        ExSqlEntity exSqlEntity = this.columnAndTable(clazz);
        this.addQueryCondition(exSqlEntity, condition);
        exSqlEntity.setSql(this.dialect.one(exSqlEntity.getSql()));
        return exSqlEntity;
    }

    public <T> ExSqlEntity countSql(Class<T> clazz, Condition condition) {
        ClassUtils.addToCache(clazz);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        exSqlEntity.setSql(" from " + NameUtils.getTableName(clazz, this.dialect));
        this.addQueryCondition(exSqlEntity, condition);
        exSqlEntity.setSql(this.dialect.count(exSqlEntity.getSql()));
        return exSqlEntity;
    }

    public ExSqlEntity selectRowSql(ExSqlEntity exSqlEntity, int row) {
        exSqlEntity.setSql(this.dialect.rowSql(exSqlEntity.getSql(), 0, row));
        return exSqlEntity;
    }

    public <T> ExSqlEntity insertSql(T t) {
        ClassUtils.addToCache(t.getClass());
        return this.insert(t);
    }

    public <T> ExSqlEntity batchInsert(List<T> entity) {
        String sql = "";
        ArrayList<Object> param = new ArrayList<Object>();
        boolean isFirst = false;
        int start = 0;
        int eq = entity.size() - 1;
        for (int i = 0; i < entity.size(); ++i) {
            T t = entity.get(i);
            ExSqlEntity exSqlEntity = this.insertSql(t);
            if (!isFirst) {
                sql = sql + exSqlEntity.getSql() + "";
                start = sql.indexOf("values") + 7;
                isFirst = true;
            } else {
                sql = sql + exSqlEntity.getSql().substring(start);
            }
            sql = i == eq ? sql + ";" : sql + ",\n";
            param.addAll(exSqlEntity.getParam());
        }
        return new ExSqlEntity(sql, param);
    }

    public <T> ExSqlEntity updateSql(T entity, Condition condition) {
        ClassUtils.addToCache(entity.getClass());
        return this.update(entity, condition);
    }

    public <T> ExSqlEntity deleteSql(T entity, Condition condition) {
        ClassUtils.addToCache(entity.getClass());
        return this.delete(entity, condition);
    }

    public <T> ExSqlEntity deleteSql(Class<T> entity, List<Object> ids) {
        return this.deleteByIds(entity, ids);
    }

    private void addQueryCondition(ExSqlEntity exSqlEntity, Condition condition) {
        if (condition != null) {
            ExSqlEntity exSql = condition.getSql();
            if (exSql.getParam() != null) {
                exSqlEntity.setSql(exSqlEntity.getSql() + " where 1=1 " + exSql.getSql());
                exSqlEntity.getParam().addAll(exSql.getParam());
            }
            if (condition.getOrder() != null) {
                exSqlEntity.setSql(exSqlEntity.getSql() + condition.getOrder());
            }
        }
    }

    private <T> void addQueryEntityCondition(T entity, ExSqlEntity exSqlEntity, Condition condition) {
        TabCache tabCache = ClassUtils.tabCache.get(entity.getClass());
        String sql = " where 1=1 ";
        ArrayList<Object> param = new ArrayList<Object>();
        for (int i = 0; i < tabCache.getColumnField().length; ++i) {
            Object value = ClassUtils.getValue(entity, tabCache.getColumnField()[i]);
            if (value == null) continue;
            sql = sql + " and " + tabCache.getColumnName()[i] + "=?";
            param.add(value);
        }
    }

    private <T> ExSqlEntity columnAndTable(Class<T> clazz) {
        TabCache tabCache = ClassUtils.tabCache.get(clazz);
        String col = "";
        for (int i = 0; i < tabCache.getColumnName().length; ++i) {
            col = col + tabCache.getColumnName()[i] + " as " + tabCache.getFieldName()[i] + ", ";
        }
        col = col.substring(0, col.length() - 2);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        exSqlEntity.setSql(col + " from " + NameUtils.getTableName(clazz, this.dialect));
        return exSqlEntity;
    }

    private <T> ExSqlEntity columnAndTableEntity(T entity) {
        TabCache tabCache = ClassUtils.tabCache.get(entity.getClass());
        String col = "";
        for (int i = 0; i < tabCache.getColumnName().length; ++i) {
            col = col + tabCache.getColumnName()[i] + " as " + tabCache.getFieldName()[i] + ", ";
        }
        col = col.substring(0, col.length() - 2);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        exSqlEntity.setSql(col + " from " + tabCache.getTableName());
        return exSqlEntity;
    }

    private <T> ExSqlEntity insert(T entity) {
        Class<?> clazz = entity.getClass();
        TabCache tabCache = ClassUtils.tabCache.get(clazz);
        Field[] declaredFields = tabCache.getColumnField();
        if (declaredFields.length < 1) {
            throw new FinalSqlException("\u63d2\u5165\u5bf9\u8c61\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff1a\u65e0 @Id \u6216 @Column \u6ce8\u89e3\u3002" + clazz);
        }
        if (tabCache.getIdType() == IdType.INPUT && ClassUtils.getValue(entity, tabCache.getIdColumnField()) == null) {
            throw new FinalException("\u5b9e\u4f53\u5bf9\u8c61 @Id \u7c7b\u578b\u4e3a IdType.INPUT\uff0c\u5219\u4e3b\u952e id \u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sql = "insert into " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        String val = "";
        sql = sql + " (";
        ArrayList<Object> param = new ArrayList<Object>();
        for (int index = 0; index < tabCache.getColumnField().length; ++index) {
            Id id;
            Field field = declaredFields[index];
            if (field == tabCache.getIdColumnField() && (id = field.getAnnotation(Id.class)).value() == IdType.AUTO && !"".equals(id.sequence())) {
                String nextval = this.dialect.nextval(id.sequence());
                sql = sql + tabCache.getColumnName()[index] + ", ";
                val = val + nextval + ", ";
                continue;
            }
            Object o = ClassUtils.getValue(entity, field);
            if (o == null) continue;
            sql = sql + tabCache.getColumnName()[index] + ", ";
            param.add(o);
            val = val + "?, ";
        }
        if (param.isEmpty()) {
            throw new FinalSqlException("\u4e0d\u80fd\u63d2\u5165\u7a7a\u5bf9\u8c61\uff1a" + entity);
        }
        exSqlEntity.setParam(param);
        sql = sql.substring(0, sql.length() - 2) + ")";
        sql = sql + " values (" + val.substring(0, val.length() - 2) + ")";
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity update(T entity, Condition condition) {
        Class<?> clazz = entity.getClass();
        TabCache tabCache = ClassUtils.tabCache.get(clazz);
        boolean hasCondition = false;
        if (condition != null && condition.hasWhere()) {
            hasCondition = true;
        }
        if (!hasCondition) {
            if (tabCache.getIdColumnField() == null) {
                throw new FinalSqlException("\u66f4\u65b0\u5bf9\u8c61\u4e2d, \u672a\u6dfb\u52a0@Id\u6ce8\u89e3\u786e\u5b9a\u4e3b\u952e\u5217\uff01" + clazz);
            }
            Object id = ClassUtils.getValue(entity, tabCache.getIdColumnField());
            if (id == null) {
                throw new FinalSqlException("\u66f4\u65b0\u5bf9\u8c61\u4e2d\u4e3b\u952eId\u7684\u503c\u4e3a\u7a7a\uff01");
            }
        }
        String sql = "update " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        sql = sql + " set ";
        String set = "";
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < tabCache.getColumnField().length; ++i) {
            Object value = ClassUtils.getValue(entity, tabCache.getColumnField()[i]);
            if (value == null) continue;
            set = set + ", " + tabCache.getColumnName()[i] + "=?";
            params.add(value);
        }
        if (set.length() > 1) {
            set = set.substring(1);
        }
        sql = sql + set;
        sql = sql + " where 1=1";
        if (hasCondition) {
            ExSqlEntity exSql = condition.getSql();
            sql = sql + exSql.getSql();
            params.addAll(exSql.getParam());
        } else {
            Object idValue = ClassUtils.getValue(entity, tabCache.getIdColumnField());
            sql = sql + " and " + tabCache.getIdColumnName() + "=?";
            params.add(idValue);
        }
        exSqlEntity.setParam(params);
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity delete(T entity, Condition condition) {
        Class<?> clazz = entity.getClass();
        TabCache tabCache = ClassUtils.tabCache.get(clazz);
        Field[] columnField = tabCache.getColumnField();
        String sql = "delete from " + NameUtils.getTableName(clazz, this.dialect);
        ExSqlEntity exSqlEntity = new ExSqlEntity();
        sql = sql + " where 1=1";
        ArrayList<Object> param = new ArrayList<Object>();
        for (int i = 0; i < columnField.length; ++i) {
            Object value = ClassUtils.getValue(entity, columnField[i]);
            if (value == null) continue;
            sql = sql + " and " + tabCache.getColumnName()[i] + "=?";
            param.add(value);
        }
        boolean hasCondition = false;
        if (condition != null && condition.hasWhere()) {
            hasCondition = true;
        }
        if (param.size() == 0 && !hasCondition) {
            throw new FinalSqlException("\u4e0d\u652f\u6301\u4f7f\u7528\u6574\u8868\u6570\u636e\u5220\u9664\uff0c\u8bf7\u6dfb\u52a0\u53c2\u6570\u6761\u4ef6\uff01\u5b9e\u4f53\u7c7b\uff1a" + entity.getClass() + "\n \u82e5\u60f3\u6574\u8868\u6570\u636e\u5220\u9664\uff0c\u53ef\u6dfb\u52a0\u6761\u4ef6 1=1");
        }
        if (hasCondition) {
            ExSqlEntity exSql = condition.getSql();
            sql = sql + exSql.getSql();
            param.addAll(exSql.getParam());
        }
        exSqlEntity.setParam(param);
        exSqlEntity.setSql(sql);
        return exSqlEntity;
    }

    private <T> ExSqlEntity deleteByIds(Class<T> t, List<Object> ids) {
        String sql = "delete from " + NameUtils.getTableName(t, this.dialect);
        Field idColumn = ClassUtils.getIdColumn(t.getDeclaredFields());
        if (idColumn == null) {
            throw new FinalException("\u5bf9\u8c61\u4e2d\u627e\u4e0d\u5230 @Id \u6ce8\u89e3\uff0c\u65e0\u6cd5\u83b7\u53d6 Id \u5b57\u6bb5");
        }
        sql = sql + " where " + NameUtils.unHump(idColumn.getName()) + " in (" + Condition.getIn(ids.size()) + ")";
        return new ExSqlEntity(sql, ids);
    }

    public ExSqlEntity humpUpdate(String sql, List params) {
        return new ExSqlEntity(NameUtils.unHump(sql), params);
    }
}

