/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.ui;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ToastUtil {
    public static void toast(String msg, Window window) {
        ToastUtil.toast(msg, 3000, window);
    }

    public static void toast(String msg, final int time, Window window) {
        if (msg == null || msg.length() == 0) {
            throw new RuntimeException("msg\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        final Stage stage = new Stage();
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setResizable(false);
        stage.initModality(Modality.NONE);
        stage.initOwner(window);
        Label label = new Label(msg);
        label.setStyle("-fx-background: rgba(56,56,56,0.6);-fx-border-radius: 25;-fx-background-radius: 20");
        label.setTextFill((Paint)Color.valueOf((String)"white"));
        label.setPrefHeight(44.0);
        label.setPadding(new Insets(15.0));
        label.setAlignment(Pos.CENTER);
        label.setFont(new Font(16.0));
        Scene scene = new Scene((Parent)label);
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setScene(scene);
        double x = window.getX() + window.getWidth() / 2.0;
        double y = window.getY() + window.getHeight() / 2.0;
        stage.setX(x - (double)(16 * msg.length() / 2));
        stage.setY(y - 22.0);
        stage.show();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> stage.close());
            }
        }).start();
    }
}

