/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import top.lingkang.finalsql.annotation.Column;
import top.lingkang.finalsql.annotation.Id;
import top.lingkang.finalsql.annotation.Nullable;
import top.lingkang.finalsql.annotation.Table;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.error.FinalCheckException;
import top.lingkang.finalsql.error.FinalException;
import top.lingkang.finalsql.type.BigDecimalTypeHandler;
import top.lingkang.finalsql.type.BigIntegerTypeHandler;
import top.lingkang.finalsql.type.BlobTypeHandler;
import top.lingkang.finalsql.type.BooleanTypeHandler;
import top.lingkang.finalsql.type.ByteArrayTypeHandler;
import top.lingkang.finalsql.type.ByteObjectArrayTypeHandler;
import top.lingkang.finalsql.type.DateTypeHandler;
import top.lingkang.finalsql.type.DoubleTypeHandler;
import top.lingkang.finalsql.type.FloatTypeHandler;
import top.lingkang.finalsql.type.IntegerTypeHandler;
import top.lingkang.finalsql.type.LongTypeHandler;
import top.lingkang.finalsql.type.ObjectTypeHandler;
import top.lingkang.finalsql.type.StringTypeHandler;
import top.lingkang.finalsql.type.TypeHandler;
import top.lingkang.finalsql.utils.CommonUtils;
import top.lingkang.finalsql.utils.NameUtils;
import top.lingkang.finalsql.utils.TabCache;

public class ClassUtils {
    public static final HashMap<Class<?>, TabCache> tabCache = new HashMap();
    private static final HashMap<String, Class> typeMap;
    public static SqlConfig sqlConfig;
    public static final HashMap<Class<?>, TypeHandler> typeHandler;

    public static <T> Field getIdColumn(Field[] df) {
        for (Field field : df) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return field;
        }
        return null;
    }

    public static <T> Class<? extends Object> getClass(T entity) {
        if (!(entity instanceof Class)) {
            return entity.getClass();
        }
        try {
            return ((Class)entity).newInstance().getClass();
        }
        catch (Exception e) {
            throw new FinalException(e);
        }
    }

    public static Field[] getBeanField(Class<?> clazz) {
        TabCache cache = tabCache.get(clazz);
        if (cache != null) {
            return cache.getFields();
        }
        ClassUtils.addToCache(clazz);
        return tabCache.get(clazz).getFields();
    }

    public static void addToCache(Class<?> clazz) {
        if (tabCache.containsKey(clazz)) {
            return;
        }
        if (clazz.getAnnotation(Table.class) == null) {
            throw new FinalCheckException("\u8868\u5bf9\u8c61\u65e0 @Table \u6ce8\u89e3: " + clazz);
        }
        TabCache cache = new TabCache();
        Field idColumnField = null;
        String idColumnName = null;
        ArrayList<String> columnName = new ArrayList<String>();
        ArrayList<Field> columnField = new ArrayList<Field>();
        ArrayList<TypeHandler> typeHandlers = new ArrayList<TypeHandler>();
        ArrayList<String> fieldName = new ArrayList<String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < clazz.getDeclaredFields().length; ++i) {
            Column column;
            Field field = clazz.getDeclaredFields()[i];
            fieldName.add(field.getName());
            fields.add(field);
            typeHandlers.add(ClassUtils.setTypeHandler(field.getType()));
            Id id = field.getAnnotation(Id.class);
            if (id != null) {
                if (idColumnField != null) {
                    throw new FinalCheckException("\u8868\u5bf9\u8c61\u5b58\u5728\u591a\u4e2a @Id \u6ce8\u89e3: " + clazz);
                }
                idColumnField = field;
                cache.setIdType(id.value());
                column = field.getAnnotation(Column.class);
                String name = null;
                name = column != null ? (CommonUtils.isEmpty(column.value()) ? NameUtils.unHump(field.getName()) : column.value()) : NameUtils.unHump(field.getName());
                columnName.add(name);
                columnField.add(field);
                idColumnName = name;
                continue;
            }
            column = field.getAnnotation(Column.class);
            if (column == null) continue;
            columnName.add(CommonUtils.isEmpty(column.value()) ? NameUtils.unHump(field.getName()) : column.value());
            columnField.add(field);
        }
        if (columnField.isEmpty()) {
            throw new FinalCheckException("\u8868\u5bf9\u8c61\u65e0 @Id \u6216\u8005 @Column  \u6ce8\u89e3: " + clazz);
        }
        cache.setColumnField(columnField.toArray(new Field[0]));
        cache.setColumnName(columnName.toArray(new String[0]));
        if (idColumnField != null) {
            cache.setIdColumnField(idColumnField);
            cache.setIdColumnName(idColumnName);
        }
        if (!fieldName.isEmpty()) {
            cache.setFieldName(fieldName.toArray(new String[0]));
        }
        if (!fields.isEmpty()) {
            cache.setFields(fields.toArray(new Field[0]));
        }
        cache.setTypeHandler(typeHandlers.toArray(new TypeHandler[0]));
        cache.setClazz(clazz);
        cache.setTableName(NameUtils.getTableName(clazz, sqlConfig.getSqlDialect()));
        tabCache.put(clazz, cache);
    }

    public static TypeHandler setTypeHandler(Class<?> clazz) {
        TypeHandler<Object> type = typeHandler.get(clazz);
        return type == null ? new ObjectTypeHandler() : type;
    }

    @Nullable
    public static Id getId(Class<?> clazz) {
        ClassUtils.addToCache(clazz);
        TabCache tabCache = ClassUtils.tabCache.get(clazz);
        if (tabCache != null && tabCache.getIdColumnName() != null) {
            return tabCache.getIdColumnField().getAnnotation(Id.class);
        }
        return null;
    }

    @Nullable
    public static Field getField(String name, Field[] df) {
        for (Field field : df) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static <T> Object getValue(T t, Field field) {
        try {
            field.setAccessible(true);
            return field.get(t);
        }
        catch (IllegalAccessException e) {
            throw new FinalException(e);
        }
    }

    public static boolean isBaseWrapper(Class o) {
        return typeMap.containsKey(o.getSimpleName());
    }

    public static <T> T getMapper(Class<T> clazz, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    public static Field getFieldByColumnLabel(String label, TabCache tabCache) {
        for (int i = 0; i < tabCache.getColumnName().length; ++i) {
            if (!tabCache.getColumnName()[i].equals(label)) continue;
            return tabCache.getColumnField()[i];
        }
        return null;
    }

    public static Field getFieldByFieldName(String name, TabCache tabCache) {
        for (int i = 0; i < tabCache.getFieldName().length; ++i) {
            if (!tabCache.getFieldName()[i].equals(name)) continue;
            return tabCache.getFields()[i];
        }
        return null;
    }

    static {
        typeHandler = new HashMap();
        typeMap = new HashMap();
        typeMap.put("String", String.class);
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.TYPE);
        typeMap.put("Long", Long.class);
        typeMap.put("long", Long.TYPE);
        typeMap.put("Date", Date.class);
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("Float", Float.class);
        typeHandler.put(String.class, new StringTypeHandler());
        typeHandler.put(BigDecimal.class, new BigDecimalTypeHandler());
        typeHandler.put(BigInteger.class, new BigIntegerTypeHandler());
        typeHandler.put(Boolean.class, new BooleanTypeHandler());
        typeHandler.put(byte[].class, new ByteArrayTypeHandler());
        typeHandler.put(Byte[].class, new ByteObjectArrayTypeHandler());
        typeHandler.put(Date.class, new DateTypeHandler());
        typeHandler.put(Double.class, new DoubleTypeHandler());
        typeHandler.put(Float.class, new FloatTypeHandler());
        typeHandler.put(Integer.class, new IntegerTypeHandler());
        typeHandler.put(Long.class, new LongTypeHandler());
        typeHandler.put(Object.class, new ObjectTypeHandler());
        typeHandler.put(Blob.class, new BlobTypeHandler());
        typeHandler.put(Long.TYPE, new LongTypeHandler());
        typeHandler.put(Integer.TYPE, new IntegerTypeHandler());
        typeHandler.put(Double.TYPE, new DoubleTypeHandler());
        typeHandler.put(Float.TYPE, new FloatTypeHandler());
    }
}

