/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.ui;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import top.lingkang.finalsql.sql.FinalSql;
import top.lingkang.finalsql.ui.GenerateBuild;
import top.lingkang.finalsql.ui.GenerateColumn;
import top.lingkang.finalsql.ui.GenerateProperties;
import top.lingkang.finalsql.ui.GenerateUtils;

class GenerateBuildMysql
implements GenerateBuild {
    private final String sql_tables = "select TABLE_NAME from information_schema.TABLES where TABLE_SCHEMA=(select database());";
    private final String sql_column = "select COLUMN_NAME,DATA_TYPE,COLUMN_COMMENT,COLUMN_KEY from information_schema.COLUMNS where TABLE_SCHEMA = (select database()) and TABLE_NAME=?;";

    GenerateBuildMysql() {
    }

    @Override
    public void build(FinalSql finalSql, GenerateProperties properties) {
        List<String> tables = finalSql.selectForList("select TABLE_NAME from information_schema.TABLES where TABLE_SCHEMA=(select database());", String.class);
        if (tables.isEmpty()) {
            return;
        }
        String pageName = GenerateUtils.getPage(properties.getOutDir());
        String template = GenerateUtils.readFile(GenerateBuildMysql.class.getClassLoader().getResourceAsStream("template-mysql5.7.txt"));
        if (!GenerateUtils.isBlank(pageName)) {
            pageName = "package " + pageName + ";";
        }
        template = template.replace("#package", pageName);
        String ignoreTablePrefix = properties.getIgnoreTablePrefix();
        String ignoreTables = properties.getIgnoreTable();
        ArrayList<String> ignoreTable = new ArrayList<String>();
        if (ignoreTables != null) {
            String[] s;
            for (String str : s = ignoreTables.replaceAll(" ", "").split(",")) {
                ignoreTable.add(str.replaceAll("\\*", "[0-9a-zA-Z_]{0,}"));
            }
        }
        HashSet<String> hasClassName = new HashSet<String>();
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (String table : tables) {
            String className;
            if (!ignoreTable.isEmpty()) {
                boolean jump = false;
                for (String str : ignoreTable) {
                    if (!Pattern.matches(str, table)) continue;
                    jump = true;
                    break;
                }
                if (jump) continue;
            }
            if (hasClassName.contains(className = GenerateUtils.handlerTableName(table, ignoreTablePrefix))) {
                className = GenerateUtils.hasSomeName(className, hasClassName);
            }
            hasClassName.add(className);
            String t = template;
            t = t.replace("#date", date);
            t = t.replace("#table", table);
            t = t.replace("#className", className);
            HashSet<String> impl = new HashSet<String>();
            List<Map> columns = finalSql.selectForList("select COLUMN_NAME,DATA_TYPE,COLUMN_COMMENT,COLUMN_KEY from information_schema.COLUMNS where TABLE_SCHEMA = (select database()) and TABLE_NAME=?;", Map.class, table);
            int keyNumber = 0;
            ArrayList<GenerateColumn> generateColumns = new ArrayList<GenerateColumn>();
            for (Map map : columns) {
                String column_name = (String)map.get("COLUMN_NAME");
                String data_type = (String)map.get("DATA_TYPE");
                String column_comment = (String)map.get("COLUMN_COMMENT");
                String column_key = (String)map.get("COLUMN_KEY");
                GenerateColumn column = GenerateUtils.columnTypeToJavaType(column_name, data_type, "mysql");
                column.setComment(column_comment);
                if (!GenerateUtils.isBlank(column_key)) {
                    ++keyNumber;
                    column.setKey(true);
                }
                generateColumns.add(column);
                if (column.getImportName() == null) continue;
                impl.add(column.getImportName());
            }
            String imports = "";
            for (String im : impl) {
                imports = imports + im + "\n";
            }
            t = t.replace("#import", imports);
            String string = GenerateUtils.columnToString(generateColumns, keyNumber);
            t = t.replace("#entity", string);
            System.out.println(t);
            File file = new File(properties.getOutDir() + File.separator + className + ".java");
            if (file.exists() && !properties.isCover()) continue;
            GenerateUtils.writeFile(file, t);
        }
    }
}

