/*
 * Decompiled with CFR 0.152.
 */
package top.lingkang.finalsql.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import top.lingkang.finalsql.config.SqlConfig;
import top.lingkang.finalsql.dev.FinalSqlDevDataSource;
import top.lingkang.finalsql.sql.FinalSql;
import top.lingkang.finalsql.sql.core.FinalSqlManage;
import top.lingkang.finalsql.ui.GenerateBuild;
import top.lingkang.finalsql.ui.GenerateBuildMysql;
import top.lingkang.finalsql.ui.GenerateProperties;
import top.lingkang.finalsql.ui.GenerateUtils;
import top.lingkang.finalsql.ui.ToastUtil;

public class GenerateUIController
implements Initializable {
    @FXML
    private ComboBox<String> driverName;
    @FXML
    private ComboBox<String> comboBoxBuild;
    @FXML
    private Button selectDir;
    @FXML
    private Button build;
    @FXML
    private TextField pack;
    @FXML
    private TextField url;
    @FXML
    private TextField username;
    @FXML
    private TextField password;
    @FXML
    private TextField ignoreTablePrefix;
    @FXML
    private TextField ignoreTable;
    @FXML
    private CheckBox cover;
    private GenerateBuild generateBuild;
    public File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "final-sql-ui.properties");
    public Properties conf = new Properties();

    public void initialize(URL location, ResourceBundle resources) {
        try {
            if (this.file.exists()) {
                this.conf.load(new FileInputStream(this.file));
                this.url.setText(this.conf.getProperty("url"));
                this.password.setText(this.conf.getProperty("password"));
                this.username.setText(this.conf.getProperty("username"));
                this.ignoreTablePrefix.setText(this.conf.getProperty("ignoreTablePrefix"));
                this.ignoreTable.setText(this.conf.getProperty("ignoreTable"));
                this.cover.setSelected(Boolean.parseBoolean(this.conf.getProperty("cover", "true")));
            } else {
                this.file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("\u914d\u7f6e\u6587\u4ef6\u8def\u5f84" + this.file.getAbsolutePath() + "\n\u6240\u5728\u76ee\u5f55\uff1a" + this.file.getParentFile().getAbsolutePath());
        this.driverName.setItems(FXCollections.observableArrayList((Object[])new String[]{"com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver"}));
        this.driverName.getSelectionModel().select(Integer.parseInt(this.conf.getProperty("driverIndex", "0")));
        this.comboBoxBuild.setItems(FXCollections.observableArrayList((Object[])new String[]{"mysql5.7\u751f\u6210\u5668", "postgre\u751f\u6210\u5668"}));
        this.comboBoxBuild.getSelectionModel().select(Integer.parseInt(this.conf.getProperty("buildIndex", "0")));
        this.driverName.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            int index = this.driverName.getSelectionModel().getSelectedIndex();
            if (index >= 0 && index <= 1) {
                this.comboBoxBuild.getSelectionModel().select(0);
            }
            this.conf.setProperty("driverIndex", index + "");
        });
        this.comboBoxBuild.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.conf.setProperty("buildIndex", this.comboBoxBuild.getSelectionModel().getSelectedIndex() + ""));
        this.cover.selectedProperty().addListener((observable, oldValue, newValue) -> this.conf.setProperty("cover", newValue.toString()));
        this.pack.setText(this.conf.getProperty("packageDir", ""));
        this.selectDir.setOnMouseClicked(event -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setInitialDirectory(new File(GenerateUtils.getBasePath()));
            directoryChooser.setTitle("\u9009\u62e9\u5b9e\u4f53\u7c7b\u76ee\u5f55");
            File file = directoryChooser.showDialog(this.selectDir.getScene().getWindow());
            if (file != null && file.isDirectory()) {
                this.pack.setText(file.getAbsolutePath());
                this.conf.setProperty("packageDir", file.getAbsolutePath());
            } else {
                ToastUtil.toast("\u8f93\u51fa\u5305\u8def\u5f84\u9519\u8bef", this.selectDir.getScene().getWindow());
            }
        });
        this.build.setOnMouseClicked(event -> {
            if (this.isBlank(this.pack.getText())) {
                ToastUtil.toast("\u8f93\u51fa\u5305\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", this.selectDir.getScene().getWindow());
                this.pack.requestFocus();
                return;
            }
            if (!new File(this.pack.getText()).isDirectory()) {
                ToastUtil.toast("\u8f93\u51fa\u5305\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u76ee\u5f55", this.selectDir.getScene().getWindow());
                this.pack.requestFocus();
                return;
            }
            if (!new File(this.pack.getText()).exists()) {
                ToastUtil.toast("\u8f93\u51fa\u5305\u8def\u5f84\u662f\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684\u6587\u4ef6\u76ee\u5f55", this.selectDir.getScene().getWindow());
                this.pack.requestFocus();
                return;
            }
            FinalSql finalSql = null;
            try {
                finalSql = this.getFinalSql();
                finalSql.beginTransaction();
                if (this.comboBoxBuild.getSelectionModel().getSelectedIndex() == 0) {
                    this.generateBuild = new GenerateBuildMysql();
                }
                if (this.generateBuild == null) {
                    ToastUtil.toast("\u672a\u8bc6\u522b\u7684\u751f\u6210\u5b9e\u73b0", this.selectDir.getScene().getWindow());
                    return;
                }
                GenerateProperties properties = new GenerateProperties();
                properties.setCover(this.cover.isSelected());
                properties.setOutDir(this.pack.getText());
                properties.setIgnoreTablePrefix(this.ignoreTablePrefix.getText());
                if (!this.isBlank(this.ignoreTable.getText())) {
                    properties.setIgnoreTable(this.ignoreTable.getText());
                }
                this.generateBuild.build(finalSql, properties);
                finalSql.commitTransaction();
                this.storeProperties();
                ToastUtil.toast("\u5b9e\u4f53\u751f\u6210\u6210\u529f", this.selectDir.getScene().getWindow());
            }
            catch (Exception e) {
                this.showError(e);
                e.printStackTrace();
            }
            finally {
                if (finalSql != null && finalSql.getConnection() != null) {
                    try {
                        finalSql.getConnection().close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    private void storeProperties() {
        try {
            if (this.url.getText() != null) {
                this.conf.setProperty("url", this.url.getText());
            }
            if (this.username.getText() != null) {
                this.conf.setProperty("username", this.username.getText());
            }
            if (this.password.getText() != null) {
                this.conf.setProperty("password", this.password.getText());
            }
            if (this.ignoreTablePrefix.getText() != null) {
                this.conf.setProperty("ignoreTablePrefix", this.ignoreTablePrefix.getText());
            }
            if (this.cover != null) {
                this.conf.setProperty("cover", this.cover.isSelected() ? "true" : "false");
            }
            if (this.ignoreTable.getText() != null) {
                this.conf.setProperty("ignoreTable", this.ignoreTable.getText());
            }
            this.conf.store(new FileOutputStream(this.file), "commit");
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    private FinalSql getFinalSql() {
        FinalSqlDevDataSource dataSource = new FinalSqlDevDataSource((String)this.driverName.getSelectionModel().getSelectedItem(), this.isBlank(this.url.getText()) ? this.url.getPromptText() : this.url.getText(), this.isBlank(this.username.getText()) ? this.username.getPromptText() : this.username.getText(), this.isBlank(this.password.getText()) ? this.password.getPromptText() : this.password.getText());
        SqlConfig sqlConfig = new SqlConfig(dataSource);
        sqlConfig.setShowLog(true);
        return new FinalSqlManage(sqlConfig);
    }

    private boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }

    private void showError(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String exceptionText = sw.toString();
        Stage stage = new Stage();
        stage.initOwner(this.build.getScene().getWindow());
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle("\u51fa\u73b0\u5f02\u5e38");
        stage.setMinWidth(500.0);
        stage.setMinHeight(360.0);
        stage.setScene(new Scene((Parent)new TextArea(exceptionText)));
        stage.show();
    }
}

